/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.sdk.AVTextConverter;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AVTextPart
extends AVPart
implements AVStringComponent,
VerifyListener {
    private Text text;
    private AVTextConverter converter;
    private boolean labelAlignLeft;
    private boolean noborder;
    private boolean fill;

    public AVTextPart(AVData data, Composite parent, String title, AVTextConverter converter) {
        this(data, parent, title, converter, false);
    }

    public AVTextPart(AVData data, Composite parent, String title, AVTextConverter converter, boolean labelAlignLeft) {
        this(data, parent, title, converter, labelAlignLeft, false, false);
    }

    public AVTextPart(AVData data, Composite parent, String title, AVTextConverter converter, boolean labelAlignLeft, boolean noborder, boolean fill) {
        super(data, parent, title);
        this.converter = converter;
        this.labelAlignLeft = labelAlignLeft;
        this.noborder = noborder;
        this.fill = fill;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addKeyListener((KeyListener)this);
            this.text.addModifyListener((ModifyListener)this);
            this.text.addMouseListener((MouseListener)this);
            this.text.addVerifyListener((VerifyListener)this);
        }
    }

    protected void createContents() {
        Object data;
        if (this.getTitle() != null) {
            this.initializeContainer(this.labelAlignLeft ? 2 : 1, this.fill);
            this.createLabel();
            if (this.labelAlignLeft) {
                WidgetUtil.setVerticalAlignment((Control)this.getAccLabel(), 1);
            }
        } else {
            this.initializeContainer(1, this.fill);
        }
        this.text = WidgetUtil.createTextArea(this.getWidgetFactory(), this.getContainer(), 5, this.noborder);
        this.addListeners();
        if (this.fill && (data = this.text.getLayoutData()) instanceof GridData) {
            ((GridData)data).widthHint = 0;
        }
        this.setControls(new Control[]{this.text});
    }

    @Override
    public void dispose() {
        super.dispose();
        AVTextPart.dispose((Widget)this.text);
        this.text = null;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        return super.getFocusControl();
    }

    public String getString() {
        String string = this.text.getText();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public Text getTextControl() {
        return this.text;
    }

    @Override
    public String getValue() {
        return this.getString();
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) != 0) {
            super.keyPressed(e);
        }
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeKeyListener((KeyListener)this);
            this.text.removeModifyListener((ModifyListener)this);
            this.text.removeMouseListener((MouseListener)this);
            this.text.removeVerifyListener((VerifyListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.text.setText("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    protected void setValue(String string) {
        if (string != null && this.converter != null) {
            string = this.converter.convertLineDelimiters(string, null);
        }
        this.text.setText(string != null ? string : "");
    }

    @Override
    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
            this.setEnabled(data.isEditable());
        } else {
            this.reset();
        }
    }

    public void verifyText(VerifyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) != 0) {
            e.doit = false;
        }
    }
}

