/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVTableComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AVTableEditorPart
extends AVPart
implements AVTableComponent {
    protected boolean check;
    protected boolean multiple;
    protected boolean updown;
    protected Table table;
    protected TableColumn[] tableColumns;
    protected TableItem itemChecked;
    private String value;

    public AVTableEditorPart(AVData data, Composite parent, String title, boolean check, boolean multiple, boolean updown) {
        super(data, parent, title);
        this.check = check;
        this.multiple = multiple;
        this.updown = updown;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.table != null) {
            this.table.addSelectionListener((SelectionListener)this);
            this.table.addFocusListener((FocusListener)this);
        }
    }

    protected abstract void createButtons();

    protected void createContents() {
        int rowsSize = this.getRowsSize();
        boolean fill = rowsSize <= 0;
        this.initializeContainer(2, fill);
        if (this.getTitle() != null) {
            this.createLabel();
            WidgetUtil.setHorizontalSpan((Control)this.getAccLabel(), 2);
        }
        this.table = WidgetUtil.createTable(this.getWidgetFactory(), this.getContainer(), fill, this.check, this.multiple);
        if (fill) {
            WidgetUtil.setHeightHint((Control)this.table, 0);
            WidgetUtil.setWidthHint((Control)this.table, 0);
        } else {
            GridData gridData = new GridData(770);
            gridData.heightHint = rowsSize;
            gridData.widthHint = 0;
            this.table.setLayoutData((Object)gridData);
        }
        if (this.isHeaderVisible()) {
            String[] headerNames = this.getColumnNames();
            int[] headerSizes = this.getColumnSizes();
            int headerLen = this.getColumnCountDef();
            this.table.setHeaderVisible(true);
            this.tableColumns = new TableColumn[headerLen];
            for (int i = 0; i < headerLen; ++i) {
                this.tableColumns[i] = WidgetUtil.createTableColumn(this.getWidgetFactory(), this.table, 0);
                if (i < headerNames.length) {
                    this.tableColumns[i].setText(headerNames[i]);
                }
                if (i >= headerSizes.length) continue;
                this.tableColumns[i].setWidth(headerSizes[i]);
            }
        } else {
            this.table.setHeaderVisible(false);
        }
        this.table.setLinesVisible(this.isLinesVisible());
        this.addListeners();
        this.createButtons();
    }

    @Override
    public void dispose() {
        super.dispose();
        AVTableEditorPart.dispose((Widget)this.table);
        this.table = null;
        if (this.tableColumns != null) {
            for (int i = 0; i < this.tableColumns.length; ++i) {
                AVTableEditorPart.dispose((Widget)this.tableColumns[i]);
                this.tableColumns[i] = null;
            }
            this.tableColumns = null;
        }
    }

    protected abstract void enableButtons();

    protected String[] extractDisplayStrings(int row) {
        Object[] items = this.getItems();
        if (items != null && 0 <= row && row < items.length) {
            return this.extractDisplayStrings(items[row]);
        }
        return null;
    }

    protected String[] extractDisplayStrings(Object item) {
        if (item != null && item instanceof Object[]) {
            Object[] valueItems = (Object[])item;
            String[] strings = new String[valueItems.length];
            for (int i = 0; i < valueItems.length; ++i) {
                if (valueItems[i] == null || !(valueItems[i] instanceof AVValueItem)) continue;
                strings[i] = ((AVValueItem)valueItems[i]).getDisplayString();
            }
            return strings;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getColumnCount();
        }
        return 0;
    }

    public int getColumnCountDef() {
        String[] names = this.getColumnNames();
        return names != null ? names.length : 0;
    }

    @Override
    public AVValueItem[] getColumnItems(int column) {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getColumnItems(column);
        }
        return null;
    }

    protected abstract String[] getColumnNames();

    protected int[] getColumnSizes() {
        int[] sizes = new int[this.getColumnCountDef()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = 100;
        }
        return sizes;
    }

    @Override
    public int[] getColumnSelectionIndex() {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getColumnSelectionIndex();
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    @Override
    public Control getFocusControl() {
        if (this.table.isFocusControl()) {
            return this.table;
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getItemCount();
        }
        return 0;
    }

    @Override
    public Object[] getItems() {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getItems();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getRowCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getRowItems(int row) {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)((Object)data)).getRowItems(row);
        }
        return null;
    }

    @Override
    public int[] getRowSelectionIndex() {
        if (this.table != null) {
            return this.table.getSelectionIndices();
        }
        return null;
    }

    protected int getRowsSize() {
        return 100;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected void handleTableSelected(SelectionEvent e) {
        this.setRowSelectionIndex(this.table.getSelectionIndices());
    }

    protected void handleMouseDown(MouseEvent e) {
        this.setColumnSelectionIndex(null);
        TableItem[] items = this.table.getSelection();
        if (e.button == 1 && items.length == 1) {
            TableItem tableItem = items[0];
            int columns = this.table.getColumnCount();
            for (int i = 0; i < columns; ++i) {
                Rectangle bounds = tableItem.getBounds(i);
                if (!bounds.contains(e.x, e.y)) continue;
                this.setColumnSelectionIndex(new int[]{i});
                break;
            }
        }
    }

    public boolean isHeaderVisible() {
        return true;
    }

    protected boolean isLinesVisible() {
        return false;
    }

    public void removeAll() {
        this.table.removeAll();
        this.itemChecked = null;
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.table != null) {
            this.table.removeSelectionListener((SelectionListener)this);
            this.table.removeFocusListener((FocusListener)this);
        }
    }

    @Override
    public void mouseDown(MouseEvent e) {
        if (e.widget == this.table) {
            this.handleMouseDown(e);
        }
        super.mouseDown(e);
    }

    @Override
    public void setColumnSelectionIndex(int[] indices) {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            ((AVTableComponent)((Object)data)).setColumnSelectionIndex(indices);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    @Override
    public void setRowSelectionIndex(int[] indices) {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            ((AVTableComponent)((Object)data)).setRowSelectionIndex(indices);
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.table) {
            this.handleTableSelected(e);
        }
        super.widgetSelected(e);
    }
}

