/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.utils.ControlUtil;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AVStringPart
extends AVPart
implements AVStringComponent {
    protected Text text;
    private boolean readonly;

    public AVStringPart(AVData data, Composite parent, String title) {
        this(data, parent, title, false);
    }

    public AVStringPart(AVData data, Composite parent, String title, boolean readonly) {
        super(data, parent, title);
        this.readonly = readonly;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addKeyListener((KeyListener)this);
            this.text.addModifyListener((ModifyListener)this);
            this.text.addMouseListener((MouseListener)this);
        }
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(2);
            this.createLabel();
        } else {
            this.initializeContainer(1);
        }
        this.text = WidgetUtil.createTextField(this.getWidgetFactory(), this.getContainer(), true, this.readonly);
        ControlUtil.setPreferredWidth((Control)this.text);
        this.addListeners();
        this.setControls(new Control[]{this.text});
    }

    @Override
    public void dispose() {
        super.dispose();
        AVStringPart.dispose((Widget)this.text);
        this.text = null;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        return super.getFocusControl();
    }

    public String getString() {
        String string = this.text.getText();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public Text getTextControl() {
        return this.text;
    }

    @Override
    public String getValue() {
        return this.getString();
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeKeyListener((KeyListener)this);
            this.text.removeModifyListener((ModifyListener)this);
            this.text.removeMouseListener((MouseListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.text.setText("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public void setString(String string) {
        this.text.setText(string != null ? string : "");
    }

    @Override
    public void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            this.setString(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }
}

