/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.internal.ImageDescriptorUtil;
import com.ibm.etools.attrview.sdk.AVStatusReporter;
import com.ibm.etools.attrview.sdk.AVValidator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionBars;

public class AVStatusReporterImpl
implements AVStatusReporter {
    private AttributesView attrView;
    private Image infoIcon;
    private Image warnIcon;
    private Image errorIcon;

    public AVStatusReporterImpl(AttributesView attrView) {
        this.attrView = attrView;
        this.infoIcon = ImageDescriptorUtil.createFullTskImageDescriptor("info_tsk.gif").createImage();
        this.warnIcon = ImageDescriptorUtil.createFullTskImageDescriptor("warn_tsk.gif").createImage();
        this.errorIcon = ImageDescriptorUtil.createFullTskImageDescriptor("error_tsk.gif").createImage();
    }

    @Override
    public void clear() {
        IStatusLineManager mgr = this.getStatusLineManager();
        if (mgr instanceof SubStatusLineManager) {
            ((SubStatusLineManager)mgr).setVisible(false);
            mgr.setErrorMessage(null);
        }
    }

    private IStatusLineManager getStatusLineManager() {
        IActionBars bars;
        if (this.attrView != null && (bars = this.attrView.getActionBars()) != null) {
            return bars.getStatusLineManager();
        }
        return null;
    }

    @Override
    public void report(AVValidator validator) {
        if (validator != null && validator.getErrorLevel() != 0) {
            IStatusLineManager mgr;
            boolean isError = true;
            String msg = validator.getErrorMessage();
            Image icon = null;
            if (validator.getErrorLevel() == 4) {
                icon = this.infoIcon;
                isError = false;
            } else if (validator.getErrorLevel() == 2) {
                icon = this.warnIcon;
            } else if (validator.getErrorLevel() == 3) {
                icon = this.errorIcon;
            }
            if (msg != null && (mgr = this.getStatusLineManager()) instanceof SubStatusLineManager) {
                ((SubStatusLineManager)mgr).setVisible(msg != null);
                if (icon != null) {
                    if (isError) {
                        mgr.setErrorMessage(icon, msg);
                    } else {
                        mgr.setMessage(icon, msg);
                    }
                } else if (isError) {
                    mgr.setErrorMessage(msg);
                } else {
                    mgr.setMessage(msg);
                }
            }
        } else {
            this.clear();
        }
    }

    public void dispose() {
        if (this.infoIcon != null && !this.infoIcon.isDisposed()) {
            this.infoIcon.dispose();
            this.infoIcon = null;
        }
        if (this.warnIcon != null && !this.warnIcon.isDisposed()) {
            this.warnIcon.dispose();
            this.warnIcon = null;
        }
        if (this.errorIcon != null && !this.errorIcon.isDisposed()) {
            this.errorIcon.dispose();
            this.errorIcon = null;
        }
    }
}

