/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.ValueItem;
import com.ibm.etools.attrview.utils.StringUtil;
import java.util.Vector;

public class AVSelectionTable {
    private Vector items;
    private boolean ignoreCase = true;

    public AVSelectionTable() {
        this(null, null, true);
    }

    public AVSelectionTable(boolean ignoreCase) {
        this(null, null, ignoreCase);
    }

    public AVSelectionTable(String[] values) {
        this(values, values, true);
    }

    public AVSelectionTable(String[] values, boolean ignoreCase) {
        this(values, values, ignoreCase);
    }

    public AVSelectionTable(String[] values, String[] displayStrings) {
        this(values, displayStrings, true);
    }

    public AVSelectionTable(String[] values, String[] displayStrings, boolean ignoreCase) {
        this.setIgnoreCase(ignoreCase);
        if (values != null) {
            this.setItems(values, displayStrings);
        }
    }

    public void add(AVSelectionTable table) {
        if (table != null) {
            for (int i = 0; i < table.getItemCount(); ++i) {
                this.addItem((AVValueItem)table.items.get(i));
            }
        }
    }

    private void addItem(AVValueItem item) {
        this.addItem(item.getValue(), item.getDisplayString());
    }

    public void addItem(String value) {
        this.addItem(value, value);
    }

    public void addItem(String value, String displayString) {
        if (displayString == null && (displayString = value) == null) {
            displayString = "";
        }
        if (this.items == null) {
            this.items = new Vector();
        } else if (this.getItemIndexByValue(value) != -1) {
            return;
        }
        this.items.add(new ValueItem(displayString, value));
    }

    public AVValueItem getItem(int index) {
        if (this.items != null && 0 <= index && index < this.items.size()) {
            return (AVValueItem)this.items.get(index);
        }
        return null;
    }

    public AVValueItem getItemByDisplayString(String displayString) {
        return this.getItem(this.getItemIndexByDisplayString(displayString));
    }

    public AVValueItem getItemByValue(String value) {
        return this.getItem(this.getItemIndexByValue(value));
    }

    public int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    public int getItemIndexByDisplayString(String displayString) {
        if (this.items != null && displayString != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                AVValueItem item = (AVValueItem)this.items.get(i);
                if (!(this.ignoreCase ? StringUtil.compareIgnoreCase(item.getDisplayString(), displayString) : StringUtil.compare(item.getDisplayString(), displayString))) continue;
                return i;
            }
        }
        return -1;
    }

    public int getItemIndexByValue(String value) {
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                AVValueItem item = (AVValueItem)this.items.get(i);
                if (!(this.ignoreCase ? StringUtil.compareIgnoreCase(item.getValue(), value) : StringUtil.compare(item.getValue(), value))) continue;
                return i;
            }
        }
        return -1;
    }

    public String getDisplayString(int index) {
        AVValueItem item = this.getItem(index);
        if (item != null) {
            return item.getDisplayString();
        }
        return null;
    }

    public String getDisplayString(String value) {
        AVValueItem item = this.getItemByValue(value);
        if (item != null) {
            return item.getDisplayString();
        }
        return null;
    }

    public String[] getDisplayString() {
        int count = this.getItemCount();
        if (count > 0) {
            String[] displayStrings = new String[count];
            for (int i = 0; i < count; ++i) {
                displayStrings[i] = ((AVValueItem)this.items.get(i)).getDisplayString();
            }
            return displayStrings;
        }
        return null;
    }

    public String getValue(int index) {
        AVValueItem item = this.getItem(index);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public String getValue(String displayString) {
        AVValueItem item = this.getItemByDisplayString(displayString);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public String[] getValues() {
        int count = this.getItemCount();
        if (count > 0) {
            String[] values = new String[count];
            for (int i = 0; i < count; ++i) {
                values[i] = ((AVValueItem)this.items.get(i)).getValue();
            }
            return values;
        }
        return null;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void reset() {
        this.items = null;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setItems(String[] values) {
        this.setItems(values, values);
    }

    public void setItems(String[] values, String[] displayStrings) {
        this.reset();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.addItem(values[i], displayStrings != null && i < displayStrings.length ? displayStrings[i] : values[i]);
            }
        }
    }
}

