/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AVPart
implements FocusListener,
KeyListener,
ModifyListener,
MouseListener,
SelectionListener {
    static final int KC_ENTER = 13;
    private AVData data;
    private Composite parent;
    private Composite container;
    private boolean enabled = true;
    private boolean modified;
    private boolean hasFocus;
    private boolean ambiguous;
    private boolean valid;
    private Control[] controls;
    protected static final boolean AMBIGUOUS_CLEAR = true;
    protected static final boolean AMBIGUOUS_GRAY = false;
    private Label label;
    private String title;
    private boolean updating;
    private String updatedValue;
    private boolean forceUpdate = true;

    protected AVPart(AVData data, Composite parent) {
        this(data, parent, null);
    }

    protected AVPart(AVData data, Composite parent, String title) {
        this.data = data;
        this.parent = parent;
        this.title = title;
    }

    protected void addListeners() {
    }

    protected boolean compareValue(AVData data) {
        return this.compareValue(data, this.getValue());
    }

    protected boolean compareValue(AVData data, String value) {
        boolean specified;
        boolean bl = specified = data != null && data.isValueSpecified();
        if (value != null && specified) {
            return data.compareValue(value, data.getValue());
        }
        return value == null && !specified;
    }

    protected void createLabel() {
        if (this.title != null) {
            this.label = WidgetUtil.createLabel(this.getWidgetFactory(), this.getContainer(), this.title);
        }
    }

    public void dispose() {
        AVPart.dispose((Widget)this.container);
        this.container = null;
        this.data = null;
        this.parent = null;
        AVPart.dispose((Widget)this.label);
        this.label = null;
    }

    protected static void dispose(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    protected static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    protected final void fireValueChange() {
        if (this.modified) {
            this.removeListeners();
            this.updating = true;
            this.modified = false;
            this.updatedValue = this.getValue();
            final AVPart source = this;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    AVPart.this.data.fireValueChange(source);
                }
            });
            this.updating = false;
            this.addListeners();
        }
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.data.reportStatus(this);
        this.updateGlobalAction();
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.data.clearStatus();
        this.updateGlobalAction();
        this.fireValueChange();
    }

    public final Composite getContainer() {
        return this.container;
    }

    public Control getControl() {
        return this.label;
    }

    public final Label getAccLabel() {
        return this.label;
    }

    protected final AVData getDataComponent() {
        return this.data;
    }

    public Control getFocusControl() {
        Label label = this.getAccLabel();
        if (label != null && label.isFocusControl()) {
            return label;
        }
        return null;
    }

    public int getIndent() {
        return WidgetUtil.getTextExtent((Control)this.getContainer(), (String)"X").x;
    }

    public final Label getLabel() {
        return this.label;
    }

    public final Composite getParent() {
        return this.parent;
    }

    protected final AVPage getPage() {
        return this.data.getPage();
    }

    public final String getTitle() {
        return this.title;
    }

    public abstract String getValue();

    protected final AVWidgetFactory getWidgetFactory() {
        return this.getPage().getWidgetFactory();
    }

    private static void grayControl(Control control, boolean grey) {
        if (control != null) {
            Color color = control.getDisplay().getSystemColor(21);
            if (grey) {
                int r = (color.getRed() + 255) / 2;
                int g = (color.getGreen() + 255) / 2;
                int b = (color.getBlue() + 255) / 2;
                color = new Color((Device)control.getDisplay(), r, g, b);
            }
            control.setForeground(color);
        }
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initializeContainer(int numColumns) {
        this.initializeContainer(numColumns, false);
    }

    protected void initializeContainer(int numColumns, boolean fill) {
        if (this.container != null) {
            return;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        GridData gridData = null;
        gridData = fill ? new GridData(1808) : new GridData(772);
        this.container = WidgetUtil.createComposite(this.getWidgetFactory(), this.parent, 0, (Layout)gridLayout, gridData);
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isVisible() {
        return this.getContainer().isVisible();
    }

    public void keyPressed(KeyEvent e) {
        this.updateGlobalAction();
    }

    public void keyReleased(KeyEvent e) {
        this.updateGlobalAction();
        if (this.hasFocus) {
            this.data.reportStatus(this);
        }
        if (e.character == '\r') {
            this.fireValueChange();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.modified = true;
        this.updateGlobalAction();
        if (this.hasFocus) {
            this.data.reportStatus(this);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.updateGlobalAction();
    }

    public void mouseDown(MouseEvent e) {
        this.updateGlobalAction();
    }

    public void mouseUp(MouseEvent e) {
        this.updateGlobalAction();
    }

    protected void removeListeners() {
    }

    public void reset() {
        this.modified = false;
        this.setAmbiguous(false);
    }

    public void setAmbiguous(boolean ambiguous) {
        this.ambiguous = ambiguous;
        if (this.controls != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (!ambiguous) continue;
                Control c = this.controls[i];
                if (c instanceof Button) {
                    ((Button)c).setSelection(false);
                } else if (c instanceof Combo) {
                    ((Combo)c).deselectAll();
                } else if (c instanceof CCombo) {
                    ((CCombo)c).setText("");
                } else if (c instanceof List) {
                    ((List)c).deselectAll();
                } else if (c instanceof Text) {
                    ((Text)c).setText("");
                }
                this.ambiguous = ambiguous;
            }
        }
    }

    protected void setControls(Control[] controls) {
        this.controls = controls;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setVisible(boolean visible) {
        this.getContainer().setVisible(visible);
    }

    protected void setWidthHint(Control control, AVValueItem[] items) {
        this.setWidthHint(control, items, false);
    }

    protected void setWidthHint(Control control, AVValueItem[] items, boolean shorten) {
        if (control == null || items == null || items.length <= 0) {
            return;
        }
        String[] strings = AVValueItemUtil.getDisplayStrings(items);
        int maxWidth = WidgetUtil.getTextExtentMax((Control)control.getParent(), (String[])strings).x;
        if (control instanceof CCombo) {
            maxWidth += WidgetUtil.getDefaultTextExtent((Control)control.getParent(), (String)"....").x + 12;
        }
        if (shorten || WidgetUtil.getWidthHint(control) < maxWidth) {
            WidgetUtil.setWidthHint(control, maxWidth);
        }
    }

    protected abstract void update();

    public void updateContents() {
        int dataAvailablity;
        boolean availablity;
        boolean needUpdate;
        if (!this.updating) {
            this.removeListeners();
        }
        boolean bl = needUpdate = this.forceUpdate || this.getFocusControl() != this.getControl() || !this.compareValue(this.getDataComponent(), this.updatedValue);
        if (needUpdate) {
            this.update();
            this.updatedValue = this.getValue();
        }
        boolean bl2 = availablity = (dataAvailablity = this.data.getAvailability()) != 2 && dataAvailablity != 3;
        if (this.enabled != availablity) {
            this.setEnabled(availablity);
        }
        if (!this.updating) {
            this.addListeners();
        }
    }

    protected void updateGlobalAction() {
        this.getPage().getAttributesView().getGlobalActionProvider().updateGlobalAction();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateGlobalAction();
        if (this.hasFocus) {
            this.data.reportStatus(this);
        }
    }
}

