/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.sdk.AVContainer;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVFolder;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStatusReporter;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public abstract class AVPage {
    private AVFolder folder;
    private Composite root;
    private String name;
    private Image image;

    protected AVPage() {
        this(null, null, null);
    }

    protected AVPage(AVFolder folder) {
        this(folder, null, null);
    }

    protected AVPage(AVFolder folder, String name) {
        this(folder, name, null);
    }

    protected AVPage(AVFolder folder, String name, Image image) {
        this.folder = folder;
        this.name = name;
        this.image = image;
    }

    protected void alignWidth(Control[] controls) {
        if (controls != null) {
            WidgetUtil.alignWidth(controls);
        }
    }

    protected abstract void create();

    protected Composite createComposite(Composite parent, int numColumn) {
        return WidgetUtil.createAreaComposite(this.getWidgetFactory(), parent, numColumn);
    }

    protected Composite createComposite(Composite parent, int numColumn, boolean makeColumnsEqualWidth) {
        Composite composite = WidgetUtil.createAreaComposite(this.getWidgetFactory(), parent, numColumn);
        WidgetUtil.setMakeColumnsEqualWidth(composite, makeColumnsEqualWidth);
        composite.setLayoutData((Object)new GridData(770));
        return composite;
    }

    protected Composite createComposite(int numColumn) {
        return this.createComposite(this.getPageContainer(), numColumn);
    }

    protected Composite createComposite(int numColumn, boolean makeColumnsEqualWidth) {
        return this.createComposite(this.getPageContainer(), numColumn, makeColumnsEqualWidth);
    }

    public final void createContents(Composite parent) {
        this.preCreate(parent);
        this.create();
        this.postCreate();
    }

    public void dispose() {
        AVPart.dispose((Widget)this.root);
        this.root = null;
    }

    protected static void dispose(AVContainer container) {
        if (container != null) {
            container.dispose();
        }
    }

    protected static void dispose(AVData data) {
        if (data != null) {
            data.dispose();
        }
    }

    protected static void dispose(AVPart part) {
        if (part != null) {
            part.dispose();
        }
    }

    public abstract void fireValueChange(AVData var1);

    protected final AttributesView getAttributesView() {
        return this.folder != null ? this.folder.getAttributesView() : null;
    }

    public abstract AVEditorContextProvider getEditorContext();

    public abstract AVSelection getSelection();

    public final AVFolder getFolder() {
        return this.folder;
    }

    public String getHelpId() {
        return null;
    }

    public final Image getImage() {
        return this.image;
    }

    public Object getModel() {
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final Composite getPageContainer() {
        return this.root;
    }

    public final AVStatusReporter getStatusReporter() {
        return this.folder != null ? this.folder.getStatusReporter() : null;
    }

    public final Composite getRootContainer() {
        return this.root;
    }

    public AVWidgetFactory getWidgetFactory() {
        return this.folder != null ? this.folder.getWidgetFactory() : null;
    }

    public boolean isIndented() {
        return true;
    }

    protected void postCreate() {
        this.root.pack();
    }

    protected void preCreate(Composite parent) {
        if (parent == null) {
            return;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        gridLayout.verticalSpacing = 3;
        gridLayout.horizontalSpacing = 3;
        this.root = WidgetUtil.createComposite(this.getWidgetFactory(), parent, 0, (Layout)gridLayout, new GridData(1808));
    }

    public abstract void reset();

    public void setFolder(AVFolder folder) {
        this.folder = folder;
    }

    protected void setHorizontalIndent(Control[] controls, int horizontalIndent) {
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                WidgetUtil.setHorizontalIndent(controls[i], horizontalIndent);
            }
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void updateControl();

    public abstract void updateData(AVEditorContextProvider var1);
}

