/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.utils.ControlUtil;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVNumberPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class AVNumberSuffixesPart
extends AVNumberPart
implements AVSelectComponent {
    private String[] nowItems;
    protected CCombo suffix;

    public AVNumberSuffixesPart(AVData data, Composite parent, String title) {
        super(data, parent, title);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addKeyListener((KeyListener)this);
            this.text.addModifyListener((ModifyListener)this);
            this.text.addMouseListener((MouseListener)this);
        }
        if (this.suffix != null) {
            this.suffix.addFocusListener((FocusListener)this);
            this.suffix.addSelectionListener((SelectionListener)this);
        }
    }

    @Override
    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(3);
            this.createLabel();
        } else {
            this.initializeContainer(2);
        }
        this.text = WidgetUtil.createTextField(this.getWidgetFactory(), this.getContainer(), false, false);
        WidgetUtil.setWidthHint((Control)this.text, 5 * this.getIndent());
        this.suffix = WidgetUtil.createCombo(this.getWidgetFactory(), this.getContainer(), false, true);
        ControlUtil.setPreferredWidth((Control)this.suffix);
        this.setWidthHint((Control)this.suffix, this.getItems(), true);
        this.addListeners();
        this.setControls(new Control[]{this.text, this.suffix});
    }

    @Override
    public void dispose() {
        super.dispose();
        AVNumberSuffixesPart.dispose((Widget)this.suffix);
        this.suffix = null;
    }

    public CCombo getComboControl() {
        return this.suffix;
    }

    public String getComboString() {
        CCombo combo = this.getComboControl();
        if (combo != null) {
            int index = combo.getSelectionIndex();
            if (index < 0) {
                return null;
            }
            String item = combo.getItem(index);
            if (item == null || item.trim().length() < 1) {
                return null;
            }
            return AVValueItemUtil.getValue(this.getItems(), index);
        }
        return null;
    }

    @Override
    public Control getFocusControl() {
        if (this.suffix != null && this.suffix.isFocusControl()) {
            return this.suffix;
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItemCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItems();
        }
        return null;
    }

    @Override
    public int getSelectionIndex() {
        CCombo combo = this.getComboControl();
        if (combo != null) {
            return combo.getSelectionIndex();
        }
        return -1;
    }

    @Override
    public int getSuffixSelection() {
        return this.getSelectionIndex();
    }

    @Override
    public String getValue() {
        String value = this.getTextString();
        String suffix = this.getComboString();
        if (value != null) {
            if (suffix != null) {
                return value + suffix;
            }
            return value;
        }
        if (!this.erased) {
            return suffix;
        }
        return null;
    }

    protected void handleComboSelected() {
        if (this.isAmbiguous()) {
            this.setAmbiguous(false);
        }
        this.setModified(true);
        this.fireValueChange();
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeKeyListener((KeyListener)this);
            this.text.removeModifyListener((ModifyListener)this);
            this.text.removeMouseListener((MouseListener)this);
        }
        if (this.suffix != null) {
            this.suffix.removeFocusListener((FocusListener)this);
            this.suffix.removeSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.suffix.deselectAll();
        this.suffix.setText("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.suffix != null) {
            this.suffix.setEnabled(enabled);
        }
    }

    protected void setSuffixItems() {
        String[] newItems;
        CCombo combo = this.getComboControl();
        if (combo != null && !StringUtil.compare(newItems = AVValueItemUtil.getDisplayStrings(this.getItems()), this.nowItems)) {
            this.nowItems = newItems;
            combo.setItems(this.nowItems);
        }
    }

    @Override
    public void setValue(String value) {
        String integerString = value;
        CCombo combo = this.getComboControl();
        if (combo != null) {
            String suffixString = AVNumberSuffixesPart.parseSuffixString(value);
            AVValueItem[] items = this.getItems();
            int index = AVValueItemUtil.getItemIndexByValue(items, suffixString);
            if (index != -1) {
                integerString = AVNumberSuffixesPart.parseIntegerString(value);
            } else {
                suffixString = "";
                index = AVValueItemUtil.getItemIndexByValue(items, suffixString);
                if (index == -1) {
                    combo.add(suffixString);
                    if (this.nowItems != null) {
                        int itemCount = this.nowItems.length;
                        String[] newItems = new String[itemCount + 1];
                        for (int i = 0; i < itemCount; ++i) {
                            newItems[i] = this.nowItems[i];
                        }
                        newItems[itemCount] = suffixString;
                        this.nowItems = newItems;
                    }
                    index = combo.getItemCount() - 1;
                }
            }
            int comboIndex = combo.getSelectionIndex();
            if (index != comboIndex) {
                combo.select(index);
            }
        }
        this.text.setText(integerString != null ? integerString : "");
    }

    @Override
    protected void update() {
        this.setSuffixItems();
        super.update();
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.suffix) {
            this.handleComboSelected();
        }
        super.widgetSelected(e);
    }
}

