/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVNumberComponent;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AVNumberPart
extends AVPart
implements AVNumberComponent {
    protected static final int TEXT_WIDTH_HINT = 5;
    protected Text text;
    protected boolean erased;
    private String oldString;

    public AVNumberPart(AVData data, Composite parent, String title) {
        super(data, parent, title);
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addKeyListener((KeyListener)this);
            this.text.addModifyListener((ModifyListener)this);
            this.text.addMouseListener((MouseListener)this);
        }
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(2);
            this.createLabel();
        } else {
            this.initializeContainer(1);
        }
        this.text = WidgetUtil.createTextField(this.getWidgetFactory(), this.getContainer(), false, false);
        WidgetUtil.setWidthHint((Control)this.text, 5 * this.getIndent());
        this.addListeners();
    }

    @Override
    public void dispose() {
        super.dispose();
        AVNumberPart.dispose((Widget)this.text);
        this.text = null;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        return super.getFocusControl();
    }

    @Override
    public int getNumber() {
        return AVNumberPart.parseInteger(this.getNumberString(), 0);
    }

    @Override
    public String getNumberString() {
        return AVNumberPart.parseIntegerString(this.getValue());
    }

    @Override
    public int getSuffixSelection() {
        return -1;
    }

    @Override
    public String getSuffixString() {
        return AVNumberPart.parseSuffixString(this.getValue());
    }

    public Text getTextControl() {
        return this.text;
    }

    protected String getTextString() {
        String value = this.text.getText();
        if (value != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    @Override
    public String getValue() {
        String value = this.getTextString();
        if (value != null) {
            return value;
        }
        return null;
    }

    public boolean isSpecified() {
        return this.getValue() != null;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        String curString = this.getTextString();
        this.erased = curString == null && this.oldString != null;
        this.oldString = curString;
        super.modifyText(e);
    }

    public static int parseInteger(String value, int fallback) {
        if (value != null) {
            try {
                return Integer.parseInt(AVNumberPart.parseIntegerString(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fallback;
    }

    public static String parseIntegerString(String value) {
        int index;
        if (value == null) {
            return null;
        }
        value = value.trim();
        char[] p = value.toCharArray();
        for (index = 0; index < p.length && Character.isDigit(p[index]); ++index) {
        }
        if (index == 0) {
            return null;
        }
        if (index < p.length) {
            return value.substring(0, index);
        }
        return value;
    }

    public static String parseSuffixString(String value) {
        int index;
        if (value == null) {
            return null;
        }
        value = value.trim();
        char[] p = value.toCharArray();
        for (index = 0; index < p.length && Character.isDigit(p[index]); ++index) {
        }
        if (index == 0) {
            return value;
        }
        if (index < p.length) {
            return value.substring(index);
        }
        return null;
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeKeyListener((KeyListener)this);
            this.text.removeModifyListener((ModifyListener)this);
            this.text.removeMouseListener((MouseListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.text.setText("");
        this.erased = false;
        this.oldString = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public void setValue(String value) {
        String integerString = value;
        this.text.setText(integerString != null ? integerString : "");
    }

    @Override
    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            String value = data.getValue();
            this.setValue(value);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }
}

