/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVMenuProvider;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AVMultiBrowseStringPart
extends AVPart
implements AVStringComponent {
    private Text text;
    private Button button;
    private Menu[] menus;
    private Object[] menuItemsList;
    int selectionIndex = 0;
    private AVMenuProvider menuProvider;

    public AVMultiBrowseStringPart(AVData data, Composite parent, String title, AVMenuProvider menuProvider) {
        super(data, parent, title);
        this.menuProvider = menuProvider;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addKeyListener((KeyListener)this);
            this.text.addModifyListener((ModifyListener)this);
            this.text.addMouseListener((MouseListener)this);
        }
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    protected void createContents() {
        String[] titles;
        if (this.getTitle() != null) {
            this.initializeContainer(3);
            this.createLabel();
        } else {
            this.initializeContainer(2);
        }
        this.text = WidgetUtil.createTextField(this.getWidgetFactory(), this.getContainer(), true, false);
        this.button = WidgetUtil.createMultiBrowseButton(this.getWidgetFactory(), WidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), 1));
        if (this.menuProvider != null && (titles = this.menuProvider.getMenuItems()) != null) {
            this.menus = new Menu[titles.length];
            this.menuItemsList = new Object[titles.length];
            for (int i = 0; i < titles.length; ++i) {
                this.menus[i] = new Menu((Control)this.button);
                MenuItem[] menuItems = new MenuItem[titles.length];
                for (int j = 0; j < titles.length; ++j) {
                    menuItems[j] = new MenuItem(this.menus[i], 8);
                    menuItems[j].setText(titles[j]);
                    menuItems[j].addSelectionListener((SelectionListener)this);
                }
                this.menuItemsList[i] = menuItems;
            }
        }
        this.selectionIndex = 0;
        this.addListeners();
        this.setControls(new Control[]{this.text});
    }

    @Override
    public void dispose() {
        super.dispose();
        AVMultiBrowseStringPart.dispose((Widget)this.text);
        this.text = null;
        AVMultiBrowseStringPart.dispose((Widget)this.button);
        this.button = null;
    }

    public Button getBrowseButton() {
        return this.button;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        if (this.button.isFocusControl()) {
            return this.button;
        }
        return super.getFocusControl();
    }

    public String getString() {
        String string = this.text.getText();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public Text getText() {
        return this.text;
    }

    @Override
    public String getValue() {
        return this.getString();
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeKeyListener((KeyListener)this);
            this.text.removeModifyListener((ModifyListener)this);
            this.text.removeMouseListener((MouseListener)this);
        }
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setString("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setMenuProvider(AVMenuProvider menuProvider) {
        this.menuProvider = menuProvider;
    }

    public void setString(String string) {
        this.text.setText(string != null ? string : "");
    }

    @Override
    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            this.setString(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            if (this.selectionIndex >= 0 && this.selectionIndex < this.menus.length) {
                Point p = this.button.getLocation();
                Rectangle r = this.button.getBounds();
                p.y += r.height;
                p = this.button.getParent().toDisplay(p);
                this.menus[this.selectionIndex].setLocation(p.x, p.y);
                if (this.menuProvider != null) {
                    this.menuProvider.enable(this.menus[this.selectionIndex], this.selectionIndex);
                }
                this.menus[this.selectionIndex].setVisible(true);
            }
        } else if (this.selectionIndex >= 0 && this.selectionIndex < this.menus.length) {
            MenuItem[] menuItems = (MenuItem[])this.menuItemsList[this.selectionIndex];
            for (int i = 0; i < menuItems.length; ++i) {
                String string;
                if (e.widget != menuItems[i] || this.menuProvider == null || (string = this.menuProvider.select(this.menus[i], i)) == null) continue;
                if (this.isAmbiguous()) {
                    this.setAmbiguous(false);
                }
                this.setModified(true);
                this.setString(string);
            }
        }
        this.fireValueChange();
        super.widgetSelected(e);
    }
}

