/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.utils.ControlUtil;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

public class AVListPart
extends AVPart
implements AVSelectComponent {
    protected List list;
    private boolean scrollable;

    public AVListPart(AVData data, Composite parent, String title) {
        this(data, parent, title, false);
    }

    public AVListPart(AVData data, Composite parent, String title, boolean scrollable) {
        super(data, parent, title);
        this.scrollable = scrollable;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.list != null) {
            this.list.addFocusListener((FocusListener)this);
            this.list.addSelectionListener((SelectionListener)this);
        }
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(2);
            this.createLabel();
            WidgetUtil.setVerticalAlignment((Control)this.getAccLabel(), 1);
        } else {
            this.initializeContainer(1);
        }
        GridData gridData = null;
        int style = 2052;
        if (this.scrollable) {
            style |= 0x300;
            gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
        }
        this.list = WidgetUtil.createList(this.getWidgetFactory(), this.getContainer(), AVValueItemUtil.getDisplayStrings(this.getItems()), style, gridData);
        ControlUtil.setPreferredHeight((Control)this.list);
        ControlUtil.setPreferredWidth((Control)this.list);
        this.addListeners();
        this.setControls(new Control[]{this.list});
    }

    @Override
    public void dispose() {
        super.dispose();
        AVListPart.dispose((Widget)this.list);
        this.list = null;
    }

    @Override
    public Control getControl() {
        return this.list;
    }

    @Override
    public Control getFocusControl() {
        if (this.list.isFocusControl()) {
            return this.list;
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItemCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItems();
        }
        return null;
    }

    public List getListControl() {
        return this.list;
    }

    @Override
    public int getSelectionIndex() {
        return this.list.getSelectionIndex();
    }

    @Override
    public String getValue() {
        int index = this.getSelectionIndex();
        return AVValueItemUtil.getValue(this.getItems(), index);
    }

    public boolean isSpecified() {
        int selection = this.getSelectionIndex();
        return 0 <= selection && selection < this.list.getItemCount();
    }

    protected void handleListSelected() {
        this.setModified(true);
        this.fireValueChange();
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.list != null) {
            this.list.removeFocusListener((FocusListener)this);
            this.list.removeSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.list.select(-1);
    }

    protected void select(int index) {
        this.list.select(index);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(this.isEnabled());
    }

    @Override
    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            if (data instanceof AVSelectComponent) {
                this.select(((AVSelectComponent)((Object)data)).getSelectionIndex());
            }
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.list) {
            this.handleListSelected();
        }
        super.widgetSelected(e);
    }
}

