/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.AVContents;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVHelpProvider;
import com.ibm.etools.attrview.AVTabItem;
import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.AbstractTabItem;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVStatusReporter;
import com.ibm.etools.attrview.sdk.AVStatusReporterImpl;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;

public abstract class AVFolder
implements AVContents,
AVHelpProvider {
    private AttributesView view;
    private PageBook pageBook;
    private AVStatusReporter statusReporter;
    private TabItem[] tabItems;
    private int tabIndex;
    private int initialIndex;

    protected AVFolder() {
        this(null);
    }

    protected AVFolder(AttributesView view) {
        this.view = view;
    }

    protected void createContents() {
        if (this.view == null) {
            return;
        }
        Assert.isTrue((this.pageBook == null ? 1 : 0) != 0, (String)"createContents() can be called only once.");
        this.pageBook = new PageBook(this.view.getPageContainer(), 0);
        AVPage[] pages = this.getPages();
        if (pages != null && 0 < pages.length) {
            this.tabItems = new TabItem[pages.length];
            this.tabIndex = this.initialIndex;
            for (int i = 0; i < pages.length; ++i) {
                if (pages[i] == null) continue;
                this.tabItems[i] = new TabItem(pages[i], i == this.tabIndex);
                this.showPage(pages[i]);
            }
            if (this.tabIndex != pages.length - 1) {
                this.showPage(pages[this.tabIndex]);
            }
        }
        Rectangle r = this.view.getPageContainer().getBounds();
        this.pageBook.setBounds(new Rectangle(0, 0, r.width, r.height));
    }

    public void dispose() {
        if (this.pageBook != null) {
            this.pageBook.dispose();
            this.pageBook = null;
        }
        if (this.statusReporter != null && this.statusReporter instanceof AVStatusReporterImpl) {
            ((AVStatusReporterImpl)this.statusReporter).dispose();
            this.statusReporter = null;
        }
    }

    protected final AVPage getActivePage() {
        AVPage[] pages;
        if (this.pageBook != null && (pages = this.getPages()) != null) {
            for (int i = 0; i < pages.length; ++i) {
                if (i != this.tabIndex) continue;
                return pages[i];
            }
        }
        return null;
    }

    public final AttributesView getAttributesView() {
        return this.view;
    }

    @Override
    public Control getControl() {
        return this.getContainer();
    }

    protected abstract AVPage[] getPages();

    public final Composite getContainer() {
        return this.pageBook;
    }

    public final AVStatusReporter getStatusReporter() {
        if (this.statusReporter == null && this.view != null) {
            this.statusReporter = new AVStatusReporterImpl(this.view);
        }
        return this.statusReporter;
    }

    @Override
    public Widget getFocusControl() {
        return WidgetUtil.getFocusControl((Control)this.pageBook);
    }

    @Override
    public AVTabItem[] getTabs() {
        return this.tabItems;
    }

    public final AVWidgetFactory getWidgetFactory() {
        return this.view != null ? this.view.getWidgetFactory() : null;
    }

    @Override
    public boolean isVisible() {
        return this.pageBook != null ? this.pageBook.isVisible() : false;
    }

    @Override
    public void setFocus() {
        if (this.pageBook != null) {
            this.pageBook.setFocus();
        }
    }

    protected final void selectPage(AVPage page) {
        AVPage[] pages;
        if (this.pageBook != null && (pages = this.getPages()) != null) {
            for (int i = 0; i < pages.length; ++i) {
                if (page != pages[i] || this.tabIndex == i) continue;
                this.selectTab(i);
            }
        }
    }

    @Override
    public void selectTab(int tab) {
        AVPage[] pages = this.getPages();
        if (pages != null && this.pageBook != null) {
            if (0 <= tab && tab < pages.length && pages[tab] != null) {
                this.showPage(pages[tab]);
                this.tabIndex = tab;
            }
            for (int i = 0; i < this.tabItems.length; ++i) {
                this.tabItems[i].setSelected(i == tab);
            }
        }
    }

    public void setInitialIndex(int initialIndex) {
        this.initialIndex = initialIndex;
    }

    public final void setView(AttributesView view) {
        this.view = view;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.pageBook != null) {
            Composite parent = this.pageBook.getParent();
            if (parent instanceof PageBook) {
                ((PageBook)parent).showPage((Control)this.pageBook);
            } else {
                this.pageBook.setVisible(visible);
            }
        }
    }

    protected void showPage(AVPage page) {
        if (page == null || this.pageBook == null) {
            return;
        }
        Composite pageComposite = page.getRootContainer();
        if (pageComposite == null) {
            page.createContents((Composite)this.pageBook);
            pageComposite = page.getRootContainer();
        }
        this.pageBook.showPage((Control)pageComposite);
    }

    @Override
    public void updateControl() {
        AVPage[] pages = this.getPages();
        if (pages != null) {
            for (int i = 0; i < pages.length; ++i) {
                pages[i].updateControl();
            }
        }
    }

    @Override
    public void updateData(AVEditorContextProvider provider) {
        AVPage[] pages = this.getPages();
        if (pages != null) {
            for (int i = 0; i < pages.length; ++i) {
                pages[i].updateData(provider);
            }
        }
    }

    @Override
    public String getHelpId() {
        return null;
    }

    public class TabItem
    extends AbstractTabItem {
        private AVPage page;
        private boolean selected;

        public TabItem(AVPage page, boolean selected) {
            this.page = page;
            this.selected = selected;
        }

        @Override
        public Image getImage() {
            return this.page.getImage();
        }

        @Override
        public String getText() {
            return this.page.getName();
        }

        @Override
        public boolean isIndented() {
            return this.page.isIndented();
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public Object getModel() {
            return this.page.getModel();
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

