/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.utils.ControlUtil;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AVFileBrowsePart
extends AVPart
implements AVStringComponent {
    protected Text text;
    protected Button button;

    public AVFileBrowsePart(AVData data, Composite parent, String title) {
        super(data, parent, title);
        this.createContents();
    }

    protected abstract void browse(TypedEvent var1);

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(3);
            this.createLabel();
        } else {
            this.initializeContainer(2);
        }
        this.text = WidgetUtil.createTextField(this.getWidgetFactory(), this.getContainer(), true, false);
        ControlUtil.setPreferredWidth((Control)this.text);
        this.button = this.createBrowseButton();
        this.addListeners();
        this.setControls(new Control[]{this.text});
    }

    protected abstract Button createBrowseButton();

    @Override
    public void dispose() {
        super.dispose();
        AVFileBrowsePart.dispose((Widget)this.text);
        this.text = null;
        AVFileBrowsePart.dispose((Widget)this.button);
        this.button = null;
    }

    public Button getBrowseButton() {
        return this.button;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        if (this.button.isFocusControl()) {
            return this.button;
        }
        return super.getFocusControl();
    }

    public String getString() {
        String string = this.text.getText();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public Text getText() {
        return this.text;
    }

    @Override
    public String getValue() {
        return this.getString();
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    @Override
    public void reset() {
        super.reset();
        this.setString("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setString(String string) {
        this.text.setText(string != null ? string : "");
    }

    @Override
    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            this.setString(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        this.browse((TypedEvent)e);
        super.widgetSelected(e);
    }

    @Override
    protected void addListeners() {
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addKeyListener((KeyListener)this);
            this.text.addModifyListener((ModifyListener)this);
            this.text.addMouseListener((MouseListener)this);
        }
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    @Override
    protected void removeListeners() {
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeKeyListener((KeyListener)this);
            this.text.removeModifyListener((ModifyListener)this);
            this.text.removeMouseListener((MouseListener)this);
        }
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
    }
}

