/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.sdk.DisplayString;
import com.ibm.etools.attrview.sdk.AVComboPart;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import org.eclipse.swt.widgets.Composite;

public class AVEditableComboPart
extends AVComboPart
implements AVStringComponent {
    private DisplayString displayString;

    protected AVEditableComboPart(AVData data, Composite parent) {
        super(data, parent);
    }

    public AVEditableComboPart(AVData data, Composite parent, String title) {
        super(data, parent, title, false, false);
    }

    public AVEditableComboPart(AVData data, Composite parent, String title, boolean fill) {
        super(data, parent, title, false, fill);
    }

    public String getString() {
        String string = this.combo.getText();
        if (this.displayString != null) {
            string = this.displayString.getValue(string);
        }
        String value = string;
        AVValueItem[] items = this.getItems();
        int index = AVValueItemUtil.getItemIndexByDisplayString(items, string);
        if (index != -1) {
            value = items[index].getValue();
        }
        if (value != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    @Override
    public String getValue() {
        return this.getString();
    }

    @Override
    protected void handleComboSelected() {
        super.handleComboSelected();
        this.setModified(true);
        this.fireValueChange();
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    @Override
    public void reset() {
        super.reset();
        this.combo.setText("");
        this.displayString = null;
    }

    public void setString(String string) {
        AVValueItem[] items = this.getItems();
        int index = AVValueItemUtil.getItemIndexByValue(items, string);
        if (index != -1) {
            int comboIndex = this.combo.getSelectionIndex();
            if (index != comboIndex) {
                String title = items[index].getDisplayString();
                this.displayString = new DisplayString(title);
                this.combo.setText(this.displayString.getDisplayString());
                this.combo.select(index);
            }
        } else {
            this.displayString = new DisplayString(string);
            this.combo.setText(this.displayString.getDisplayString());
        }
    }

    @Override
    protected void setValue(String value) {
        this.setString(value);
    }
}

