/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVComboPart;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import org.eclipse.swt.widgets.Composite;

public class AVDropdownListPart
extends AVComboPart {
    private final int defaultIndex = 0;

    public AVDropdownListPart(AVData data, Composite parent, String title) {
        super(data, parent, title, true, false);
    }

    public AVDropdownListPart(AVData data, Composite parent, String title, boolean fill) {
        super(data, parent, title, true, fill);
    }

    @Override
    public String getValue() {
        int index = this.getSelectionIndex();
        return AVValueItemUtil.getValue(this.getItems(), index);
    }

    @Override
    protected void handleComboSelected() {
        super.handleComboSelected();
        this.setModified(true);
        this.fireValueChange();
    }

    public boolean isSpecified() {
        int selection = this.getSelectionIndex();
        return 0 <= selection && selection < this.combo.getItemCount() && selection != 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.combo.select(0);
    }

    protected void select(int index) {
        this.combo.select(index);
    }

    public void setSelectionIndex(int index) {
        this.select(index);
    }

    @Override
    protected void setValue(String value) {
        int index = AVValueItemUtil.getItemIndexByValue(this.getItems(), value);
        int comboIndex = this.combo.getSelectionIndex();
        if (index != -1 && index != comboIndex) {
            this.select(index);
        }
    }
}

