/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.ResourceHandler;
import com.ibm.etools.attrview.internal.sdk.DirectTableEditorAction;
import com.ibm.etools.attrview.internal.sdk.DirectTableEditorAddAction;
import com.ibm.etools.attrview.internal.sdk.DirectTableEditorDeleteAction;
import com.ibm.etools.attrview.internal.sdk.DirectTableEditorDownAction;
import com.ibm.etools.attrview.internal.sdk.DirectTableEditorEditAction;
import com.ibm.etools.attrview.internal.sdk.DirectTableEditorUpAction;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVDirectTableEditor;
import com.ibm.etools.attrview.sdk.AVTableEditorPart;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AVDirectTableEditorPart
extends AVTableEditorPart
implements ICellEditorListener,
AVDirectTableEditor {
    private static final String ADD = ResourceHandler._UI_AP_0;
    private static final String DELETE = ResourceHandler._UI_AP_1;
    private static final String UP = ResourceHandler._UI_AP_2;
    private static final String DOWN = ResourceHandler._UI_AP_3;
    private static final String MENU_ADD = ResourceHandler._UI_AP_4;
    private static final String MENU_DELETE = ResourceHandler._UI_AP_5;
    private static final String MENU_DOWN = ResourceHandler._UI_AP_6;
    private static final String MENU_UP = ResourceHandler._UI_AP_7;
    protected static final int ENTERY_KEY = 13;
    protected static final String ID_MM_TABLE = "DirectTableEditorPage MM_TABLE";
    protected Button addButton;
    protected Button deleteButton;
    protected Button upButton;
    protected Button downButton;
    protected TableEditor tableEditor;
    protected CellEditor currentCellEditor;
    protected int currentSelection;
    protected boolean add;
    private FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            AVDirectTableEditorPart.this.disableCellEditor();
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            AVDirectTableEditorPart.this.handleKeyTraversed(e);
        }
    };

    public AVDirectTableEditorPart(AVData data, Composite parent, String title, boolean check, boolean multiple, boolean updown) {
        super(data, parent, title, check, multiple, updown);
    }

    protected void activateCellEditor(TableItem item, int row, int column) {
        if (this.currentCellEditor != null) {
            return;
        }
        CellEditor[] cellEditors = this.getCellEditors();
        if (column < 0 || cellEditors != null && cellEditors.length <= column) {
            return;
        }
        this.currentCellEditor = cellEditors[column];
        if (this.currentCellEditor == null) {
            return;
        }
        this.currentCellEditor.setValue((Object)item.getText(column));
        this.initCellEditor();
        this.currentCellEditor.activate();
        if (this.currentCellEditor.getControl() == null) {
            this.currentCellEditor.deactivate();
            this.currentCellEditor = null;
            return;
        }
        this.currentSelection = row;
        this.table.showSelection();
        CellEditor.LayoutData layout = this.currentCellEditor.getLayoutData();
        this.tableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableEditor.grabHorizontal = layout.grabHorizontal;
        this.tableEditor.minimumWidth = item.getBounds((int)column).width;
        this.tableEditor.setEditor(this.currentCellEditor.getControl(), item, column);
        this.currentCellEditor.getControl().addFocusListener(this.focusListener);
        this.currentCellEditor.getControl().addTraverseListener(this.traverseListener);
        this.currentCellEditor.addListener((ICellEditorListener)this);
        this.currentCellEditor.setFocus();
    }

    protected abstract void addEntry(String[] var1);

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.table != null) {
            this.table.addMouseListener((MouseListener)this);
        }
    }

    public void applyEditorValue() {
        if (this.currentCellEditor != null) {
            String newValue;
            int column = this.tableEditor.getColumn();
            if (column < 0) {
                return;
            }
            if (this.currentCellEditor.isValueValid() && this.checkCellValue(newValue = (String)this.currentCellEditor.getValue(), column)) {
                if (this.add) {
                    String[] values = this.createInitialValues();
                    values[column] = newValue;
                    this.addEntry(values);
                } else {
                    this.editEntry(this.currentSelection, column, newValue);
                }
            }
        }
        this.deactivateCellEditor();
    }

    public void cancelEditor() {
        this.deactivateCellEditor();
    }

    protected boolean checkCellValue(String value, int column) {
        return true;
    }

    @Override
    protected void createButtons() {
        Composite buttonArea = WidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), 1);
        buttonArea.setLayoutData((Object)new GridData(2));
        this.addButton = WidgetUtil.createButton(this.getWidgetFactory(), buttonArea, ADD, 8, null);
        this.deleteButton = WidgetUtil.createButton(this.getWidgetFactory(), buttonArea, DELETE, 8, null);
        WidgetUtil.alignWidth(new Control[]{this.addButton, this.deleteButton});
        this.addButton.addSelectionListener((SelectionListener)this);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        if (this.updown) {
            this.upButton = WidgetUtil.createButton(this.getWidgetFactory(), buttonArea, UP, 8, null);
            this.downButton = WidgetUtil.createButton(this.getWidgetFactory(), buttonArea, DOWN, 8, null);
            WidgetUtil.alignWidth(new Control[]{this.addButton, this.deleteButton, this.upButton, this.downButton});
            this.upButton.addSelectionListener((SelectionListener)this);
            this.downButton.addSelectionListener((SelectionListener)this);
        }
    }

    @Override
    protected void createContents() {
        super.createContents();
        this.prepareDirectEditing();
    }

    protected String[] createInitialValues() {
        String[] values = new String[this.getColumnCountDef()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = "";
        }
        return values;
    }

    protected void deactivateCellEditor() {
        this.tableEditor.setEditor(null, null, this.tableEditor.getColumn());
        if (this.currentCellEditor != null) {
            this.currentCellEditor.getControl().removeFocusListener(this.focusListener);
            this.currentCellEditor.getControl().removeTraverseListener(this.traverseListener);
            this.currentCellEditor.removeListener((ICellEditorListener)this);
            this.currentCellEditor.deactivate();
            this.currentCellEditor = null;
        }
    }

    protected void disableCellEditor() {
        this.applyEditorValue();
    }

    @Override
    public void dispose() {
        super.dispose();
        AVDirectTableEditorPart.dispose((Widget)this.addButton);
        this.addButton = null;
        AVDirectTableEditorPart.dispose((Widget)this.deleteButton);
        this.deleteButton = null;
        AVDirectTableEditorPart.dispose((Widget)this.upButton);
        this.upButton = null;
        AVDirectTableEditorPart.dispose((Widget)this.downButton);
        this.downButton = null;
        if (this.tableEditor != null) {
            this.tableEditor = null;
        }
    }

    @Override
    public void doAdd() {
        this.add = true;
        int newIndex = this.table.getItemCount();
        TableItem item = new TableItem(this.table, 0);
        item.setText(this.createInitialValues());
        if (this.table.getSelectionCount() > 0) {
            this.table.deselectAll();
        }
        this.table.select(newIndex);
        int newColumnIndex = this.getColumnAddIndex();
        this.activateCellEditor(item, newIndex, newColumnIndex);
        this.setRowSelectionIndex(new int[]{newIndex});
        this.setColumnSelectionIndex(new int[]{newColumnIndex});
        if (this.check) {
            item.setChecked(false);
        }
    }

    @Override
    public abstract void doDelete();

    @Override
    public abstract void doDown();

    @Override
    public void doEdit(int index) {
        TableItem[] items = this.table.getSelection();
        if (items.length == 1) {
            this.add = false;
            this.activateCellEditor(items[0], this.table.getSelectionIndex(), index);
            this.setColumnSelectionIndex(new int[]{index});
        }
    }

    @Override
    public abstract void doUp();

    protected abstract void editEntry(int var1, int var2, String var3);

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    private void fillContextMenu(IMenuManager menu) {
        DirectTableEditorAction action = null;
        int count = this.table.getSelectionCount();
        String[] items = this.getMenuColumnNames();
        if (items != null && items.length > 0) {
            menu.add((IContributionItem)new Separator());
            for (int i = 0; i < items.length; ++i) {
                action = new DirectTableEditorEditAction(items[i], i, (AVDirectTableEditor)this);
                action.setEnabled(count == 1);
                menu.add((IAction)action);
            }
        }
        if (this.needUpDownContextMenu()) {
            action = new DirectTableEditorUpAction(MENU_UP, this);
            action.setEnabled(this.isUpAvailable());
            menu.add((IAction)action);
            action = new DirectTableEditorDownAction(MENU_DOWN, this);
            action.setEnabled(this.isDownAvailable());
            menu.add((IAction)action);
        }
        if (this.needDeleteContextMenu()) {
            action = new DirectTableEditorDeleteAction(MENU_DELETE, this);
            action.setEnabled(count > 0);
            menu.add((IAction)action);
        }
        if (this.needAddContextMenu()) {
            menu.add((IAction)new DirectTableEditorAddAction(MENU_ADD, this));
        }
    }

    protected boolean needUpDownContextMenu() {
        return this.updown;
    }

    protected boolean needDeleteContextMenu() {
        return true;
    }

    protected boolean needAddContextMenu() {
        return true;
    }

    protected abstract CellEditor[] getCellEditors();

    protected int getColumnAddIndex() {
        return 0;
    }

    @Override
    public Control getFocusControl() {
        if (this.addButton != null && this.addButton.isFocusControl()) {
            return this.addButton;
        }
        if (this.deleteButton != null && this.deleteButton.isFocusControl()) {
            return this.deleteButton;
        }
        if (this.upButton != null && this.upButton.isFocusControl()) {
            return this.upButton;
        }
        if (this.downButton != null && this.downButton.isFocusControl()) {
            return this.downButton;
        }
        return super.getFocusControl();
    }

    protected abstract String[] getMenuColumnNames();

    protected void handleAddButton(SelectionEvent e) {
        this.doAdd();
    }

    protected abstract void handleDeleteButton(SelectionEvent var1);

    protected abstract void handleDownButton(SelectionEvent var1);

    private void handleKeyTraversed(TraverseEvent e) {
        if (this.currentCellEditor != null && (e.detail == 16 || e.detail == 8)) {
            int column = this.tableEditor.getColumn();
            this.disableCellEditor();
            int row = this.currentSelection;
            if (row < 0 || this.table.getItemCount() <= row) {
                return;
            }
            int len = this.getColumnCountDef();
            if (e.detail == 16) {
                if (++column >= len) {
                    column = 0;
                }
            } else if (--column < 0) {
                column = len - 1;
            }
            e.doit = false;
            this.add = false;
            this.startActivationThread(this.table.getItem(row), row, column);
            this.setColumnSelectionIndex(new int[]{column});
        }
    }

    @Override
    protected void handleMouseDown(MouseEvent event) {
        super.handleMouseDown(event);
        this.disableCellEditor();
        TableItem[] items = this.table.getSelection();
        if (event.button == 1 && items.length == 1) {
            TableItem tableItem = items[0];
            int[] indices = this.getColumnSelectionIndex();
            if (indices != null && indices.length == 1) {
                this.add = false;
                this.activateCellEditor(tableItem, this.table.getSelectionIndex(), indices[0]);
                return;
            }
        }
        this.applyEditorValue();
    }

    protected abstract void handleUpButton(SelectionEvent var1);

    protected void initCellEditor() {
    }

    protected abstract boolean isDownAvailable();

    protected abstract boolean isUpAvailable();

    protected void prepareDirectEditing() {
        this.tableEditor = new TableEditor(this.table);
        MenuManager mm = new MenuManager(ID_MM_TABLE, ID_MM_TABLE);
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                AVDirectTableEditorPart.this.fillContextMenu(menu);
            }
        });
        Menu menu = mm.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.table != null) {
            this.table.removeMouseListener((MouseListener)this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(enabled);
        }
        if (this.updown) {
            if (this.upButton != null) {
                this.upButton.setEnabled(enabled);
            }
            if (this.downButton != null) {
                this.downButton.setEnabled(enabled);
            }
        }
    }

    private void startActivationThread(final TableItem tableItem, final int row, final int column) {
        new Thread(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AVDirectTableEditorPart.this.activateCellEditor(tableItem, row, column);
                    }
                });
            }
        }.start();
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.handleAddButton(e);
        } else if (e.widget == this.deleteButton) {
            this.handleDeleteButton(e);
        } else if (e.widget == this.upButton) {
            this.handleUpButton(e);
        } else if (e.widget == this.downButton) {
            this.handleDownButton(e);
        }
        super.widgetSelected(e);
    }
}

