/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStatusReporter;
import com.ibm.etools.attrview.sdk.AVValidator;
import com.ibm.etools.attrview.utils.StringUtil;

public abstract class AVData {
    protected AVValidator validator;
    private boolean ambiguous;
    private boolean editable;
    private boolean ignoreCase;
    protected String value;
    private boolean valueSpecified;
    private boolean valueUnique;
    protected AVPage page;

    public AVData(AVPage page) {
        this.page = page;
        this.ignoreCase = true;
    }

    public void clearStatus() {
        AVStatusReporter reporter = this.page.getStatusReporter();
        if (reporter != null) {
            reporter.clear();
        }
    }

    protected boolean compareValue(AVPart part) {
        String value = part.getValue();
        if (this.isValueSpecified() && value != null) {
            return this.compareValue(this.getValue(), value);
        }
        return !this.isValueSpecified() && value == null;
    }

    public boolean compareValue(String value, String value2) {
        if (this.ignoreCase) {
            return StringUtil.compareIgnoreCase(value, value2);
        }
        return StringUtil.compare(value, value2);
    }

    public void dispose() {
    }

    public void fireValueChange(AVPart part) {
        if (this.getSelection() != null && !this.compareValue(part)) {
            this.setValue(part);
            this.page.fireValueChange(this);
        }
    }

    public int getAvailability() {
        return 0;
    }

    public AVPage getPage() {
        return this.page;
    }

    public AVSelection getSelection() {
        return this.page.getSelection();
    }

    public AVValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isValueSpecified() {
        return this.valueSpecified;
    }

    public boolean isValueUnique() {
        return this.valueUnique;
    }

    public boolean isValueValid() {
        return false;
    }

    public void reportStatus(AVPart part) {
        if (part != null) {
            this.reportStatus(part.getValue());
        }
    }

    public void reportStatus(String value) {
        AVStatusReporter reporter = this.page.getStatusReporter();
        if (reporter != null) {
            reporter.report(null);
        }
    }

    public void reset() {
        this.ambiguous = false;
        this.editable = true;
        this.value = null;
        this.valueSpecified = false;
        this.valueUnique = true;
    }

    public void setAmbiguous(boolean ambiguous) {
        this.ambiguous = ambiguous;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setValidator(AVValidator validator) {
        this.validator = validator;
    }

    protected void setValue(AVPart part) {
        String value = part.getValue();
        this.setValue(value);
        this.setValueSpecified(value != null);
        this.setValueUnique(true);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValueSpecified(boolean specified) {
        this.valueSpecified = specified;
    }

    public void setValueUnique(boolean unique) {
        this.valueUnique = unique;
    }

    protected abstract void update(AVSelection var1);

    public void updateContents() {
        this.updateContents(this.getSelection());
    }

    public void updateContents(AVSelection selection) {
        this.reset();
        this.update(selection);
    }
}

