/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AVComboPart
extends AVPart
implements AVSelectComponent {
    private static final int preferredCComboWidth = 100;
    protected CCombo combo;
    protected Color color;
    protected boolean readonly;
    protected boolean fill;
    private String[] nowItems;

    protected AVComboPart(AVData data, Composite parent) {
        super(data, parent);
    }

    public AVComboPart(AVData data, Composite parent, String title, boolean readonly, boolean fill) {
        super(data, parent, title);
        this.readonly = readonly;
        this.fill = fill;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.combo != null) {
            this.combo.addFocusListener((FocusListener)this);
            this.combo.addSelectionListener((SelectionListener)this);
            if (!this.readonly) {
                this.combo.addModifyListener((ModifyListener)this);
            }
        }
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(2);
            this.createLabel();
        } else {
            this.initializeContainer(1);
        }
        this.combo = WidgetUtil.createCombo(this.getWidgetFactory(), this.getContainer(), this.fill, this.readonly);
        if (!this.fill) {
            this.setWidthHint((Control)this.combo, this.getItems());
        }
        this.addListeners();
        this.setControls(new Control[]{this.combo});
    }

    @Override
    public void dispose() {
        super.dispose();
        AVComboPart.dispose((Widget)this.combo);
        this.combo = null;
    }

    public CCombo getComboControl() {
        return this.combo;
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    public Control getFocusControl() {
        if (this.combo.isFocusControl()) {
            return this.combo;
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItemCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItems();
        }
        return null;
    }

    @Override
    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    protected void handleComboSelected() {
        if (this.isAmbiguous()) {
            this.setAmbiguous(false);
        }
    }

    protected void initItems(AVData data) {
        String[] newItems;
        AVValueItem[] items;
        if (this.combo == null) {
            return;
        }
        if (data != null && data instanceof AVSelectComponent && (items = ((AVSelectComponent)((Object)data)).getItems()) != null && 0 < items.length && !StringUtil.compare(newItems = AVValueItemUtil.getDisplayStrings(items), this.nowItems)) {
            this.nowItems = newItems;
            this.combo.setItems(this.nowItems);
        }
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.combo != null) {
            this.combo.removeFocusListener((FocusListener)this);
            this.combo.removeSelectionListener((SelectionListener)this);
            if (!this.readonly) {
                this.combo.removeModifyListener((ModifyListener)this);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.combo.setEnabled(this.isEnabled());
    }

    protected abstract void setValue(String var1);

    @Override
    protected void update() {
        this.setValid(true);
        AVData data = this.getDataComponent();
        this.initItems(data);
        if (data != null && data.isValueSpecified()) {
            String value = data.getValue();
            this.setValue(value);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.combo) {
            this.handleComboSelected();
        }
        super.widgetSelected(e);
    }
}

