/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.ImageDescriptorUtil;
import com.ibm.etools.attrview.internal.ResourceHandler;
import com.ibm.etools.attrview.internal.sdk.DisplayString;
import com.ibm.etools.attrview.sdk.AVColorComponent;
import com.ibm.etools.attrview.sdk.AVColorDropper;
import com.ibm.etools.attrview.sdk.AVColorDropperListener;
import com.ibm.etools.attrview.sdk.AVColorProvider;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class AVColorPart
extends AVPart
implements AVColorComponent,
AVSelectComponent,
AVColorDropperListener {
    private static final String DROPPER_TEXT = ResourceHandler._UI_CP_0;
    private static final String DROPPER_TOOLTIP_TEXT = ResourceHandler._UI_CP_1;
    private static final String DROPPER_IMAGE = "picker.gif";
    private static final String BUTTON_TOOLTIP_TEXT = ResourceHandler._UI_CMP_1;
    protected Button button;
    protected CCombo combo;
    protected Button dropper;
    protected AVColorDropper colorDropper;
    protected Color buttonColor;
    protected Image buttonImage;
    protected Image buttonEmptyImage;
    protected Point buttonImageExtent;
    private DisplayString displayString;
    protected AVColorProvider colorProvider;
    private String[] nowItems;

    public AVColorPart(AVData data, Composite parent, String title, AVColorProvider colorProvider) {
        super(data, parent, title);
        this.colorProvider = colorProvider;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.combo != null) {
            this.combo.addFocusListener((FocusListener)this);
            this.combo.addSelectionListener((SelectionListener)this);
            this.combo.addModifyListener((ModifyListener)this);
        }
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
        if (this.colorDropper != null) {
            this.colorDropper.addColorDropperListener(this);
        }
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(4);
            this.createLabel();
        } else {
            this.initializeContainer(3);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.combo = WidgetUtil.createCombo(this.getWidgetFactory(), this.getContainer(), true, false);
        WidgetUtil.setWidthHint((Control)this.combo, WidgetUtil.getTextExtent((Control)this.combo.getParent(), (String)"#FFFFFF").x);
        this.setWidthHint((Control)this.combo, this.getItems());
        this.createColorButton();
        this.createDropperButton();
        this.addListeners();
        this.setControls(new Control[]{this.combo});
    }

    protected void changeButtonColor(String value) {
        String v;
        RGB rgb = null;
        if (value != null && (v = value.trim()).length() > 0 && this.colorProvider != null) {
            rgb = this.colorProvider.stringToRGB(value);
        }
        Display display = this.button.getDisplay();
        Image image = rgb != null ? this.buttonImage : this.buttonEmptyImage;
        GC gc = new GC((Drawable)image);
        gc.setBackground(display.getSystemColor(22));
        gc.fillRectangle(0, 0, this.buttonImageExtent.x, this.buttonImageExtent.y);
        if (rgb != null) {
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 0, this.buttonImageExtent.x - 1, this.buttonImageExtent.y - 1);
            Color color = new Color((Device)display, rgb);
            gc.setBackground(color);
            gc.fillRectangle(1, 1, this.buttonImageExtent.x - 2, this.buttonImageExtent.y - 2);
            color.dispose();
        }
        gc.dispose();
        this.button.setImage(image);
    }

    @Override
    public void colorDropCanceled() {
        this.dropper.setToolTipText(DROPPER_TOOLTIP_TEXT);
    }

    @Override
    public void colorDropped(RGB color) {
        if (this.colorProvider != null) {
            this.setValue(this.colorProvider.rgbToString(color));
            this.setModified(true);
        }
        Event e = new Event();
        e.widget = this.dropper;
        this.fireValueChange();
        this.dropper.setToolTipText(DROPPER_TOOLTIP_TEXT);
    }

    protected Point computeImageSize(Control window) {
        Point p = WidgetUtil.getDefaultTextExtent(window, "....");
        p.x += 12;
        p.y = p.y < 9 ? 9 : p.y;
        return p;
    }

    protected void createColorButton() {
        if (this.getContainer() == null) {
            return;
        }
        if (this.button != null) {
            return;
        }
        this.buttonImageExtent = this.computeImageSize((Control)this.getParent());
        Image image = ImageDescriptorUtil.createFullClcl16ImageDescriptor(DROPPER_IMAGE).createImage();
        if (image != null) {
            Rectangle r = image.getBounds();
            image.dispose();
            if (this.buttonImageExtent.x < r.width) {
                this.buttonImageExtent.x = r.width;
            }
            if (this.buttonImageExtent.y < r.height) {
                this.buttonImageExtent.y = r.height;
            }
        }
        Display display = this.getContainer().getDisplay();
        this.buttonImage = new Image((Device)display, this.buttonImageExtent.x, this.buttonImageExtent.y);
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        ImageData imageData = new ImageData(this.buttonImageExtent.x, this.buttonImageExtent.y, 24, palette);
        imageData.transparentPixel = imageData.palette.getPixel(display.getSystemColor(22).getRGB());
        this.buttonEmptyImage = new Image((Device)display, imageData);
        String title = this.getTitle();
        this.button = WidgetUtil.createImageButton(this.getWidgetFactory(), this.getContainer(), this.buttonEmptyImage, title != null ? title : "", BUTTON_TOOLTIP_TEXT);
        this.changeButtonColor(null);
    }

    protected void createDropperButton() {
        Composite area = WidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), 1);
        Image dropperImage = ImageDescriptorUtil.createFullClcl16ImageDescriptor(DROPPER_IMAGE).createImage();
        this.dropper = WidgetUtil.createImageButton(this.getWidgetFactory(), area, dropperImage, DROPPER_TEXT, DROPPER_TOOLTIP_TEXT);
        Rectangle r = dropperImage.getBounds();
        Point p = this.computeImageSize((Control)this.getParent());
        if (r.height < p.y) {
            WidgetUtil.setHeightHint((Control)this.dropper, p.y + WidgetUtil.IMAGE_HEIGHT_MARGIN);
        }
        this.colorDropper = new AVColorDropper(this.dropper.getDisplay(), this.button);
        this.dropper.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVColorPart.this.dropper.setToolTipText(null);
            }
        });
        this.dropper.addSelectionListener((SelectionListener)this.colorDropper);
    }

    @Override
    public void dispose() {
        super.dispose();
        AVColorPart.dispose((Widget)this.button);
        this.button = null;
        AVColorPart.dispose((Widget)this.combo);
        this.combo = null;
        AVColorPart.dispose(this.buttonImage);
        this.buttonImage = null;
        AVColorPart.dispose(this.buttonEmptyImage);
        this.buttonEmptyImage = null;
        this.buttonImageExtent = null;
        AVColorPart.dispose((Widget)this.dropper);
        this.dropper = null;
        this.colorDropper = null;
    }

    public static boolean dropperAllowed() {
        return true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e != null && e.widget == this.combo && this.isValid()) {
            this.updateButton(this.getValue());
        }
        super.focusLost(e);
    }

    public Button getButtonControl() {
        return this.button;
    }

    @Override
    public RGB getColor() {
        String value = this.getValue();
        if (value != null && this.colorProvider != null) {
            return this.colorProvider.stringToRGB(value);
        }
        return null;
    }

    public CCombo getComboControl() {
        return this.combo;
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    public Control getFocusControl() {
        if (this.combo.isFocusControl()) {
            return this.combo;
        }
        if (this.button.isFocusControl()) {
            return this.button;
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItemCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItems();
        }
        return null;
    }

    @Override
    public int getSelectionIndex() {
        String value = this.combo.getText();
        if (this.displayString != null) {
            value = this.displayString.getValue(value);
        }
        if (value != null && value.length() > 0) {
            return AVValueItemUtil.getItemIndexByValue(this.getItems(), value);
        }
        return -1;
    }

    @Override
    public String getValue() {
        String value = this.combo.getText();
        if (this.displayString != null) {
            value = this.displayString.getValue(value);
        }
        if (value != null && value.length() > 0) {
            AVValueItem[] items = this.getItems();
            int index = AVValueItemUtil.getItemIndexByDisplayString(items, value, true);
            if (index != -1) {
                return AVValueItemUtil.getValue(items, index);
            }
            return value;
        }
        return null;
    }

    protected void initItems(AVData data) {
        String[] newItems;
        AVValueItem[] items;
        if (this.combo == null) {
            return;
        }
        if (data != null && data instanceof AVSelectComponent && (items = ((AVSelectComponent)((Object)data)).getItems()) != null && 0 < items.length && !StringUtil.compare(newItems = AVValueItemUtil.getDisplayStrings(items), this.nowItems)) {
            this.nowItems = newItems;
            this.combo.setItems(this.nowItems);
        }
    }

    public boolean isSpecified() {
        return this.getValue() != null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.combo != null) {
            this.combo.removeFocusListener((FocusListener)this);
            this.combo.removeSelectionListener((SelectionListener)this);
            this.combo.removeModifyListener((ModifyListener)this);
        }
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
        if (this.colorDropper != null) {
            this.colorDropper.removeColorDroppperListener(this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.updateButton(null);
        this.combo.setText("");
        this.displayString = null;
    }

    @Override
    public void setAmbiguous(boolean ambiguous) {
        super.setAmbiguous(ambiguous);
        if (ambiguous) {
            this.changeButtonColor(null);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.combo.setEnabled(enabled);
        this.dropper.setEnabled(enabled);
    }

    protected void setValue(String value) {
        this.updateButton(value);
        AVValueItem[] items = this.getItems();
        int index = AVValueItemUtil.getItemIndexByValue(items, value);
        if (index != -1) {
            int comboIndex = this.combo.getSelectionIndex();
            if (index != comboIndex) {
                this.displayString = new DisplayString(items[index].getDisplayString());
                this.combo.setText(this.displayString.getDisplayString());
                this.combo.select(index);
            }
        } else {
            this.displayString = new DisplayString(value);
            this.combo.setText(this.displayString.getDisplayString());
        }
    }

    @Override
    protected void update() {
        this.setValid(true);
        AVData data = this.getDataComponent();
        this.initItems(data);
        if (data != null && data.isValueSpecified()) {
            String value = data.getValue();
            this.setValue(value);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    protected void updateButton(String value) {
        if (this.isValid()) {
            this.changeButtonColor(value);
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateButton(this.getValue());
        this.setModified(true);
        this.fireValueChange();
        super.widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            RGB rgb;
            ColorDialog dialog = new ColorDialog(this.getParent().getShell(), 4096);
            if (this.getColor() != null) {
                dialog.setRGB(this.getColor());
            }
            if ((rgb = dialog.open()) == null) {
                return;
            }
            if (this.isAmbiguous()) {
                this.setAmbiguous(false);
            }
            if (this.colorProvider != null) {
                this.setValue(this.colorProvider.rgbToString(rgb));
                this.setModified(true);
            }
        } else if (e.widget == this.combo) {
            this.updateButton(this.getValue());
            this.setModified(true);
        }
        this.fireValueChange();
        super.widgetSelected(e);
    }
}

