/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.internal.ImageDescriptorUtil;
import com.ibm.etools.attrview.internal.ResourceHandler;
import com.ibm.etools.attrview.internal.sdk.DisplayString;
import com.ibm.etools.attrview.sdk.AVColorComponent;
import com.ibm.etools.attrview.sdk.AVColorDropper;
import com.ibm.etools.attrview.sdk.AVColorDropperListener;
import com.ibm.etools.attrview.sdk.AVColorProvider;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AVColorMenuPart
extends AVPart
implements AVColorComponent,
AVSelectComponent,
AVColorDropperListener {
    private static final String DROPPER_TEXT = ResourceHandler._UI_CP_0;
    private static final String BROWSE_TEXT = ResourceHandler._UI_CMP_0;
    private static final String BUTTON_TOOLTIP_TEXT = ResourceHandler._UI_CMP_1;
    protected static final String[] MENU_ITEMS = new String[]{DROPPER_TEXT, BROWSE_TEXT, null};
    protected static final String[] MENU_ITEMS_NO_DROPPER = new String[]{BROWSE_TEXT, null};
    protected static final String DROPPER_IMAGE = "picker.gif";
    protected static final int DROPPER = 0;
    protected static final int BROWSE = 1;
    protected Button button;
    protected Text text;
    protected AVColorDropper colorDropper;
    protected Color buttonColor;
    protected Image buttonImage;
    protected Image buttonEmptyImage;
    protected Point buttonImageExtent;
    private DisplayString displayString;
    protected AVColorProvider colorProvider;
    protected Menu menu;
    protected MenuItem[] menuItems;
    private boolean updateMenu;

    public AVColorMenuPart(AVData data, Composite parent, String title, AVColorProvider colorProvider) {
        this(data, parent, title, colorProvider, false);
    }

    public AVColorMenuPart(AVData data, Composite parent, String title, AVColorProvider colorProvider, boolean updateMenu) {
        super(data, parent, title);
        this.colorProvider = colorProvider;
        this.updateMenu = updateMenu;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this);
            this.text.addSelectionListener((SelectionListener)this);
            this.text.addModifyListener((ModifyListener)this);
        }
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    protected void addImageDisposeListener(MenuItem item) {
        if (item == null) {
            return;
        }
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img;
                if (e.widget instanceof MenuItem && (img = ((MenuItem)e.widget).getImage()) != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(3);
            this.createLabel();
        } else {
            this.initializeContainer(2);
        }
        this.text = WidgetUtil.createTextField(this.getWidgetFactory(), this.getContainer(), true, false);
        WidgetUtil.setWidthHint((Control)this.text, WidgetUtil.getTextExtent((Control)this.text.getParent(), (String)"#FFFFFF").x);
        this.setWidthHint((Control)this.text, this.getItems());
        this.createColorButton();
        this.addListeners();
        this.setControls(new Control[]{this.text});
    }

    protected void changeButtonColor(String value) {
        String v;
        RGB rgb = null;
        if (value != null && (v = value.trim()).length() > 0 && this.colorProvider != null) {
            rgb = this.colorProvider.stringToRGB(value);
        }
        Display display = this.button.getDisplay();
        Image image = rgb != null ? this.buttonImage : this.buttonEmptyImage;
        GC gc = new GC((Drawable)image);
        gc.setBackground(display.getSystemColor(22));
        gc.fillRectangle(0, 0, this.buttonImageExtent.x, this.buttonImageExtent.y);
        if (rgb != null) {
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 0, this.buttonImageExtent.x - 1, this.buttonImageExtent.y - 1);
            Color color = new Color((Device)display, rgb);
            gc.setBackground(color);
            gc.fillRectangle(1, 1, this.buttonImageExtent.x - 2, this.buttonImageExtent.y - 2);
            color.dispose();
        }
        gc.dispose();
        this.button.setImage(image);
    }

    @Override
    public void colorDropCanceled() {
    }

    @Override
    public void colorDropped(RGB color) {
        if (this.colorProvider != null) {
            this.setValue(this.colorProvider.rgbToString(color));
            this.setModified(true);
        }
        this.fireValueChange();
    }

    protected Point computeImageSize(Control window) {
        Point p = WidgetUtil.getDefaultTextExtent(window, "....");
        p.x += 12;
        p.y = p.y < 9 ? 9 : p.y;
        return p;
    }

    protected void createColorButton() {
        if (this.getContainer() == null) {
            return;
        }
        if (this.button != null) {
            return;
        }
        this.buttonImageExtent = this.computeImageSize((Control)this.getParent());
        Image image = ImageDescriptorUtil.createFullClcl16ImageDescriptor(DROPPER_IMAGE).createImage();
        if (image != null) {
            Rectangle r = image.getBounds();
            image.dispose();
            if (this.buttonImageExtent.x < r.width) {
                this.buttonImageExtent.x = r.width;
            }
            if (this.buttonImageExtent.y < r.height) {
                this.buttonImageExtent.y = r.height;
            }
        }
        Display display = this.getContainer().getDisplay();
        this.buttonImage = new Image((Device)display, this.buttonImageExtent.x, this.buttonImageExtent.y);
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        ImageData imageData = new ImageData(this.buttonImageExtent.x, this.buttonImageExtent.y, 24, palette);
        imageData.transparentPixel = imageData.palette.getPixel(display.getSystemColor(22).getRGB());
        this.buttonEmptyImage = new Image((Device)display, imageData);
        String title = this.getTitle();
        this.button = WidgetUtil.createImageButton(this.getWidgetFactory(), this.getContainer(), this.buttonEmptyImage, title != null ? title : BUTTON_TOOLTIP_TEXT, BUTTON_TOOLTIP_TEXT);
        this.changeButtonColor(null);
    }

    protected Image createColorImage(Control control, String value) {
        String v;
        if (control == null) {
            return null;
        }
        RGB rgb = null;
        if (value != null && (v = value.trim()).length() > 0 && this.colorProvider != null) {
            rgb = this.colorProvider.stringToRGB(value);
        }
        if (rgb == null) {
            return null;
        }
        Display display = control.getDisplay();
        Point imageExtent = this.computeImageSize((Control)control.getParent());
        Image image = new Image((Device)display, imageExtent.x, imageExtent.y);
        GC gc = new GC((Drawable)image);
        gc.setBackground(display.getSystemColor(22));
        gc.fillRectangle(0, 0, imageExtent.x, imageExtent.y);
        if (rgb != null) {
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 0, imageExtent.x - 1, imageExtent.y - 1);
            Color color = new Color((Device)display, rgb);
            gc.setBackground(color);
            gc.fillRectangle(1, 1, imageExtent.x - 2, imageExtent.y - 2);
            color.dispose();
        }
        gc.dispose();
        return image;
    }

    protected void createColorMenu(AVValueItem[] items) {
        int i;
        if (items == null || items.length == 0) {
            return;
        }
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu((Control)this.button);
        }
        if (this.menuItems != null) {
            AVColorMenuPart.dispose(this.menuItems);
        }
        String[] menuNames = this.getMenuNames();
        int preItemsLen = menuNames.length;
        this.menuItems = new MenuItem[items.length + preItemsLen];
        if (this.colorDropper == null) {
            this.colorDropper = new AVColorDropper(this.button.getDisplay(), this.button);
            this.colorDropper.addColorDropperListener(this);
        }
        for (i = 0; i < preItemsLen; ++i) {
            if (menuNames[i] != null) {
                this.menuItems[i] = new MenuItem(this.menu, 8);
                this.menuItems[i].setText(menuNames[i]);
            } else {
                this.menuItems[i] = new MenuItem(this.menu, 2);
            }
            if (i == 0) {
                this.menuItems[i].addSelectionListener((SelectionListener)this.colorDropper);
                continue;
            }
            this.menuItems[i].addSelectionListener((SelectionListener)this);
        }
        this.menuItems[0].setImage(ImageDescriptorUtil.createFullClcl16ImageDescriptor(DROPPER_IMAGE).createImage());
        this.addImageDisposeListener(this.menuItems[0]);
        for (i = 0; i < items.length; ++i) {
            String colorValue = items[i].getValue();
            String colorString = items[i].getDisplayString();
            this.menuItems[i + preItemsLen] = new MenuItem(this.menu, 8);
            Image colorImage = this.createColorImage((Control)this.button, colorValue);
            this.menuItems[i + preItemsLen].setText(colorString);
            if (colorImage != null) {
                this.menuItems[i + preItemsLen].setImage(colorImage);
                this.addImageDisposeListener(this.menuItems[i + preItemsLen]);
            }
            this.menuItems[i + preItemsLen].addSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        AVColorMenuPart.dispose((Widget)this.button);
        this.button = null;
        AVColorMenuPart.dispose((Widget)this.text);
        this.text = null;
        AVColorMenuPart.dispose(this.buttonImage);
        this.buttonImage = null;
        AVColorMenuPart.dispose(this.buttonEmptyImage);
        this.buttonEmptyImage = null;
        this.buttonImageExtent = null;
        this.colorDropper = null;
        AVColorMenuPart.dispose((Widget)this.menu);
        this.menu = null;
        AVColorMenuPart.dispose(this.menuItems);
        this.menuItems = null;
    }

    protected static void dispose(MenuItem[] items) {
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                AVColorMenuPart.dispose((Widget)items[i]);
                items[i] = null;
            }
        }
    }

    public static boolean dropperAllowed() {
        return true;
    }

    protected void enableMenuItems() {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e != null && e.widget == this.text && this.isValid()) {
            this.updateButton(this.getValue());
        }
        super.focusLost(e);
    }

    public Button getButtonControl() {
        return this.button;
    }

    @Override
    public RGB getColor() {
        String value = this.getValue();
        if (value != null && this.colorProvider != null) {
            return this.colorProvider.stringToRGB(value);
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        if (this.button.isFocusControl()) {
            return this.button;
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItemCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItems();
        }
        return null;
    }

    protected String[] getMenuNames() {
        return MENU_ITEMS;
    }

    @Override
    public int getSelectionIndex() {
        String value = this.text.getText();
        if (this.displayString != null) {
            value = this.displayString.getValue(value);
        }
        if (value != null && value.length() > 0) {
            return AVValueItemUtil.getItemIndexByValue(this.getItems(), value);
        }
        return -1;
    }

    public Text getTextControl() {
        return this.text;
    }

    @Override
    public String getValue() {
        String value = this.text.getText();
        if (this.displayString != null) {
            value = this.displayString.getValue(value);
        }
        if (value != null && value.length() > 0) {
            AVValueItem[] items = this.getItems();
            int index = AVValueItemUtil.getItemIndexByDisplayString(items, value, true);
            if (index != -1) {
                return AVValueItemUtil.getValue(items, index);
            }
            return value;
        }
        return null;
    }

    protected void initItems(AVData data) {
        if (this.text == null) {
            return;
        }
    }

    public boolean isSpecified() {
        return this.getValue() != null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.text != null) {
            this.text.removeFocusListener((FocusListener)this);
            this.text.removeSelectionListener((SelectionListener)this);
            this.text.removeModifyListener((ModifyListener)this);
        }
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.updateButton(null);
        this.text.setText("");
        this.displayString = null;
    }

    @Override
    public void setAmbiguous(boolean ambiguous) {
        super.setAmbiguous(ambiguous);
        if (ambiguous) {
            this.changeButtonColor(null);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    protected void setValue(String value) {
        this.updateButton(value);
        AVValueItem[] items = this.getItems();
        int index = AVValueItemUtil.getItemIndexByValue(items, value);
        if (index != -1) {
            this.displayString = new DisplayString(items[index].getDisplayString());
            this.text.setText(this.displayString.getDisplayString());
        } else {
            this.displayString = new DisplayString(value);
            this.text.setText(this.displayString.getDisplayString());
        }
    }

    @Override
    protected void update() {
        this.setValid(true);
        AVData data = this.getDataComponent();
        this.initItems(data);
        if (data != null && data.isValueSpecified()) {
            String value = data.getValue();
            this.setValue(value);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    protected void updateButton(String value) {
        if (this.isValid()) {
            this.changeButtonColor(value);
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateButton(this.getValue());
        this.setModified(true);
        this.fireValueChange();
        super.widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            AVData data;
            if ((this.updateMenu || this.menu == null || this.menu.isDisposed()) && (data = this.getDataComponent()) != null && data instanceof AVSelectComponent) {
                AVValueItem[] items = ((AVSelectComponent)((Object)data)).getItems();
                this.createColorMenu(items);
            }
            if (this.menu != null) {
                Point p = this.button.getLocation();
                Rectangle r = this.button.getBounds();
                p.y += r.height;
                p = this.button.getParent().toDisplay(p);
                this.menu.setLocation(p.x, p.y);
                this.enableMenuItems();
                this.menu.setVisible(true);
            }
        } else if (e.widget == this.text) {
            this.updateButton(this.getValue());
            this.setModified(true);
        } else if (this.menuItems != null) {
            int brouseIndex;
            int index = -1;
            for (int i = 0; i < this.menuItems.length; ++i) {
                if (e.widget != this.menuItems[i]) continue;
                index = i;
                break;
            }
            if (index == (brouseIndex = 1)) {
                RGB rgb;
                ColorDialog dialog = new ColorDialog(this.getParent().getShell(), 4096);
                if (this.getColor() != null) {
                    dialog.setRGB(this.getColor());
                }
                if ((rgb = dialog.open()) == null) {
                    return;
                }
                if (this.isAmbiguous()) {
                    this.setAmbiguous(false);
                }
                if (this.colorProvider != null) {
                    this.setValue(this.colorProvider.rgbToString(rgb));
                    this.setModified(true);
                }
            } else if (this.getMenuNames().length <= index && index < this.menuItems.length) {
                String v = AVValueItemUtil.getValue(this.getItems(), this.menuItems[index].getText());
                this.setValue(v);
                this.setModified(true);
            }
        }
        this.fireValueChange();
        super.widgetSelected(e);
    }
}

