/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVBooleanComponent;
import com.ibm.etools.attrview.sdk.AVButtonPart;
import com.ibm.etools.attrview.sdk.AVData;
import org.eclipse.swt.widgets.Composite;

public class AVCheckButtonPart
extends AVButtonPart
implements AVBooleanComponent {
    private boolean reversal;
    private boolean defaultSelection;
    private int retStyle;
    public static final int STR_EMPTY = 0;
    public static final int STR_NONE = 1;
    public static final int STR_TRUE_ONLY = 2;
    public static final int STR_TRUE_FALSE = 3;
    public static final int STR_ZERO_ONE = 4;

    public AVCheckButtonPart(AVData data, Composite parent, String title, String caption) {
        this(data, parent, title, caption, false, 0);
    }

    public AVCheckButtonPart(AVData data, Composite parent, String title, String caption, boolean reversal) {
        this(data, parent, title, caption, reversal, 0);
    }

    public AVCheckButtonPart(AVData data, Composite parent, String title, String caption, boolean reversal, int retStyle) {
        super(data, parent, title, 32, caption);
        this.reversal = reversal;
        this.retStyle = retStyle;
    }

    @Override
    public boolean getBoolean() {
        return this.getSelection();
    }

    protected boolean getSelection() {
        if (this.reversal) {
            return !this.button.getSelection();
        }
        return this.button.getSelection();
    }

    @Override
    public String getValue() {
        if (this.retStyle == 1) {
            return this.getBoolean() ? "none" : null;
        }
        if (this.retStyle == 3) {
            return this.getBoolean() ? "true" : "false";
        }
        if (this.retStyle == 4) {
            return this.getBoolean() ? "1" : "0";
        }
        if (this.retStyle == 2) {
            return this.getBoolean() ? "true" : null;
        }
        return this.getBoolean() ? "" : null;
    }

    @Override
    protected void handleButtonSelected() {
        super.handleButtonSelected();
        this.setModified(true);
        this.fireValueChange();
    }

    public boolean isSpecified() {
        return this.getBoolean();
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelection(this.defaultSelection);
    }

    protected void setBoolean(boolean bool) {
        this.setSelection(bool);
    }

    public void setDefaultSelection(boolean defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    protected void setSelection(boolean selected) {
        if (this.reversal) {
            this.button.setSelection(!selected);
        } else {
            this.button.setSelection(selected);
        }
    }

    @Override
    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            boolean selection = false;
            if (data instanceof AVBooleanComponent) {
                selection = ((AVBooleanComponent)((Object)data)).getBoolean();
            }
            this.setSelection(selection);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }
}

