/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AVButtonsPart
extends AVPart
implements AVSelectComponent {
    protected Button[] buttons;
    protected int style;
    protected int numColumns;
    protected int defaultIndex = -1;

    public AVButtonsPart(AVData data, Composite parent, String title, int style) {
        this(data, parent, title, style, -1);
    }

    public AVButtonsPart(AVData data, Composite parent, String title, int style, int numColumns) {
        super(data, parent, title);
        this.style = style;
        this.numColumns = numColumns;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].addFocusListener((FocusListener)this);
                this.buttons[i].addSelectionListener((SelectionListener)this);
            }
        }
    }

    public void alignWidth() {
        WidgetUtil.alignWidth((Control[])this.buttons);
    }

    protected void createContents() {
        Composite buttonArea;
        int n;
        int itemCount = this.getItemCount();
        int n2 = n = this.numColumns > 0 ? this.numColumns : itemCount;
        if (this.getTitle() != null) {
            this.initializeContainer(2);
            this.createLabel();
            buttonArea = WidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), n);
        } else {
            this.initializeContainer(n);
            buttonArea = this.getContainer();
        }
        this.buttons = new Button[itemCount];
        AVValueItem[] values = this.getItems();
        if (values != null && values.length > 0) {
            for (int i = 0; i < itemCount; ++i) {
                this.buttons[i] = WidgetUtil.createButton(this.getWidgetFactory(), buttonArea, values[i].getDisplayString(), this.style, null);
            }
        }
        this.addListeners();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                AVButtonsPart.dispose((Widget)this.buttons[i]);
                this.buttons[i] = null;
            }
            this.buttons = null;
        }
    }

    public Button[] getButtons() {
        return this.buttons;
    }

    @Override
    public Control getControl() {
        return this.buttons != null && 0 < this.buttons.length ? this.buttons[0] : super.getControl();
    }

    @Override
    public Control getFocusControl() {
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (!this.buttons[i].isFocusControl()) continue;
                return this.buttons[i];
            }
        }
        return super.getFocusControl();
    }

    @Override
    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItemCount();
        }
        return 0;
    }

    @Override
    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)((Object)this.getDataComponent())).getItems();
        }
        return null;
    }

    @Override
    public int getSelectionIndex() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].getSelection()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getValue() {
        int sel = this.getSelectionIndex();
        return AVValueItemUtil.getValue(this.getItems(), sel);
    }

    protected void handleButtonSelected(int index) {
        if (this.isAmbiguous()) {
            this.setAmbiguous(false);
        }
    }

    protected int indexOf(Widget widget) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (widget != this.buttons[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isSpecified() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].getSelection()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].removeFocusListener((FocusListener)this);
                this.buttons[i].removeSelectionListener((SelectionListener)this);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setSelection(i == this.defaultIndex);
        }
    }

    protected void select(int index) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setSelection(i == index);
        }
        this.setModified(true);
    }

    @Override
    public void setAmbiguous(boolean ambiguous) {
        super.setAmbiguous(ambiguous);
        if (ambiguous) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setSelection(false);
            }
        }
    }

    public void setDefaultIndex(int defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setEnabled(enabled);
        }
    }

    public void setSelectionIndex(int index) {
        this.select(index);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        int index = this.indexOf(e.widget);
        if (index != -1) {
            this.handleButtonSelected(index);
        }
        super.widgetSelected(e);
    }
}

