/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AVButtonPart
extends AVPart {
    protected Button button;
    protected String caption;
    protected Image image;
    protected int style;

    public AVButtonPart(AVData data, Composite parent, String title, int style, String caption) {
        this(data, parent, title, style, caption, null);
    }

    public AVButtonPart(AVData data, Composite parent, String title, int style, String caption, Image image) {
        super(data, parent, title);
        this.style = style;
        this.caption = caption;
        this.image = image;
        this.createContents();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(2);
            this.createLabel();
        } else {
            this.initializeContainer(1);
        }
        String text = this.image == null ? this.caption : null;
        this.button = WidgetUtil.createButton(this.getWidgetFactory(), this.getContainer(), text, this.style, null);
        if (this.image != null) {
            this.setButtonImage(this.image);
            WidgetUtil.addAccessibleListener((Control)this.button, this.caption);
        }
        this.addListeners();
    }

    @Override
    public void dispose() {
        super.dispose();
        AVButtonPart.dispose((Widget)this.button);
        this.button = null;
        AVButtonPart.dispose(this.image);
        this.image = null;
    }

    public Button getButtonControl() {
        return this.button;
    }

    @Override
    public Control getControl() {
        return this.button;
    }

    @Override
    public Control getFocusControl() {
        if (this.button.isFocusControl()) {
            return this.button;
        }
        return super.getFocusControl();
    }

    protected void handleButtonSelected() {
        if (this.isAmbiguous()) {
            this.setAmbiguous(false);
        }
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
    }

    @Override
    public void setAmbiguous(boolean ambiguous) {
        super.setAmbiguous(ambiguous);
        if (ambiguous) {
            this.button.setSelection(false);
        }
    }

    public void setButtonImage(Image image) {
        if (image != null && this.button != null) {
            this.button.setToolTipText(this.caption);
            this.button.setImage(image);
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Image img;
                    if (e.widget instanceof Button && (img = ((Button)e.widget).getImage()) != null && !img.isDisposed()) {
                        img.dispose();
                    }
                }
            });
            Rectangle r = image.getBounds();
            Object layoutData = this.button.getLayoutData();
            GridData gd = null;
            if (layoutData instanceof GridData) {
                gd = (GridData)layoutData;
            }
            if (gd == null) {
                gd = new GridData();
            }
            gd.heightHint = r.height + WidgetUtil.IMAGE_HEIGHT_MARGIN;
            gd.widthHint = r.width + WidgetUtil.IMAGE_WIDTH_MARGIN;
            this.button.setLayoutData((Object)gd);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(this.isEnabled());
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            this.handleButtonSelected();
        }
        super.widgetSelected(e);
    }
}

