/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.internal.properties;

import com.ibm.etools.attrview.AVContents;
import com.ibm.etools.attrview.AVContentsChangeListener;
import com.ibm.etools.attrview.AVContentsChangedEvent;
import com.ibm.etools.attrview.AVEditorContextChangeListener;
import com.ibm.etools.attrview.AVEditorContextChangedEvent;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVEditorWatcher;
import com.ibm.etools.attrview.AVFocusControlProvider;
import com.ibm.etools.attrview.AVGlobalActionProvider;
import com.ibm.etools.attrview.AVHelpProvider;
import com.ibm.etools.attrview.AVTabItem;
import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.AbstractAttributesView;
import com.ibm.etools.attrview.AbstractAttributesViewContributor;
import com.ibm.etools.attrview.AbstractEditorContextProvider;
import com.ibm.etools.attrview.AbstractTabItem;
import com.ibm.etools.attrview.AttributesViewContributor;
import com.ibm.etools.attrview.internal.ContributorManager;
import com.ibm.etools.attrview.internal.FlatWidgetFactory;
import com.ibm.etools.attrview.internal.ResourceHandler;
import com.ibm.etools.attrview.internal.properties.NotAvailableContents;
import com.ibm.etools.attrview.internal.views.AVGlobalActionManager;
import com.ibm.etools.attrview.utils.RegistryUtil;
import com.ibm.etools.attrview.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabItem;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public final class ContentsManager
extends AbstractAttributesView
implements AVFocusControlProvider {
    private static final String TAG_SELECTION = "selection";
    private static final String ATT_EDITOR_ID = "editorId";
    private Composite parent;
    private PageBook pageContainer;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private ISection section;
    private FlatWidgetFactory widgetFactory;
    private AttributesViewContributor activeContributor;
    private AVContents activeContents;
    private AVGlobalActionManager globalActionManager;
    private IWorkbenchPart activePart;
    private AVContents newContents;
    private AttributesViewContributor newContributor;
    private HashMap userData = new HashMap();
    private AVEditorContextProvider activeEditorContext;
    private AVEditorContextChangeListener contextChangeListener = new AVEditorContextChangeListener(){

        @Override
        public void contextChanged(AVEditorContextChangedEvent e) {
            ContentsManager.this.editorEvent = true;
            ContentsManager.this.updateContents();
        }
    };
    private boolean editorEvent;
    private boolean processingUpdateTabs;
    private TabItemCache[] currentTabs;
    private NotAvailableContents notAvailableContents;
    private static final boolean ENABLE_DELAY_UPDATE = true;
    private static final boolean ENABLE_BUSY_INDICATOR = false;
    private Display display;
    private UpdateListener internalListener;
    private int delayMSecs = 300;
    private boolean forceOverrideTabs;
    private IViewPart viewPart;
    private ArrayList contentsChangeListeners = new ArrayList();

    public ContentsManager(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage, ISection section) {
        this.parent = parent;
        this.tabbedPropertySheetPage = tabbedPropertySheetPage;
        this.section = section;
        this.widgetFactory = new FlatWidgetFactory(tabbedPropertySheetPage.getWidgetFactory());
        this.pageContainer = new PageBook(parent, 0);
        this.globalActionManager = new AVGlobalActionManager(this);
        this.initActionBars(this.getActionBars());
        this.notAvailableContents = new NotAvailableContents(this);
        this.display = tabbedPropertySheetPage.getSite().getShell().getDisplay();
    }

    public void dispose() {
        if (this.activeEditorContext != null) {
            this.activeEditorContext.removeContextChangeListener(this.contextChangeListener);
            this.activeEditorContext = null;
        }
        IConfigurationElement[] contributors = ContributorManager.getConfigurations();
        for (int i = 0; i < contributors.length; ++i) {
            AttributesViewContributor contributor = ContributorManager.getContributor(contributors[i], false);
            if (contributor == null) continue;
            contributor.viewDestroyed(this);
        }
        if (this.notAvailableContents != null) {
            this.notAvailableContents.dispose();
            this.notAvailableContents = null;
        }
        this.parent = null;
        if (this.pageContainer != null) {
            this.pageContainer.dispose();
            this.pageContainer = null;
        }
        this.globalActionManager = null;
        this.viewPart = null;
    }

    @Override
    public AVWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    @Override
    public Object getData(Object key) {
        return this.userData.get(key);
    }

    @Override
    public AVGlobalActionProvider getGlobalActionProvider() {
        return this.globalActionManager;
    }

    @Override
    public Composite getPageContainer() {
        return this.getPageBook();
    }

    @Override
    public void removeData(Object key) {
        this.userData.remove(key);
    }

    @Override
    public void setData(Object key, Object data) {
        this.userData.put(key, data);
    }

    @Override
    public IWorkbenchSite getSite() {
        return this.tabbedPropertySheetPage.getSite();
    }

    @Override
    public IActionBars getActionBars() {
        return this.tabbedPropertySheetPage.getSite().getActionBars();
    }

    private void setWorkbenchPart(IWorkbenchPart part) {
        if (part != null) {
            AVEditorContextProvider editorContext = (AVEditorContextProvider)part.getAdapter(AVEditorContextProvider.class);
            if (editorContext != null) {
                if (this.activeEditorContext != editorContext) {
                    if (this.activeEditorContext != null) {
                        this.activeEditorContext.removeContextChangeListener(this.contextChangeListener);
                    }
                    this.activePart = part;
                    this.activeEditorContext = editorContext;
                    this.activeEditorContext.addContextChangeListener(this.contextChangeListener);
                }
            } else if (!part.getClass().getName().equals("com.ibm.etools.qev.view.QEVView") && part != this.getViewPart() && this.activeEditorContext != null) {
                this.activeEditorContext.removeContextChangeListener(this.contextChangeListener);
                this.activeEditorContext = null;
            }
        }
    }

    private void stopWatcher() {
        AVEditorWatcher watcher;
        if (this.activeEditorContext != null && (watcher = this.activeEditorContext.getEditorWatcher()) != null) {
            watcher.stop();
        }
    }

    private void updateContents() {
        if (Display.getCurrent() != Display.getDefault()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ContentsManager.this.updateContentsBody0();
                }
            });
        } else {
            this.updateContentsBody0();
        }
    }

    private void updateContentsBody0() {
        this.internalListener = new UpdateListener();
        this.display.timerExec(this.delayMSecs, (Runnable)this.internalListener);
    }

    private void updateContentsBody() {
        if (this.parent != null && !this.parent.isDisposed()) {
            if (this.isPropertySheetActive()) {
                BusyIndicator.showWhile((Display)this.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ContentsManager.this.updateContentsBody2();
                    }
                });
            } else {
                this.updateContentsBody2();
            }
        }
    }

    private void updateContentsBody2() {
        int i;
        this.stopWatcher();
        if (!this.validateSection()) {
            return;
        }
        if (this.activeEditorContext != null) {
            this.newContents = null;
            this.newContributor = null;
            IConfigurationElement[] contributors = ContributorManager.getConfigurations();
            for (i = 0; i < contributors.length; ++i) {
                AttributesViewContributor contributor;
                IConfigurationElement config = contributors[i];
                if (!StringUtil.compare(config.getAttribute(ATT_EDITOR_ID), this.activeEditorContext.getEditorId()) || !this.compareSelectionHints(this.activeEditorContext, config) || (contributor = ContributorManager.getContributor(contributors[i], true)) == null) continue;
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        ContentsManager.this.newContents = contributor.getContentsFor(ContentsManager.this, ContentsManager.this.activeEditorContext);
                    }
                });
                if (this.newContents == null) continue;
                this.newContributor = contributor;
                break;
            }
            if (this.activeContributor != this.newContributor) {
                this.activeContributor = this.newContributor;
            }
            if (this.activeContents != this.newContents) {
                this.activeContents = this.newContents;
            }
            if (this.activeContents != null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        ContentsManager.this.activeContents.updateData(ContentsManager.this.activeEditorContext);
                        ContentsManager.this.activeContents.updateControl();
                    }
                });
            }
        } else {
            if (this.activeContributor != null) {
                this.activeContributor = null;
            }
            if (this.activeContents != null) {
                this.activeContents = null;
            }
        }
        Control control = this.activeContents != null ? this.activeContents.getControl() : this.notAvailableContents.getControl();
        this.pageContainer.showPage(control);
        for (i = 0; i < this.contentsChangeListeners.size(); ++i) {
            AVContentsChangeListener listener = (AVContentsChangeListener)this.contentsChangeListeners.get(i);
            listener.contentsChanged(new AVContentsChangedEvent(this, 1, this.activeEditorContext, this.activeContributor, this.activeContents));
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ContentsManager.this.updateTabs();
            }
        });
        this.updateHelp();
        this.updateUndoRedo();
        this.editorEvent = false;
    }

    @Override
    public Widget getFocusControl() {
        if (this.activeContents != null) {
            return this.activeContents.getControl().getDisplay().getFocusControl();
        }
        return this.pageContainer.getDisplay().getFocusControl();
    }

    public AVContents getActiveContents() {
        return this.activeContents;
    }

    public void initActionBars(IActionBars bars) {
        this.globalActionManager.initGlobalActions(bars);
    }

    public PageBook getPageBook() {
        return this.pageContainer;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (this.processingUpdateTabs) {
            return;
        }
        IContributedContentsView view = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (view != null) {
            part = view.getContributingPart();
        }
        if (this.activePart != part || this.activeEditorContext == null) {
            this.setWorkbenchPart(part);
        }
        this.forceOverrideTabs = true;
        this.updateContents();
    }

    private IViewPart getViewPart() {
        if (this.viewPart == null) {
            this.viewPart = this.findViewPart();
        }
        return this.viewPart;
    }

    private IViewPart findViewPart() {
        if (this.activePart != null) {
            IViewPart viewPart = this.activePart.getSite().getPage().findView("org.eclipse.ui.views.PropertySheet");
            if (viewPart != null) {
                return viewPart;
            }
            IViewReference[] viewRefs = this.activePart.getSite().getPage().getViewReferences();
            if (viewRefs != null) {
                for (int i = 0; i < viewRefs.length; ++i) {
                    viewPart = viewRefs[i].getView(false);
                    if (!(viewPart instanceof PropertySheet)) continue;
                    return viewPart;
                }
                if (viewRefs.length > 0) {
                    return viewRefs[0].getView(false);
                }
            }
        }
        return null;
    }

    public void aboutToBeShown() {
        int i;
        IConfigurationElement[] contributors = ContributorManager.getConfigurations();
        for (i = 0; i < contributors.length; ++i) {
            AttributesViewContributor contributor = ContributorManager.getContributor(contributors[i], false);
            if (!(contributor instanceof AbstractAttributesViewContributor)) continue;
            ((AbstractAttributesViewContributor)contributor).aboutToBeShown(this);
        }
        for (i = 0; i < this.contentsChangeListeners.size(); ++i) {
            AVContentsChangeListener listener = (AVContentsChangeListener)this.contentsChangeListeners.get(i);
            listener.contentsChanged(new AVContentsChangedEvent(this, 2, this.activeEditorContext, this.activeContributor, this.activeContents));
        }
    }

    public void aboutToBeHidden() {
        for (int i = 0; i < this.contentsChangeListeners.size(); ++i) {
            AVContentsChangeListener listener = (AVContentsChangeListener)this.contentsChangeListeners.get(i);
            listener.contentsChanged(new AVContentsChangedEvent(this, 3, this.activeEditorContext, this.activeContributor, this.activeContents));
        }
        IConfigurationElement[] contributors = ContributorManager.getConfigurations();
        for (int i = 0; i < contributors.length; ++i) {
            AttributesViewContributor contributor = ContributorManager.getContributor(contributors[i], false);
            if (!(contributor instanceof AbstractAttributesViewContributor)) continue;
            ((AbstractAttributesViewContributor)contributor).aboutToBeHidden(this);
        }
    }

    public void refresh() {
    }

    @Override
    public void refreshContents() {
        this.refreshContents(true);
    }

    @Override
    public void refreshContents(boolean forceOverrideTabs) {
        if (forceOverrideTabs) {
            this.forceOverrideTabs = true;
        }
        this.updateContents();
    }

    public ITabItem[] getTabs() {
        AVTabItem[] tabItems;
        if (this.activeContents != null && (tabItems = this.activeContents.getTabs()) != null && tabItems.length > 0) {
            ITabItem[] dynamicTabItems = new DynamicTabItem[tabItems.length];
            for (int i = 0; i < tabItems.length; ++i) {
                dynamicTabItems[i] = new DynamicTabItem(tabItems[i]);
            }
            return dynamicTabItems;
        }
        return new ITabItem[]{new DefaultTabItem()};
    }

    public void selectTab(int index) {
        this.forceOverrideTabs = true;
        if (this.activeContents != null) {
            this.activeContents.selectTab(index);
        }
        this.updateContents();
    }

    private boolean compareSelectionHints(AVEditorContextProvider editorContext, IConfigurationElement config) {
        String[] configHints = RegistryUtil.getChildValues(config, TAG_SELECTION);
        if (configHints == null) {
            return true;
        }
        String[] editorHints = editorContext.getSelectionHints();
        if (editorHints == null) {
            return true;
        }
        for (int i = 0; i < editorHints.length; ++i) {
            if (!StringUtil.containsIgnoreCase(editorHints[i], configHints)) continue;
            return true;
        }
        return false;
    }

    private void updateTabs() {
        Composite grampa;
        boolean override = this.forceOverrideTabs;
        this.forceOverrideTabs = false;
        AVTabItem[] tabs = null;
        if (this.activeContents != null) {
            tabs = this.activeContents.getTabs();
        }
        if (!ContentsManager.compareTabs(this.currentTabs, tabs)) {
            if (tabs == null || tabs.length == 0) {
                this.currentTabs = null;
            } else {
                ArrayList<TabItemCache> list = new ArrayList<TabItemCache>();
                for (int i = 0; i < tabs.length; ++i) {
                    AVTabItem tab = tabs[i];
                    AVTabItem model = tab instanceof AbstractTabItem ? ((AbstractTabItem)tab).getModel() : tab;
                    list.add(new TabItemCache(model, tab.isSelected(), tab.isIndented()));
                }
                this.currentTabs = list.toArray(new TabItemCache[list.size()]);
            }
            override = true;
        }
        if (override) {
            this.processingUpdateTabs = true;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ContentsManager.this.tabbedPropertySheetPage.overrideTabs();
                }
            });
            this.processingUpdateTabs = false;
        } else if (this.parent != null && (grampa = this.parent.getParent()) != null && !grampa.isDisposed()) {
            grampa.layout(true);
        }
    }

    private static boolean compareTab(TabItemCache a, AVTabItem b) {
        if (a != null && b instanceof AbstractTabItem) {
            return a.getModel().equals(((AbstractTabItem)b).getModel()) && a.isSelected() == b.isSelected() && a.isIndented() == b.isIndented();
        }
        return false;
    }

    private static boolean compareTabs(TabItemCache[] a, AVTabItem[] b) {
        if (a != null && b != null) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (ContentsManager.compareTab(a[i], b[i])) continue;
                return false;
            }
            return true;
        }
        return a == null && b == null;
    }

    private void internalActionPerformed() {
        this.updateContentsBody();
    }

    private void updateHelp() {
        Control control;
        String helpId = null;
        if (this.activeContents instanceof AVHelpProvider) {
            helpId = ((AVHelpProvider)((Object)this.activeContents)).getHelpId();
        }
        if ((control = this.tabbedPropertySheetPage.getControl()) != null && !control.isDisposed()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpId);
        }
    }

    private void updateUndoRedo() {
        if (this.activeEditorContext instanceof AbstractEditorContextProvider) {
            ((AbstractEditorContextProvider)this.activeEditorContext).updateActions(this.getActionBars());
        }
    }

    @Override
    public boolean isEditorEvent() {
        return this.editorEvent && !this.isPropertySheetActive();
    }

    private boolean isPropertySheetActive() {
        if (this.activePart != null) {
            IWorkbenchPart part = this.activePart.getSite().getPage().getActivePart();
            return part == this.getViewPart();
        }
        return false;
    }

    private boolean validateSection() {
        ISection[] sections;
        TabContents tab = this.tabbedPropertySheetPage.getCurrentTab();
        if (tab != null && (sections = tab.getSections()) != null) {
            for (int i = 0; i < sections.length; ++i) {
                if (sections[i] != this.section) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addContentsChangeListener(AVContentsChangeListener listener) {
        if (listener != null && !this.contentsChangeListeners.contains(listener)) {
            this.contentsChangeListeners.add(listener);
        }
    }

    @Override
    public void removeContentsChangeListener(AVContentsChangeListener listener) {
        if (this.contentsChangeListeners.contains(listener)) {
            this.contentsChangeListeners.remove(listener);
        }
    }

    private class UpdateListener
    implements Runnable {
        private UpdateListener() {
        }

        @Override
        public void run() {
            if (this == ContentsManager.this.internalListener) {
                ContentsManager.this.internalActionPerformed();
                ContentsManager.this.internalListener = null;
            }
        }
    }

    private class DynamicTabItem
    implements ITabItem {
        private AVTabItem item;

        public DynamicTabItem(AVTabItem item) {
            this.item = item;
        }

        public Image getImage() {
            Image image = this.item.getImage();
            if (image != null && !image.isDisposed()) {
                return image;
            }
            return null;
        }

        public String getText() {
            return this.item.getText();
        }

        public boolean isIndented() {
            return this.item.isIndented();
        }

        public boolean isSelected() {
            return this.item.isSelected();
        }

        public Object getModel() {
            if (this.item instanceof AbstractTabItem) {
                ((AbstractTabItem)this.item).getModel();
            }
            return this.item;
        }
    }

    private class DefaultTabItem
    implements ITabItem {
        private DefaultTabItem() {
        }

        public Image getImage() {
            return null;
        }

        public String getText() {
            return ResourceHandler._UI_CM_0;
        }

        public boolean isIndented() {
            return false;
        }

        public boolean isSelected() {
            return true;
        }

        public Object getModel() {
            return this;
        }
    }

    private class TabItemCache
    extends AbstractTabItem {
        private Object model;
        private boolean selected;
        private boolean indented;

        public TabItemCache(Object model, boolean selected, boolean indented) {
            this.model = model;
            this.selected = selected;
            this.indented = indented;
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public boolean isIndented() {
            return this.indented;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public Object getModel() {
            return this.model;
        }
    }
}

