/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.internal;

import com.ibm.etools.attrview.internal.Logger;
import com.ibm.etools.attrview.internal.Sorter;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";

    protected RegistryReader() {
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String uniqueID = "";
        if (bundle != null) {
            uniqueID = bundle.getSymbolicName();
        }
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + uniqueID + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.log(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        Sorter sorter = new Sorter(){

            @Override
            public boolean compare(Object extension1, Object extension2) {
                Bundle bundle1 = Platform.getBundle((String)((IExtension)extension1).getContributor().getName());
                Bundle bundle2 = Platform.getBundle((String)((IExtension)extension2).getContributor().getName());
                if (bundle1 != null && bundle2 != null) {
                    String s1 = bundle1.getSymbolicName().toUpperCase(Locale.US);
                    String s2 = bundle2.getSymbolicName().toUpperCase(Locale.US);
                    return s2.compareTo(s1) > 0;
                }
                return false;
            }
        };
        Object[] sorted = sorter.sort(extensions);
        IExtension[] sortedExtension = new IExtension[sorted.length];
        System.arraycopy(sorted, 0, sortedExtension, 0, sorted.length);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (this.readElement(elements[i])) continue;
            this.logUnknownElement(elements[i]);
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    protected void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            for (int i = 0; i < extensions.length; ++i) {
                this.readExtension(extensions[i]);
            }
        }
    }
}

