/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview;

import com.ibm.etools.attrview.AbstractAttributesViewContributor;
import com.ibm.etools.attrview.AttributesViewContributor;
import com.ibm.etools.attrview.internal.Logger;
import com.ibm.etools.attrview.internal.RegistryReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class AttributesViewContributorRegistryReader
extends RegistryReader {
    protected static final String TAG_CONTRIBUTOR = "contributor";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_SINGLETON = "singleton";
    protected static final String ATT_METHOD = "method";
    protected static final String ATT_PRIORITY = "priority";
    protected static final String[] PRIORITIES = new String[]{"highest", "high", "mid", "low", "lowest"};
    protected static final String TRUE = "true";
    private String pluginId;
    private String extensionPoint;
    private IConfigurationElement[] configurations;
    private HashMap contributorMap;
    private ArrayList cache;
    private NullContributor nullContributor = new NullContributor();

    public AttributesViewContributorRegistryReader(String pluginId, String extensionPoint) {
        this.pluginId = pluginId;
        this.extensionPoint = extensionPoint;
    }

    public static AttributesViewContributor createContributorInstance(IConfigurationElement element) {
        Object obj = null;
        try {
            obj = AttributesViewContributorRegistryReader.createExtension(element, ATT_CLASS);
            if (obj instanceof AttributesViewContributor) {
                return (AttributesViewContributor)obj;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        return null;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        if (bundle != null && (bundle.getState() == 8 || bundle.getState() == 32 || bundle.getState() == 16)) {
            return AttributesViewContributorRegistryReader.createExecutableExtension(element, classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = AttributesViewContributorRegistryReader.createExecutableExtension(element, classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    static Object createExecutableExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Object obj = null;
        String singleton = element.getAttribute(ATT_SINGLETON);
        String method = element.getAttribute(ATT_METHOD);
        if (TRUE.equalsIgnoreCase(singleton) && method != null) {
            try {
                String name = element.getAttribute(ATT_CLASS);
                Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
                Class cls = null;
                if (bundle != null) {
                    cls = bundle.loadClass(name);
                }
                Method mtd = cls.getMethod(method, new Class[0]);
                obj = mtd.invoke(null, null);
            }
            catch (ClassNotFoundException e) {
                obj = null;
            }
            catch (NoSuchMethodException e) {
                obj = null;
            }
            catch (IllegalAccessException e) {
                obj = null;
            }
            catch (InvocationTargetException e) {
                obj = null;
            }
        } else {
            obj = element.createExecutableExtension(classAttribute);
        }
        return obj;
    }

    public IConfigurationElement[] getConfigurations() {
        if (this.configurations == null) {
            this.readContributions(this.pluginId, this.extensionPoint);
            int num = this.cache.size();
            if (num == 0) {
                this.configurations = new IConfigurationElement[0];
            }
            ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
            for (int p = 0; p < PRIORITIES.length; ++p) {
                for (int i = 0; i < num; ++i) {
                    IConfigurationElement element;
                    Object obj = this.cache.get(i);
                    if (!(obj instanceof IConfigurationElement) || !PRIORITIES[p].equals((element = (IConfigurationElement)obj).getAttribute(ATT_PRIORITY)) && (p != 2 || element.getAttribute(ATT_PRIORITY) != null)) continue;
                    list.add(element);
                }
            }
            this.configurations = list.toArray(new IConfigurationElement[list.size()]);
            this.cache.clear();
            this.cache = null;
        }
        return this.configurations;
    }

    public AttributesViewContributor getContributor(IConfigurationElement config, boolean create) {
        AttributesViewContributor contributor;
        if (this.contributorMap == null) {
            this.contributorMap = new HashMap();
        }
        if ((contributor = (AttributesViewContributor)this.contributorMap.get(config)) == null && create) {
            contributor = AttributesViewContributorRegistryReader.createContributorInstance(config);
            if (contributor == null) {
                contributor = this.nullContributor;
            }
            this.contributorMap.put(config, contributor);
        }
        return contributor;
    }

    private void readContributions(String pluginId, String extensionPoint) {
        this.cache = new ArrayList();
        this.readRegistry(Platform.getExtensionRegistry(), pluginId, extensionPoint);
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_CONTRIBUTOR)) {
            this.cache.add(element);
            return true;
        }
        this.readElementChildren(element);
        return true;
    }

    private class NullContributor
    extends AbstractAttributesViewContributor {
        private NullContributor() {
        }
    }
}

