/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ejb.ui.internal.utilities;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.AnnotationOverrideInfo;
import com.ibm.etools.annotations.core.data.AttributeOverrideInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import com.ibm.etools.annotations.ejb.ui.listeners.MergedModelListeners;
import com.ibm.etools.javaee.annotations.ejb.converter.EMF2AnnotationAdapterImpl;
import com.ibm.etools.javaee.annotations.ejb.utils.MappingUtils;
import com.ibm.etools.javaee.merge.MergedModelAdapter2;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;

public class OverrideEModelHandler {
    private static MergedModelListeners mlis;
    private static OverrideEModelHandler singleInstance;
    private static EObject mergedModel;
    private static EObject annotationModel;
    private static EObject xmlModel;
    private static IProject curProject;
    private static String curFile;
    private static AnnotationInfo aInfo;
    private static Hashtable<IProject, MergedModelListeners> projectMListeners;
    private static Hashtable<IProject, EObject> projectMModels;
    private static Hashtable<String, Hashtable<String, Hashtable<String, AnnotationOverrideInfo>>> ProjectOverrideInfo;
    private static Hashtable<String, Hashtable<String, AnnotationOverrideInfo>> classOverrideInfo;
    private static Hashtable<String, AnnotationOverrideInfo> annoOverrideInfo;

    private OverrideEModelHandler() {
    }

    public static OverrideEModelHandler getSingleInstance() {
        if (singleInstance == null) {
            projectMModels = new Hashtable();
            singleInstance = new OverrideEModelHandler();
        }
        return singleInstance;
    }

    public IProject getCurProject() {
        return curProject;
    }

    public AnnotationInfo getAInfo() {
        return aInfo;
    }

    public String getCurFile() {
        return curFile;
    }

    public MergedModelListeners getListener(IProject project) {
        return projectMListeners.get(project);
    }

    public EObject getMModel(IProject project) {
        return projectMModels.get(project);
    }

    public Hashtable clearClassOverrideInfo(Hashtable<String, Hashtable<?, ?>> classLists, String className) {
        AnnotationConstants.dump((String)("class name:" + className));
        Hashtable<Object, Object> annotationLists = classLists.get(className);
        if (annotationLists != null) {
            annotationLists = new Hashtable();
            classLists.put(className, annotationLists);
        }
        return classLists;
    }

    public void clearProjectOverrideInfo(IProject project) {
        Hashtable classLists;
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        Hashtable table = this.getProjectOverrideInfo();
        if (table != null && (classLists = (Hashtable)table.get(projectName)) != null && !classLists.isEmpty()) {
            Enumeration classes = classLists.keys();
            while (classes != null && classes.hasMoreElements()) {
                String classname = (String)classes.nextElement();
                AnnotationConstants.dump((String)("class name:" + classname));
                Hashtable annotationLists = (Hashtable)classLists.get(classname);
                if (annotationLists == null) continue;
                annotationLists = new Hashtable();
                classLists.put(classname, annotationLists);
            }
        }
    }

    public void clearOverrideInfo() {
        Hashtable table = this.getProjectOverrideInfo();
        if (table != null) {
            Enumeration projects = table.keys();
            while (projects != null && projects.hasMoreElements()) {
                String projectName = (String)projects.nextElement();
                Hashtable classLists = (Hashtable)table.get(projectName);
                if (classLists == null) continue;
                Enumeration classes = classLists.keys();
                while (classes != null && classes.hasMoreElements()) {
                    String classname = (String)classes.nextElement();
                    Hashtable annotationLists = (Hashtable)classLists.get(classname);
                    if (annotationLists != null) {
                        annotationLists = new Hashtable();
                    }
                    classLists.put(classname, annotationLists);
                }
            }
        }
    }

    public boolean isDeclared(AnnotationInfo aInfo, String attrName) {
        IAnnotationAttributeProperty aap;
        if (aInfo != null && (aap = aInfo.getDeclaredAttribute(attrName)) != null) {
            AnnotationConstants.debug((Object)(attrName + " is declared"));
            return true;
        }
        return false;
    }

    public boolean isImplied(AnnotationInfo aInfo, String attrName) {
        if (aInfo == null) {
            return false;
        }
        if (aInfo.getAttribute(attrName) != null && aInfo.getAttribute(attrName).getImpliedValue() != null) {
            AnnotationConstants.debug((Object)(attrName + " is Implied"));
            return true;
        }
        return false;
    }

    public Hashtable getAllOverridesInfoForAnnotation(IProject project, String fileName, AnnotationInfo aInfo, int offset) {
        Hashtable<String, Hashtable<String, AnnotationOverrideInfo>> table;
        curProject = project;
        curFile = fileName;
        if (project == null) {
            return null;
        }
        if (ProjectOverrideInfo == null || ProjectOverrideInfo != null && ProjectOverrideInfo.get(project.getName()) == null) {
            if (ProjectOverrideInfo == null) {
                ProjectOverrideInfo = new Hashtable();
            }
            try {
                this.processMergedModel(project, fileName);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        if ((table = ProjectOverrideInfo.get(project.getName())) != null) {
            return table.get(fileName);
        }
        return null;
    }

    public EObject getMergedModel() {
        return mergedModel;
    }

    public EObject getAnnotationModel() {
        return annotationModel;
    }

    public EObject getXMLModel() {
        return xmlModel;
    }

    public void processMergedModel(IProject ejbProject, String fileName) {
        if (projectMModels != null && (mergedModel = projectMModels.get(ejbProject)) != null) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)ejbProject);
        if (provider != null) {
            try {
                mergedModel = (EObject)provider.getModelObject(IJEE5ModelProvider.EJB_DD_MODEL_MERGED);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                mergedModel = null;
                return;
            }
            if (mergedModel != null) {
                this.processObjectDetails(mergedModel, 1);
                if (projectMListeners == null) {
                    projectMListeners = new Hashtable();
                }
                if ((mlis = projectMListeners.get(ejbProject)) == null) {
                    mlis = MergedModelListeners.getSingleInstance();
                    mlis.setTopTarget((Notifier)mergedModel, ejbProject);
                    mergedModel.eAdapters().add((Object)mlis);
                    projectMListeners.put(ejbProject, mlis);
                    projectMModels.put(ejbProject, mergedModel);
                }
            }
        }
    }

    public void setMergedModelForProject(IProject project, EObject mmodel) {
        if (projectMModels == null) {
            projectMModels = new Hashtable();
        }
        projectMModels.put(project, mmodel);
    }

    public void dumpListenersInfo(IProject proj) {
        MergedModelListeners mlis = projectMListeners.get(proj);
        if (mlis != null) {
            AnnotationConstants.dump((String)("ObjectList=" + mlis.getMObjectList().size()));
            if (mlis.getMObjectList() != null) {
                AnnotationConstants.dump((String)("ObjectList=" + mlis.getMObjectList().toString()));
            }
            AnnotationConstants.dump((String)("Project=" + String.valueOf(mlis.getProject())));
            AnnotationConstants.dump((String)("TopTarget=" + String.valueOf(mlis.getTopTarget())));
        }
    }

    public void processObjectDetails(EObject mObject, int indent) {
        MergedModelAdapter2 mmAdapter = (MergedModelAdapter2)EcoreUtil.getRegisteredAdapter((EObject)mObject, (Object)MergedModelAdapter2.ADAPTER_CLASS);
        if (mmAdapter != null) {
            EObject aObj = mmAdapter.getAnnotationObject();
            EObject xObj = mmAdapter.getXmlObject();
            if (xObj == null || aObj != null) {
                // empty if block
            }
            EList Mattrs = mObject.eClass().getEAllAttributes();
            for (EAttribute attr2 : Mattrs) {
                if (aObj == null || xObj == null) continue;
                this.AnnotationInfoFromEObject(mObject, attr2, aObj, xObj);
            }
            EList contents = mObject.eContents();
            if (contents != null && contents.size() > 0) {
                for (int i = 0; i < contents.size(); ++i) {
                    EObject o = (EObject)contents.get(i);
                    if (o == null) continue;
                    this.processObjectDetails(o, 1);
                }
            }
        }
    }

    private AnnotationInfo FindEMF2AnnotationAdapter(EObject anObj, Hashtable hash) {
        AnnotationConstants.debug((Object)("trying to locate EMF2AnnotationAdapter " + String.valueOf(anObj)));
        AnnotationInfo aInfo = null;
        if (anObj == null) {
            return null;
        }
        EList eAdapters = anObj.eAdapters();
        if (eAdapters != null) {
            AnnotationConstants.debug((Object)eAdapters.toString());
            for (Adapter a : eAdapters) {
                if (a == null || !(a instanceof EMF2AnnotationAdapterImpl)) continue;
                aInfo = ((EMF2AnnotationAdapterImpl)a).getAnnotationInfo();
                AnnotationConstants.debug((Object)("FFFFFFFFF Leho's adapter:[" + String.valueOf(aInfo) + "]" + aInfo.getName()));
                if (aInfo.getAllAttributes() == null || aInfo.getAllAttributes().isEmpty()) {
                    AnnotationConstants.debug((Object)(aInfo.getName() + " :no attributes offset:" + aInfo.getOffset() + " " + aInfo.getParentJavaElementInfo().getName()));
                    return aInfo;
                }
                if (hash == null) continue;
                AnnotationConstants.debug((Object)("in Leho:return hash size=" + hash.size()));
                Enumeration aKeys = hash.keys();
                while (aKeys != null && aKeys.hasMoreElements()) {
                    String myKey = (String)aKeys.nextElement();
                    if (!aInfo.getName().equals(myKey)) continue;
                    String attrName = (String)hash.get(myKey);
                    AnnotationConstants.debug((Object)("Found Match:in Leho:annotation=" + myKey));
                    AnnotationConstants.debug((Object)("Found Match:in Leho:attribute:" + attrName));
                    return aInfo;
                }
            }
        }
        return null;
    }

    protected void AnnotationInfoFromEObject(EObject aObj, EAttribute aAttributeObj, EObject anObj, EObject xmlObj) {
        AnnotationInfo aInfo;
        Hashtable hash = new Hashtable();
        hash = MappingUtils.getMappingUtils().getAnnotationAttributeForEFeature(anObj, (EStructuralFeature)aAttributeObj);
        String attrName = null;
        String annotationName = null;
        String attributeValue = null;
        IPath uniqueId = null;
        if (AnnotationConstants.isDebug_) {
            this.dumpMapping(hash);
        }
        if ((aInfo = this.FindEMF2AnnotationAdapter(anObj, hash)) != null) {
            annotationName = aInfo.getName();
            attrName = (String)hash.get(annotationName);
            if (aInfo.getParentJavaElementInfo() != null && aInfo.getParentJavaElementInfo().getJavaElement() != null) {
                uniqueId = aInfo.getParentJavaElementInfo().getJavaElement().getPath();
            }
            StringBuffer fullName = new StringBuffer();
            if (aInfo.getPackageName() != null) {
                fullName.append(aInfo.getPackageName());
                fullName.append(".");
            }
            fullName.append(annotationName);
            annotationName = fullName.toString();
            StringBuffer strBuf = new StringBuffer(annotationName);
            strBuf.append(aInfo.getOffset());
            String tagKey = strBuf.toString();
            boolean override = false;
            String xmlAttributeValue = null;
            String anoAttributeValue = null;
            if (attrName == null) {
                override = true;
            } else {
                Object aanObj;
                Object xxObj;
                Object aaObj = aObj.eGet((EStructuralFeature)aAttributeObj);
                if (aaObj != null) {
                    attributeValue = aaObj.toString();
                }
                if (xmlObj != null && (xxObj = xmlObj.eGet((EStructuralFeature)aAttributeObj)) != null) {
                    xmlAttributeValue = xxObj.toString();
                }
                if (anObj != null && (aanObj = anObj.eGet((EStructuralFeature)aAttributeObj)) != null) {
                    anoAttributeValue = aanObj.toString();
                }
                AnnotationConstants.debug((Object)("****" + annotationName + " annotationInfo:" + String.valueOf(aInfo)));
                AnnotationConstants.debug((Object)("***********" + attrName + " attr value in merged:[" + attributeValue + "]"));
                AnnotationConstants.debug((Object)("***********" + attrName + " attr value in xml:[" + xmlAttributeValue + "]"));
                AnnotationConstants.debug((Object)("***********" + attrName + " attr value in annotation:[" + anoAttributeValue + "]"));
                if (xmlObj.eIsSet((EStructuralFeature)aAttributeObj)) {
                    AnnotationConstants.debug((Object)(attrName + " value is set in XML:" + xmlAttributeValue));
                    override = anObj != null;
                } else {
                    AnnotationConstants.debug((Object)(attrName + " value is not set in XML:" + xmlAttributeValue));
                    override = false;
                }
            }
            AttributeOverrideInfo attrOverInfo = null;
            AnnotationOverrideInfo aOverInfo = null;
            AnnotationConstants.debug((Object)(String.valueOf(uniqueId) + " :override:" + override + " :" + annotationName + ":" + attrName));
            IProject aProject = this.getCurProject();
            if (override && uniqueId != null) {
                AnnotationConstants.debug((Object)aProject.getName());
                classOverrideInfo = ProjectOverrideInfo.get(aProject.getName());
                if (classOverrideInfo == null) {
                    AnnotationConstants.debug((Object)("path=" + uniqueId.toString()));
                    classOverrideInfo = new Hashtable();
                    annoOverrideInfo = new Hashtable();
                    aOverInfo = new AnnotationOverrideInfo(annotationName);
                    if (attrName != null) {
                        attrOverInfo = new AttributeOverrideInfo(attrName);
                    }
                } else {
                    annoOverrideInfo = classOverrideInfo.get(uniqueId.toString());
                    if (annoOverrideInfo == null) {
                        annoOverrideInfo = new Hashtable();
                        aOverInfo = new AnnotationOverrideInfo(annotationName);
                        if (attrName != null) {
                            attrOverInfo = new AttributeOverrideInfo(attrName);
                        }
                    } else {
                        aOverInfo = annoOverrideInfo.get(tagKey);
                        if (aOverInfo == null) {
                            aOverInfo = new AnnotationOverrideInfo(annotationName);
                        }
                        if (attrName != null && (attrOverInfo = aOverInfo.getAttributeInfo(attrName)) == null) {
                            attrOverInfo = new AttributeOverrideInfo(attrName);
                        }
                    }
                }
                if (aObj != null && anObj != null && attrOverInfo != null) {
                    attrOverInfo.setAnnotationValue((Object)anoAttributeValue);
                }
                if (aObj != null && xmlObj != null && attrOverInfo != null) {
                    AnnotationConstants.debug((Object)("merged model attrvalue=" + attributeValue));
                    attrOverInfo.setValue((Object)attributeValue);
                }
                if (attrOverInfo != null) {
                    attrOverInfo.setImplied(this.isImplied(aInfo, attrName));
                    attrOverInfo.setDeclared(this.isDeclared(aInfo, attrName));
                }
                aOverInfo.setAttributeOverrideInfo(attrOverInfo);
                aOverInfo.setAnnotationObject(aInfo.getAnnotation());
                aOverInfo.setOffset(aInfo.getOffset());
                annoOverrideInfo.put(tagKey, aOverInfo);
                classOverrideInfo.put(uniqueId.toString(), annoOverrideInfo);
                ProjectOverrideInfo.put(aProject.getName(), classOverrideInfo);
                AnnotationConstants.debug((Object)("after attr size=" + aOverInfo.getAttributeOverrideInfo().toString()));
                AnnotationConstants.debug((Object)("after anno size=" + annoOverrideInfo.size()));
            }
        }
    }

    private void dumpMapping(Hashtable hash) {
        if (hash != null) {
            AnnotationConstants.debug((Object)("in Leho:return hash size=" + hash.size()));
            Enumeration aKeys = hash.keys();
            while (aKeys != null && aKeys.hasMoreElements()) {
                String myKey = (String)aKeys.nextElement();
                String attrName = (String)hash.get(myKey);
                AnnotationConstants.debug((Object)("in Leho:annotation=" + myKey));
                AnnotationConstants.debug((Object)("in Leho:attribute:" + attrName));
            }
        }
    }

    public void dumpOverrideInfo(String string1, int indent) {
        Hashtable table = this.getProjectOverrideInfo();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        String prefix = sb.toString();
        if (table != null) {
            Enumeration projects = table.keys();
            while (projects != null && projects.hasMoreElements()) {
                String projectName = (String)projects.nextElement();
                AnnotationConstants.debug((Object)(prefix + "project=" + projectName));
                Hashtable classLists = (Hashtable)table.get(projectName);
                if (classLists == null) continue;
                Enumeration classes = classLists.keys();
                while (classes != null && classes.hasMoreElements()) {
                    String classname = (String)classes.nextElement();
                    AnnotationConstants.debug((Object)(prefix + "class name:" + classname));
                    Hashtable annotationLists = (Hashtable)classLists.get(classname);
                    if (annotationLists == null) continue;
                    Enumeration annos = annotationLists.keys();
                    while (annos != null && annos.hasMoreElements()) {
                        List attrInfo;
                        String annoName = (String)annos.nextElement();
                        AnnotationConstants.debug((Object)(prefix + "anno name:" + annoName));
                        AnnotationOverrideInfo aInfo = (AnnotationOverrideInfo)annotationLists.get(annoName);
                        if (aInfo == null || (attrInfo = aInfo.getAttributeOverrideInfo()) == null) continue;
                        AnnotationConstants.debug((Object)(prefix + "attribute size=" + attrInfo.size()));
                        for (int k = 0; k < attrInfo.size(); ++k) {
                            AttributeOverrideInfo attrO = (AttributeOverrideInfo)attrInfo.get(k);
                            AnnotationConstants.debug((Object)(prefix + " attributeName=" + attrO.getName()));
                            AnnotationConstants.debug((Object)(prefix + "    override value=" + String.valueOf(attrO.getValue())));
                            AnnotationConstants.debug((Object)(prefix + "    annotation value=" + String.valueOf(attrO.getAnnotationValue())));
                            AnnotationConstants.debug((Object)(prefix + "    isImplied=" + attrO.isImplied()));
                            AnnotationConstants.debug((Object)(prefix + "    isDeclared=" + attrO.isDeclared()));
                        }
                    }
                }
            }
        }
    }

    public void dumpMModel(EObject model, int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        String prefix = sb.toString();
        EClass mClass = model.eClass();
        System.out.print(prefix + mClass.getName() + "{");
        EList attributes = mClass.getEAllAttributes();
        for (Object attr : attributes) {
            System.out.print(prefix + attr.getName() + "=" + String.valueOf(model.eGet((EStructuralFeature)attr)) + ", ");
        }
        System.out.println("}");
        EList adapters = model.eAdapters();
        for (Adapter ad : adapters) {
            System.out.println(prefix + "    adapted by " + String.valueOf(ad));
        }
        EList contents = model.eContents();
        for (EObject o : contents) {
            this.dumpMModel(o, indent + 2);
        }
    }

    public Hashtable getProjectOverrideInfo() {
        return ProjectOverrideInfo;
    }

    public Hashtable getClassOverrideInfo(String classPathName) {
        return ProjectOverrideInfo.get(classPathName);
    }
}

