/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;

public class X400Address
implements GeneralNameInterface {
    byte[] nameValue = null;

    public X400Address(byte[] value) {
        this.nameValue = value;
    }

    public X400Address(DerValue derValue) throws IOException {
        this.nameValue = derValue.toByteArray();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerValue derValue = new DerValue(this.nameValue);
        out.putDerValue(derValue);
    }

    public String toString() {
        return "X400Address: <DER-encoded value>";
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 3) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and match are not supported for X400Address.");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth not supported for X400Address");
    }
}

