/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs1;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public final class PKCS1 {
    private String version = "1.5";
    private String provider = null;
    private String signature = "SHAwithRSA";
    private String encryption = "RSA";
    private String mgf = "MGF1";
    public static final String PKCS1_VERSION_1_5 = "1.5";
    public static final String PKCS1_VERSION2 = "2.0";
    static final String RSA_ALGORITHM = "RSA";
    static final String MESSAGE_DIGEST_MD2 = "MD2";
    static final String MESSAGE_DIGEST_MD5 = "MD5";
    static final String MESSAGE_DIGEST_SHA = "SHA";
    static final String MESSAGE_DIGEST_SHA1 = "SHA1";
    static final String MESSAGE_DIGEST_SHA_1 = "SHA-1";
    static final String SIGNATURE_SHA_RSA = "SHAwithRSA";
    static final String SIGNATURE_MD2_RSA = "MD2withRSA";
    static final String SIGNATURE_MD5_RSA = "MD5withRSA";
    static final String MGF_MGF1 = "MGF1";
    static final String MGF_NULL = "NO_MGF";
    static final int MD2_RESULT_LENGTH = 16;
    static final int MD5_RESULT_LENGTH = 16;
    static final int SHA_RESULT_LENGTH = 20;
    private static final BigInteger BIG_INT_ZERO = BigInteger.ZERO;
    private static final String[] OaepHashAlgorithms = new String[]{"SHA", "SHA1", "SHA-1"};
    private static final String[] version1_5SignAlgorithms = new String[]{"SHA", "SHA1", "SHA-1", "MD2", "MD5"};
    private static final String[] mgfAlgorithms = new String[]{"MGF1"};
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs1.PKCS1";

    public PKCS1(String version, String encryptionAlg, String digestAlg, String mgf, String provider) {
        this(version, encryptionAlg, digestAlg, mgf);
        if (debug != null) {
            Object[] parms = new Object[]{version, encryptionAlg, digestAlg, mgf, provider};
            debug.entry(16384L, (Object)className, "PKCS1", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS1");
        }
    }

    public PKCS1(String version, String encryptionAlg, String digestAlg, String mgf) {
        if (debug != null) {
            Object[] parms = new Object[]{version, encryptionAlg, digestAlg, mgf};
            debug.entry(16384L, (Object)className, "PKCS1", parms);
        }
        try {
            if (version != null) {
                this.setVersion(version);
            }
            if (encryptionAlg != null) {
                this.setEncryptionAlgorithm(encryptionAlg);
            }
            if (mgf != null) {
                this.setMGF(mgf);
            }
        }
        catch (IllegalArgumentException e2) {
            // empty catch block
        }
        if (digestAlg != null) {
            this.setSignatureHashAlgorithm(digestAlg);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS1");
        }
    }

    public String getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public String getEncryptionAlgorithmString() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionAlgorithmString");
            debug.exit(16384L, (Object)className, "getEncryptionAlgorithmString", this.encryption);
        }
        return this.encryption;
    }

    public String getSignatureHashAlgorithmString() {
        String result = null;
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureHashAlgorithmString");
        }
        result = SIGNATURE_MD2_RSA.equals(this.signature) ? new String(MESSAGE_DIGEST_MD2) : (SIGNATURE_MD5_RSA.equals(this.signature) ? new String(MESSAGE_DIGEST_MD5) : new String(MESSAGE_DIGEST_SHA));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureHashAlgorithmString", result);
        }
        return result;
    }

    public String getSignatureAlgorithmString() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithmString");
            debug.exit(16384L, (Object)className, "getSignatureAlgorithmString", this.signature);
        }
        return this.signature;
    }

    public String getMGF() {
        if (debug != null) {
            debug.entry(16384L, className, "getMGF");
        }
        if (PKCS1_VERSION2.equalsIgnoreCase(this.version)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMGF", this.mgf);
            }
            return this.mgf;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMGF", null);
        }
        return null;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] message) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", publicKey, message);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Public Key must be specified");
            }
            throw new IllegalArgumentException("Public Key must be specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Message must be specified");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        Cipher cipher = null;
        if (publicKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Invalid key: RSA public key algorithm expected");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Invalid key: RSA public key expected");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance(this.encryption, this.provider) : Cipher.getInstance(this.encryption);
        }
        catch (Exception nspe) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", nspe);
            }
            throw new PKCSException(nspe, "Error : (" + nspe.toString() + ")");
        }
        try {
            cipher.init(1, publicKey);
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e2);
            }
            throw new PKCSException(e2, "Invalid key: RSA public key expected");
        }
        byte[] ciphertext = null;
        try {
            ciphertext = cipher.doFinal(message);
        }
        catch (BadPaddingException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e3);
            }
            throw new PKCSException(e3, "Error : (" + e3.toString() + ")");
        }
        catch (IllegalBlockSizeException e4) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e4);
            }
            throw new PKCSException(e4, "Error : (" + e4.toString() + ")");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encrypt", (Object)ciphertext);
        }
        return ciphertext;
    }

    public byte[] encrypt(Certificate cert, byte[] message) throws PKCSException, NoSuchAlgorithmException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", cert, message);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Certificate must be specified");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Certificate type " + cert.getClass().getName() + " not supported. Only instances of java.security.cert.X509Certificate are supported");
            }
            throw new IllegalArgumentException("Certificate type " + cert.getClass().getName() + "not supported.  Only instances of " + "java.security.cert.X509Certificate are supported.");
        }
        try {
            ((X509Certificate)cert).checkValidity();
        }
        catch (CertificateExpiredException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e2);
            }
            throw new PKCSException(e2, "Certificate has expired.");
        }
        catch (CertificateNotYetValidException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e3);
            }
            throw new PKCSException(e3, "Certificate is not yet valid.");
        }
        result = this.encrypt(cert.getPublicKey(), message);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encrypt", result);
        }
        return result;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] ciphertext) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "decrypt", privateKey, ciphertext);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Private Key must be specified");
            }
            throw new IllegalArgumentException("Private Key must be specified.");
        }
        if (ciphertext == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Cipher text must be specified");
            }
            throw new IllegalArgumentException("Cipher text must be specified.");
        }
        Cipher cipher = null;
        if (privateKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Invalid key: RSA algorithm expected");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof RSAPrivateCrtKey)) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Invalid key: RSA private key expected");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance(this.encryption, this.provider) : Cipher.getInstance(this.encryption);
        }
        catch (Exception nspe) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", nspe);
            }
            throw new PKCSException(nspe, "Error : (" + nspe.toString() + ")");
        }
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e2);
            }
            throw new PKCSException(e2, "Invalid key: RSA private key expected");
        }
        byte[] message = null;
        try {
            message = cipher.doFinal(ciphertext);
        }
        catch (BadPaddingException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e3);
            }
            throw new PKCSException(e3, "Error : (" + e3.toString() + ")");
        }
        catch (IllegalBlockSizeException e4) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e4);
            }
            throw new PKCSException(e4, "Error : (" + e4.toString() + ")");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", message);
        }
        return message;
    }

    public byte[] sign(PrivateKey privateKey, byte[] message) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", privateKey, message);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Private Key must be specified.");
            }
            throw new IllegalArgumentException("Private Key must be specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (message.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message length is 0.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (privateKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Invalid key: RSA Algorithm expected.");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof RSAPrivateCrtKey)) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Invalid key: RSA private key expecited");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        Signature sig = null;
        try {
            sig = this.provider != null ? Signature.getInstance(this.signature, this.provider) : Signature.getInstance(this.signature);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", e2);
            }
            throw new PKCSException(e2, "Error : (" + e2.toString() + ")");
        }
        try {
            sig.initSign(privateKey);
        }
        catch (InvalidKeyException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", e3);
            }
            throw new PKCSException(e3, "Invalid key: RSA private key expected");
        }
        byte[] signature = null;
        try {
            sig.update(message);
            signature = sig.sign();
        }
        catch (SignatureException e4) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", e4);
            }
            throw new PKCSException(e4, "Error : (" + e4.toString() + ")");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", signature);
        }
        return signature;
    }

    public boolean verify(PublicKey publicKey, byte[] message, byte[] signature) throws PKCSException, NoSuchAlgorithmException {
        boolean result = false;
        if (debug != null) {
            Object[] parms = new Object[]{publicKey, message, signature};
            debug.entry(16384L, (Object)className, "verify", parms);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Public Key must be specified");
            }
            throw new IllegalArgumentException("Public Key must be specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Message must be specified");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (message.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Message length cannot be 0");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature must be specified");
            }
            throw new IllegalArgumentException("Signature must be specified.");
        }
        if (signature.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature length cannot be 0");
            }
            throw new IllegalArgumentException("Signature must be specified.");
        }
        if (publicKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Invalid key: Public Key Algorithm must be RSA");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Invalid key: RSA public key expected");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        Signature sig = null;
        try {
            sig = this.provider != null ? Signature.getInstance(this.signature, this.provider) : Signature.getInstance(this.signature);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e2);
            }
            throw new PKCSException(e2, "Error : (" + e2.toString() + ")");
        }
        try {
            sig.initVerify(publicKey);
        }
        catch (InvalidKeyException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e3);
            }
            throw new PKCSException(e3, "Invalid key: RSA public key expected");
        }
        try {
            sig.update(message);
            result = sig.verify(signature);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", result);
            }
            return result;
        }
        catch (SignatureException e4) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e4);
            }
            throw new PKCSException(e4, "Error : (" + e4.toString() + ")");
        }
    }

    public boolean verify(Certificate cert, byte[] message, byte[] signature) throws PKCSException, NoSuchAlgorithmException {
        boolean result = false;
        if (debug != null) {
            Object[] parms = new Object[]{cert, message, signature};
            debug.entry(16384L, (Object)className, "verify", parms);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate must be specified");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate type " + cert.getClass().getName() + " not supported. Only instances of java.security.cert.X509Certificate are supported");
            }
            throw new IllegalArgumentException("Certificate type " + cert.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
        }
        try {
            ((X509Certificate)cert).checkValidity();
        }
        catch (CertificateExpiredException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e2);
            }
            throw new PKCSException(e2, "Certificate has expired.");
        }
        catch (CertificateNotYetValidException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e3);
            }
            throw new PKCSException(e3, "Certificate is not yet valid.");
        }
        result = this.verify(cert.getPublicKey(), message, signature);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", result);
        }
        return result;
    }

    public String toString() {
        return "PKCS1: version: " + this.getVersion() + "\r\n\tencryption algorithm: " + this.getEncryptionAlgorithmString() + "\r\n\tsignature algorithm: " + this.getSignatureAlgorithmString();
    }

    private static boolean inSet(String checkString, String[] arrayString) {
        boolean result = false;
        if (debug != null) {
            debug.entry(8192L, className, "inSet", checkString, arrayString);
        }
        if (arrayString != null && checkString != null && arrayString.length > 0) {
            for (int i2 = 0; i2 < arrayString.length; ++i2) {
                if (!checkString.equalsIgnoreCase(arrayString[i2])) continue;
                result = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "inSet", result);
        }
        return result;
    }

    private void setVersion(String version) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setVersion", version);
        }
        if (version.equalsIgnoreCase(PKCS1_VERSION_1_5)) {
            this.version = PKCS1_VERSION_1_5;
            if (debug != null) {
                debug.exit(8192L, className, "setVersion");
            }
            return;
        }
        if (debug != null) {
            debug.text(8192L, className, "setVersion", "PKCS #1 version " + version + " not supported");
        }
        throw new IllegalArgumentException("PKCS #1 version " + version + " not supported.");
    }

    private void setEncryptionAlgorithm(String encryptionAlg) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptionAlgorithm", encryptionAlg);
        }
        if (PKCS1_VERSION2.equalsIgnoreCase(this.version)) {
            if (!PKCS1.inSet(encryptionAlg, OaepHashAlgorithms)) {
                if (debug != null) {
                    debug.text(8192L, className, "setEncryptionAlgorithm", "Encryption algorithm " + encryptionAlg + " not supported in version 2.0");
                }
                throw new IllegalArgumentException("Encryption algorithm " + encryptionAlg + " not supported in version 2.0");
            }
            this.encryption = encryptionAlg.toUpperCase(Locale.US);
        } else if (!encryptionAlg.equalsIgnoreCase(RSA_ALGORITHM)) {
            if (debug != null) {
                debug.text(8192L, className, "setEncryptionAlgorithm", "Encryption algorithm " + encryptionAlg + " not supported in version 1.5");
            }
            throw new IllegalArgumentException("Encryption algorithm " + encryptionAlg + " not supported in version 1.5.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptionAlgorithm");
        }
    }

    private void setSignatureHashAlgorithm(String digestAlg) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureHashAlgorithm", digestAlg);
        }
        if (!PKCS1.inSet(digestAlg, version1_5SignAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setSignatureHashAlgorithm", "Digest algorithm " + digestAlg + " not supported");
            }
            throw new IllegalArgumentException("Digest algorithm " + digestAlg + " not supported.");
        }
        if (digestAlg.equalsIgnoreCase(MESSAGE_DIGEST_SHA) || digestAlg.equalsIgnoreCase(MESSAGE_DIGEST_SHA1) || digestAlg.equalsIgnoreCase(MESSAGE_DIGEST_SHA_1)) {
            this.signature = SIGNATURE_SHA_RSA;
            if (debug != null) {
                debug.exit(8192L, className, "setSignatureHashAlgorithm");
            }
            return;
        }
        if (digestAlg.equalsIgnoreCase(MESSAGE_DIGEST_MD2)) {
            this.signature = SIGNATURE_MD2_RSA;
            if (debug != null) {
                debug.exit(8192L, className, "setSignatureHashAlgorithm");
            }
            return;
        }
        this.signature = SIGNATURE_MD5_RSA;
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureHashAlgorithm");
        }
    }

    private void setMGF(String mgf) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setMGF", mgf);
        }
        if (PKCS1_VERSION2.equalsIgnoreCase(this.version)) {
            if (!PKCS1.inSet(mgf, mgfAlgorithms)) {
                if (debug != null) {
                    debug.text(8192L, className, "setMGF", "MGF algorithm " + mgf + " not supported");
                }
                throw new IllegalArgumentException("MGF algorithm " + mgf + " not supported.");
            }
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setMGF", "MGF algorithm " + mgf + " not supported in PKCS#1 version " + this.version);
            }
            throw new IllegalArgumentException("MGF algorithm  not supported in PKCS#1 version " + this.version);
        }
        this.mgf = mgf.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setMGF");
        }
    }
}

