/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider.icc;

import com.ibm.crypto.plus.provider.Poly1305Constants;
import com.ibm.crypto.plus.provider.icc.ByteArrayOutputDelay;
import com.ibm.crypto.plus.provider.icc.ICCContext;
import com.ibm.crypto.plus.provider.icc.ICCException;
import com.ibm.crypto.plus.provider.icc.NativeInterface;
import com.ibm.crypto.plus.provider.icc.Padding;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public final class Poly1305Cipher
implements Poly1305Constants {
    private ICCContext a;
    private long b;
    private boolean c = false;
    private boolean d = true;
    private Padding e = null;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    private int i = 0;
    private boolean j = false;
    private byte[] k = null;
    private byte[] l = null;
    private ByteArrayOutputDelay m = null;
    private static final String n;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Poly1305Cipher getInstance(ICCContext iCCContext, String string, Padding padding) throws ICCException {
        if (iCCContext == null) {
            throw new IllegalArgumentException(z[23]);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(z[21]);
        }
        if (padding == null) {
            throw new IllegalArgumentException(z[22]);
        }
        return new Poly1305Cipher(iCCContext, string, padding);
    }

    private Poly1305Cipher(ICCContext iCCContext, String string, Padding padding) throws ICCException {
        this.a = iCCContext;
        this.b = NativeInterface.POLY1305CIPHER_create(iCCContext.getId(), string);
        this.e = padding;
    }

    public synchronized void initCipherEncrypt(byte[] byArray, byte[] byArray2) throws ICCException {
        this.a(true, byArray, byArray2);
    }

    public synchronized void initCipherDecrypt(byte[] byArray, byte[] byArray2) throws ICCException {
        this.a(false, byArray, byArray2);
        this.m = new ByteArrayOutputDelay(16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, byte[] byArray, byte[] byArray2) throws ICCException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException(z[2]);
        }
        if (byArray.length < this.getKeyLength()) {
            throw new IllegalArgumentException(z[3]);
        }
        if (byArray2 != null && byArray2.length < this.getIVLength()) {
            throw new IllegalArgumentException(z[5]);
        }
        if (this.b == 0L) {
            throw new ICCException(z[4]);
        }
        NativeInterface.POLY1305CIPHER_init(this.a.getId(), this.b, bl ? 1 : 0, byArray, byArray2);
        NativeInterface.POLY1305CIPHER_setPadding(this.a.getId(), this.b, this.e.getId());
        this.d = bl;
        this.f = 0;
        this.j = false;
        if (byArray != this.k) {
            if (this.k != null) {
                Arrays.fill(this.k, (byte)0);
            }
            this.k = (byte[])byArray.clone();
        }
        if (byArray2 != this.l) {
            this.l = byArray2 == null ? null : (byte[])byArray2.clone();
        }
        this.c = true;
    }

    public synchronized int getOutputSize(int n2, boolean bl, int n3) {
        if (n2 < 0) {
            return 0;
        }
        int n4 = this.f + n2;
        if (bl) {
            return n4 + n3;
        }
        int n5 = n4 < n3 ? 0 : n4 - n3;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getBlockSize() throws ICCException {
        if (this.g == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[0]);
            }
            this.g = NativeInterface.POLY1305CIPHER_getBlockSize(this.a.getId(), this.b);
        }
        return this.g;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getKeyLength() throws ICCException {
        if (this.h == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[1]);
            }
            this.h = NativeInterface.POLY1305CIPHER_getKeyLength(this.a.getId(), this.b);
        }
        return this.h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getIVLength() throws ICCException {
        if (this.i == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[24]);
            }
            this.i = NativeInterface.POLY1305CIPHER_getIVLength(this.a.getId(), this.b);
        }
        return this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, ICCException {
        int n5;
        block38: {
            n5 = 0;
            if (!this.c) {
                throw new IllegalStateException(z[20]);
            }
            if (this.j) {
                this.a(this.d, this.k, this.l);
                this.j = false;
            }
            if (n3 == 0) {
                return n5;
            }
            if (byArray == null || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length) {
                throw new IllegalArgumentException(z[18]);
            }
            if (byArray2 != null && (n4 < 0 || n4 > byArray2.length)) {
                throw new IllegalArgumentException(z[16]);
            }
            int n6 = n3;
            if (!this.d) {
                n6 -= this.m.getByteDelay();
            }
            if (byArray2 != null && byArray2.length != 0 && byArray2.length - n4 < n6) {
                throw new ShortBufferException(z[17] + n6 + z[19]);
            }
            byte[] byArray3 = null;
            if (byArray == byArray2 && (n2 == n4 || n2 < n4 && n4 < (n2 = n3) || n2 > n4 && n2 < n4 + n6)) {
                byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
                byArray = byArray3;
                n2 = 0;
            }
            try {
                if (this.b == 0L) {
                    throw new ICCException(z[15]);
                }
                if (this.d) {
                    n5 = NativeInterface.POLY1305CIPHER_encryptUpdate(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4);
                    break block38;
                }
                if (null != byArray2) {
                    byte[] byArray4 = this.a(byArray, n2, n3);
                    n5 = NativeInterface.POLY1305CIPHER_decryptUpdate(this.a.getId(), this.b, byArray4, 0, byArray4.length, byArray2, n4);
                } else {
                    n5 = NativeInterface.POLY1305CIPHER_decryptUpdate(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4);
                }
            }
            finally {
                if (byArray3 != null && this.d) {
                    Arrays.fill(byArray3, (byte)0);
                }
            }
        }
        this.f += n3 - n5;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, ICCException {
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = null;
        int n5 = 0;
        int n6 = 0;
        if (!this.c) {
            throw new IllegalStateException(z[11]);
        }
        if (this.j) {
            this.a(this.d, this.k, this.l);
            this.j = false;
        }
        if (n3 != 0 && (byArray == null || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length)) {
            throw new IllegalArgumentException(z[12]);
        }
        if (!this.d) {
            byArray = this.b(byArray, n2, n3);
            n2 = 0;
            n3 = byArray.length;
            if (byArray3 == null && (byArray == null || n3 < 16)) {
                throw new IllegalArgumentException(z[14]);
            }
            if (n3 > 16) {
                n5 = n3 - 16;
                byArray4 = new byte[n5];
            }
        }
        if (this.d && (byArray2 == null || n4 < 0 || n4 > byArray2.length)) {
            throw new IllegalArgumentException(z[13]);
        }
        if ((!this.d || this.e.isPadding(0)) && (n3 + this.f) % this.getBlockSize() != 0) {
            throw new IllegalBlockSizeException(z[6]);
        }
        int n7 = this.getOutputSize(n3, this.d, 16);
        if (!this.d) {
            n7 -= 16;
        }
        if (byArray2.length - n4 < n7) {
            throw new ShortBufferException(z[9] + n7 + z[10]);
        }
        byte[] byArray5 = null;
        if (byArray == byArray2 && (n2 == n4 || n2 < n4 && n4 < (n2 = n3) || n2 > n4 && n2 < n4 + n7)) {
            byArray5 = new byte[n3];
            System.arraycopy(byArray, n2, byArray5, 0, n3);
            byArray = byArray5;
            n2 = 0;
        }
        try {
            if (this.b == 0L) {
                throw new ICCException(z[7]);
            }
            if (this.d) {
                n6 = NativeInterface.POLY1305CIPHER_encryptFinal(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n6 + n4, 16);
                n6 += 16;
            } else {
                System.arraycopy(byArray, n3 - 16, byArray3, 0, 16);
                if (byArray4 != null) {
                    System.arraycopy(byArray, 0, byArray4, 0, n5);
                }
                n6 = NativeInterface.POLY1305CIPHER_decryptFinal(this.a.getId(), this.b, byArray4, n2, n5, byArray2, n4, byArray3);
            }
        }
        catch (ICCException iCCException) {
            if (iCCException.getCode() == 3) {
                throw new BadPaddingException(z[8]);
            }
            throw iCCException;
        }
        finally {
            if (byArray5 != null && this.d) {
                Arrays.fill(byArray5, (byte)0);
            }
        }
        this.f = 0;
        this.j = true;
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void finalize() throws Throwable {
        try {
            if (this.b == 0L) return;
            NativeInterface.POLY1305CIPHER_delete(this.a.getId(), this.b);
            this.b = 0L;
            return;
        }
        finally {
            if (this.k != null) {
                Arrays.fill(this.k, (byte)0);
                this.k = null;
            }
            super.finalize();
        }
    }

    protected static boolean a(long l2) {
        boolean bl = l2 != 0L;
        return bl;
    }

    protected byte[] a(byte[] byArray, int n2, int n3) {
        return this.m.write(byArray, n2, n3);
    }

    protected byte[] b(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.m.flush();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + n3);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        if (null != byArray) {
            byteArrayOutputStream.write(byArray, n2, n3);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
        int n3 = 24;
        block33: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                block36: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block36;
                    n5 = n5;
                    if (n5 <= n4) break block37;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 22;
                            break;
                        }
                        case 1: {
                            n6 = 84;
                            break;
                        }
                        case 2: {
                            n6 = 116;
                            break;
                        }
                        case 3: {
                            n6 = 88;
                            break;
                        }
                        default: {
                            n6 = 51;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                case 24: {
                    n = string.intern();
                    string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
                    n3 = -1;
                    continue block33;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
                    n3 = 0;
                    continue block33;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "}1\rxZet\u001a-_z{\u00115Cb-";
                    n3 = 1;
                    continue block33;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "}1\rxZet\u00000V6#\u00067]qt\u00071Is";
                    n3 = 2;
                    continue block33;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
                    n3 = 3;
                    continue block33;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "_\u0002T1@6 \u001c=\u0013a&\u001b6T6'\u001d\"V";
                    n3 = 4;
                    continue block33;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "[1\u0007+Rq1T5Fe T:V65T5Fz \u001d(_st\u001b>\u0013b<\u0011xQz;\u00173\u0013e=\u000e=\u0013a=\u00000\\c T(Rr0\u001d6T";
                    n3 = 5;
                    continue block33;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
                    n3 = 6;
                    continue block33;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "C:\u0011 Cs7\u0000=W6$\u0015<W\u007f:\u0013";
                    n3 = 7;
                    continue block33;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Y!\u0000(Fbt\u0016-Up1\u0006x^c'\u0000xQst\\9G68\u00119@b}T";
                    n3 = 8;
                    continue block33;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "66\r,Vet\u00187]q";
                    n3 = 9;
                    continue block33;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "U=\u00040Vdt\u001a7G6=\u001a1G\u007f5\u00181Is0";
                    n3 = 10;
                    continue block33;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "_:\u0004-G6&\u00156Tst\u001d+\u0013\u007f:\u00029_\u007f0";
                    n3 = 11;
                    continue block33;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "Y!\u0000(Fbt\u00069]q1T1@6=\u001a.Rz=\u0010";
                    n3 = 12;
                    continue block33;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "[=\u0007+Zx3T,Rqt\u001b6\u0013r1\u0017*Jf T>Zx5\u0018";
                    n3 = 13;
                    continue block33;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
                    n3 = 14;
                    continue block33;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "Y!\u0000(Fbt\u00069]q1T1@6=\u001a.Rz=\u0010";
                    n3 = 15;
                    continue block33;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "Y!\u0000(Fbt\u0016-Up1\u0006x^c'\u0000xQst\\9G68\u00119@b}T";
                    n3 = 16;
                    continue block33;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "_:\u0004-G6&\u00156Tst\u001d+\u0013\u007f:\u00029_\u007f0";
                    n3 = 17;
                    continue block33;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "66\r,Vet\u00187]q";
                    n3 = 18;
                    continue block33;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "U=\u00040Vdt\u001a7G6=\u001a1G\u007f5\u00181Is0";
                    n3 = 19;
                    continue block33;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "u=\u00040Vd\u001a\u00155V6=\u0007x]c8\u0018wV{$\u0000!";
                    n3 = 20;
                    continue block33;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "f5\u0010<Zx3T1@6:\u00014_";
                    n3 = 21;
                    continue block33;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "u;\u001a,Vn T1@6:\u00014_";
                    n3 = 22;
                    continue block33;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "U=\u00040Vdt=<Vx \u001d>Zs&T1@6:\u001b,\u0013`5\u00181W";
                    n3 = 23;
                    continue block33;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

