/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMReferenceType;
import com.ibm.xml.enc.dom.DOMUtils;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.enc.KeyReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMKeyReference
extends DOMReferenceType
implements KeyReference {
    private Node here;

    public DOMKeyReference(String uri, List content) {
        super(uri, content);
    }

    public DOMKeyReference(Element refElem) throws MarshalException {
        super(refElem);
    }

    @Override
    public Node getHere() {
        return this.here;
    }

    @Override
    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element refElem = DOMUtils.createElement(ownerDoc, "KeyReference", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        DOMUtils.setAttribute(refElem, "URI", this.uri);
        if (!this.content.isEmpty()) {
            for (DOMStructure domObject : this.content) {
                DOMUtils.appendChild(refElem, domObject.getNode());
            }
        }
        this.here = refElem.getAttributeNodeNS(null, "URI");
        parent.appendChild(refElem);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyReference)) {
            return false;
        }
        KeyReference oref = (KeyReference)o;
        boolean urisEqual = this.uri.equals(oref.getURI());
        return urisEqual;
    }
}

