/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.SignatureEngineDSA;
import com.ibm.xml.crypto.dsig.SignatureEngineECDSA;
import com.ibm.xml.crypto.dsig.SignatureEngineHMAC;
import com.ibm.xml.crypto.dsig.SignatureEngineRSA;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.gss.SignatureEngineGSSMIC;
import com.ibm.xml.crypto.spi.EncryptionEngine;
import com.ibm.xml.crypto.spi.EngineFactory;
import com.ibm.xml.crypto.spi.KeyGenerationEngine;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AlgorithmFactory
implements Constants,
EngineFactory {
    static final boolean ENABLE_CACHE = true;
    protected Provider digestProvider = null;
    protected Provider signatureProvider = null;
    protected Provider macProvider = null;
    protected String certProvider = null;
    protected String keyProvider = null;
    protected Set supportedSignatures = new HashSet();
    protected Set<String> supportedDigests = new HashSet<String>();
    protected Set supportedDataEncryptions = new HashSet();
    protected Set supportedKeyEncryptions = new HashSet();
    private CertificateFactory certFactory = null;
    private KeyFactory dsaFactory = null;
    private KeyFactory rsaFactory = null;
    private KeyFactory ecFactory = null;
    private DocumentBuilderFactory builderFactory = null;
    private Stack builderCache;
    private Stack shaCache = new Stack();
    private Stack sha256Cache = new Stack();
    private Stack sha384Cache = new Stack();
    private Stack sha512Cache = new Stack();
    private Stack dsasha1Cache = new Stack();
    private Stack dsasha256Cache = new Stack();
    private Stack rsasha1Cache;
    private Stack rsasha256Cache;
    private Stack rsasha384Cache;
    private Stack rsasha512Cache;
    private Stack ecdsasha1Cache = new Stack();
    private Stack ecdsasha256Cache = new Stack();
    private Stack ecdsasha384Cache = new Stack();
    private Stack ecdsasha512Cache = new Stack();
    private Stack hmacsha1Cache;
    private Stack hmacsha256Cache;
    private Stack hmacsha384Cache;
    private Stack hmacsha512Cache;
    private Stack gssmicCache;
    private static AlgorithmFactory s_instance = null;
    private static final int UC_URIC = 1;
    private static final int UC_ALPHANUM = 2;
    private static final int UC_ALPHA = 4;
    private static final int UC_RESERVED = 8;
    private static final int UC_MARK = 16;
    private static final int UC_HEX = 32;
    private static final int[] URI_CHAR = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 0, 8, 16, 16, 16, 16, 8, 8, 16, 16, 8, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 8, 8, 0, 8, 0, 8, 8, 38, 38, 38, 38, 38, 38, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 16, 0, 38, 38, 38, 38, 38, 38, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 16, 0};

    public static synchronized AlgorithmFactory getInstance() {
        if (s_instance == null) {
            s_instance = new AlgorithmFactory();
        }
        return s_instance;
    }

    protected AlgorithmFactory() {
        this.rsasha1Cache = new Stack();
        this.rsasha256Cache = new Stack();
        this.rsasha384Cache = new Stack();
        this.rsasha512Cache = new Stack();
        this.hmacsha1Cache = new Stack();
        this.hmacsha256Cache = new Stack();
        this.hmacsha384Cache = new Stack();
        this.hmacsha512Cache = new Stack();
        this.gssmicCache = new Stack();
        this.builderCache = new Stack();
        this.supportedSignatures.add("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        this.supportedSignatures.add("http://www.w3.org/2009/xmldsig11#dsa-sha256");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
        this.supportedSignatures.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        this.supportedSignatures.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384");
        this.supportedSignatures.add("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        this.supportedSignatures.add("http://schemas.xmlsoap.org/ws/2003/12/IETF-RFC2743#GSS_MIC");
        this.supportedDigests.add("http://www.w3.org/2000/09/xmldsig#sha1");
        this.supportedDigests.add("http://www.w3.org/2001/04/xmlenc#sha256");
        this.supportedDigests.add("http://www.w3.org/2001/04/xmldsig-more#sha384");
        this.supportedDigests.add("http://www.w3.org/2001/04/xmlenc#sha512");
        this.supportedDigests.add("http://www.w3.org/2001/04/xmldsig-more#md5");
    }

    private MessageDigest getDigestInstance(String alg) throws NoSuchAlgorithmException {
        if (this.digestProvider == null) {
            return MessageDigest.getInstance(alg);
        }
        return MessageDigest.getInstance(alg, this.digestProvider);
    }

    @Override
    public Set getDigestAlgorithms() {
        return this.supportedDigests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDigest getMessageDigest(String uri, AlgorithmParameterSpec spec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(uri)) {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("The parameter must be null.");
            }
            Stack stack = this.shaCache;
            synchronized (stack) {
                if (!this.shaCache.isEmpty()) {
                    return (MessageDigest)this.shaCache.pop();
                }
                return this.getDigestInstance("SHA");
            }
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(uri)) {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("The parameter must be null.");
            }
            Stack stack = this.sha256Cache;
            synchronized (stack) {
                if (!this.sha256Cache.isEmpty()) {
                    return (MessageDigest)this.sha256Cache.pop();
                }
                return this.getDigestInstance("SHA256");
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#sha384".equals(uri)) {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("The parameter must be null.");
            }
            Stack stack = this.sha384Cache;
            synchronized (stack) {
                if (!this.sha384Cache.isEmpty()) {
                    return (MessageDigest)this.sha384Cache.pop();
                }
                return this.getDigestInstance("SHA384");
            }
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(uri)) {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("The parameter must be null.");
            }
            Stack stack = this.sha512Cache;
            synchronized (stack) {
                if (!this.sha512Cache.isEmpty()) {
                    return (MessageDigest)this.sha512Cache.pop();
                }
                return this.getDigestInstance("SHA512");
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#md5".equals(uri)) {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("The parameter must be null.");
            }
            return this.getDigestInstance("MD5");
        }
        throw new NoSuchAlgorithmException("Internal error: " + uri);
    }

    @Override
    public boolean releaseMessageDigest(String alg, MessageDigest d) {
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(alg)) {
            this.shaCache.push(d);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(alg)) {
            this.sha256Cache.push(d);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#sha384".equals(alg)) {
            this.sha384Cache.push(d);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(alg)) {
            this.sha512Cache.push(d);
            return true;
        }
        return "http://www.w3.org/2001/04/xmldsig-more#md5".equals(alg);
    }

    @Override
    public Set getSignatureAlgorithms() {
        return this.supportedSignatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignatureEngine getSignatureEngine(String alg) throws NoSuchAlgorithmException {
        if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(alg)) {
            Stack stack = this.dsasha1Cache;
            synchronized (stack) {
                if (!this.dsasha1Cache.isEmpty()) {
                    return (SignatureEngine)this.dsasha1Cache.pop();
                }
                return new SignatureEngineDSA(alg, this.signatureProvider);
            }
        }
        if ("http://www.w3.org/2009/xmldsig11#dsa-sha256".equals(alg)) {
            Stack stack = this.dsasha256Cache;
            synchronized (stack) {
                if (!this.dsasha256Cache.isEmpty()) {
                    return (SignatureEngine)this.dsasha256Cache.pop();
                }
                return new SignatureEngineDSA(alg, this.signatureProvider);
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(alg)) {
            Stack stack = this.rsasha1Cache;
            synchronized (stack) {
                if (!this.rsasha1Cache.isEmpty()) {
                    return (SignatureEngine)this.rsasha1Cache.pop();
                }
                return new SignatureEngineRSA(alg, this.signatureProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(alg)) {
            Stack stack = this.rsasha256Cache;
            synchronized (stack) {
                if (!this.rsasha256Cache.isEmpty()) {
                    return (SignatureEngine)this.rsasha256Cache.pop();
                }
                return new SignatureEngineRSA(alg, this.signatureProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384".equals(alg)) {
            Stack stack = this.rsasha384Cache;
            synchronized (stack) {
                if (!this.rsasha384Cache.isEmpty()) {
                    return (SignatureEngine)this.rsasha384Cache.pop();
                }
                return new SignatureEngineRSA(alg, this.signatureProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512".equals(alg)) {
            Stack stack = this.rsasha512Cache;
            synchronized (stack) {
                if (!this.rsasha512Cache.isEmpty()) {
                    return (SignatureEngine)this.rsasha512Cache.pop();
                }
                return new SignatureEngineRSA(alg, this.signatureProvider);
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(alg)) {
            Stack stack = this.hmacsha1Cache;
            synchronized (stack) {
                if (!this.hmacsha1Cache.isEmpty()) {
                    return (SignatureEngine)this.hmacsha1Cache.pop();
                }
                return new SignatureEngineHMAC(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256".equals(alg)) {
            Stack stack = this.hmacsha256Cache;
            synchronized (stack) {
                if (!this.hmacsha256Cache.isEmpty()) {
                    return (SignatureEngine)this.hmacsha256Cache.pop();
                }
                return new SignatureEngineHMAC(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384".equals(alg)) {
            Stack stack = this.hmacsha384Cache;
            synchronized (stack) {
                if (!this.hmacsha384Cache.isEmpty()) {
                    return (SignatureEngine)this.hmacsha384Cache.pop();
                }
                return new SignatureEngineHMAC(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512".equals(alg)) {
            Stack stack = this.hmacsha512Cache;
            synchronized (stack) {
                if (!this.hmacsha512Cache.isEmpty()) {
                    return (SignatureEngine)this.hmacsha512Cache.pop();
                }
                return new SignatureEngineHMAC(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1".equals(alg)) {
            Stack stack = this.ecdsasha1Cache;
            synchronized (stack) {
                if (!this.ecdsasha1Cache.isEmpty()) {
                    return (SignatureEngine)this.ecdsasha1Cache.pop();
                }
                return new SignatureEngineECDSA(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256".equals(alg)) {
            Stack stack = this.ecdsasha256Cache;
            synchronized (stack) {
                if (!this.ecdsasha256Cache.isEmpty()) {
                    return (SignatureEngine)this.ecdsasha256Cache.pop();
                }
                return new SignatureEngineECDSA(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384".equals(alg)) {
            Stack stack = this.ecdsasha384Cache;
            synchronized (stack) {
                if (!this.ecdsasha384Cache.isEmpty()) {
                    return (SignatureEngine)this.ecdsasha384Cache.pop();
                }
                return new SignatureEngineECDSA(alg, this.macProvider);
            }
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512".equals(alg)) {
            Stack stack = this.ecdsasha512Cache;
            synchronized (stack) {
                if (!this.ecdsasha512Cache.isEmpty()) {
                    return (SignatureEngine)this.ecdsasha512Cache.pop();
                }
                return new SignatureEngineECDSA(alg, this.macProvider);
            }
        }
        if ("http://schemas.xmlsoap.org/ws/2003/12/IETF-RFC2743#GSS_MIC".equals(alg)) {
            Stack stack = this.gssmicCache;
            synchronized (stack) {
                if (!this.gssmicCache.isEmpty()) {
                    return (SignatureEngine)this.gssmicCache.pop();
                }
                return new SignatureEngineGSSMIC();
            }
        }
        throw new NoSuchAlgorithmException("Internal error: " + alg);
    }

    @Override
    public boolean releaseSignatureEngine(SignatureEngine eng) {
        String alg = eng.getURI();
        if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(alg)) {
            this.dsasha1Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2009/xmldsig11#dsa-sha256".equals(alg)) {
            this.dsasha256Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(alg)) {
            this.rsasha1Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(alg)) {
            this.rsasha256Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384".equals(alg)) {
            this.rsasha384Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512".equals(alg)) {
            this.rsasha512Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1".equals(alg)) {
            this.ecdsasha1Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256".equals(alg)) {
            this.ecdsasha256Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384".equals(alg)) {
            this.ecdsasha384Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512".equals(alg)) {
            this.ecdsasha512Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(alg)) {
            this.hmacsha1Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256".equals(alg)) {
            this.hmacsha256Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384".equals(alg)) {
            this.hmacsha384Cache.push(eng);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512".equals(alg)) {
            this.hmacsha512Cache.push(eng);
            return true;
        }
        return false;
    }

    @Override
    public Set getDataEncryptionAlgorithms() {
        return this.supportedDataEncryptions;
    }

    @Override
    public EncryptionEngine getEncryptionEngine(String uri) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException(uri);
    }

    @Override
    public boolean releaseEncryptionEngine(EncryptionEngine eng) {
        return false;
    }

    @Override
    public Set getKeyEncryptionAlgorithms() {
        return this.supportedKeyEncryptions;
    }

    @Override
    public KeyGenerationEngine getKeyGenerationEngine(String uri, String type) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException(uri);
    }

    @Override
    public boolean releaseKeyGenerationEngine(KeyGenerationEngine eng) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AlgorithmParameterSpec unmarshalParameter(String uri, Element el) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            Node param = null;
            Node child = DOMUtil.getFirstChild2(el);
            while (child != null) {
                if (!Unmarshalling.isIgnorableNode2(child)) {
                    if (child.getNodeType() != 1) throw new InvalidAlgorithmParameterException("HMAC-SHA1 does not suport specified parameter element: " + child.getNodeName());
                    if (param != null) throw new InvalidAlgorithmParameterException("HMAC-SHA1 does not suport specified parameter parameter element: " + child.getNodeName());
                    param = child;
                }
                child = DOMUtil.getNextSibling2(child);
            }
            HMACParameterSpec spec = null;
            if (param == null) return spec;
            if (!"http://www.w3.org/2000/09/xmldsig#".equals(param.getNamespaceURI())) throw new InvalidAlgorithmParameterException("The parameter must be {http://www.w3.org/2000/09/xmldsig#, HMACOutputLength}: " + param.getNodeName());
            if (!"HMACOutputLength".equals(param.getLocalName())) {
                throw new InvalidAlgorithmParameterException("The parameter must be {http://www.w3.org/2000/09/xmldsig#, HMACOutputLength}: " + param.getNodeName());
            }
            try {
                int value = Integer.parseInt(Unmarshalling.getStringValue(param));
                return new HMACParameterSpec(value);
            }
            catch (MarshalException me) {
                throw new InvalidAlgorithmParameterException(me.getMessage());
            }
            catch (NumberFormatException nfe) {
                throw new InvalidAlgorithmParameterException(nfe.getMessage());
            }
        }
        if (this.supportedSignatures.contains(uri)) return null;
        if (!this.supportedDigests.contains(uri)) throw new NoSuchAlgorithmException(uri);
        return null;
    }

    @Override
    public AlgorithmParameterSpec convertParameter(String uri, Map properties) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return null;
    }

    @Override
    public void marshalParameter(String uri, AlgorithmParameterSpec spec, Element el) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.marshalParameter(uri, spec, el, null);
    }

    void marshalParameter(String uri, AlgorithmParameterSpec spec, Element el, Marshalling m) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            if (spec == null) {
                return;
            }
            Document factory = el.getOwnerDocument();
            int len = ((HMACParameterSpec)spec).getOutputLength();
            Element hol = m != null ? m.createElement("http://www.w3.org/2001/10/xml-exc-c14n#", "HMACOutputLength", false) : Marshalling.createElement(null, factory, "http://www.w3.org/2001/10/xml-exc-c14n#", "HMACOutputLength", false);
            hol.appendChild(factory.createTextNode(Integer.toString(len)));
            if (m != null) {
                m.increment();
                m.indent(el);
            }
            el.appendChild(hol);
            if (m != null) {
                m.decrement();
                m.indent(el);
            }
        } else if (this.supportedSignatures.contains(uri) || this.supportedDigests.contains(uri)) {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("The algorithm '" + uri + "' does not support any AlgorithmParameterSpec.");
            }
        } else {
            throw new NoSuchAlgorithmException(uri);
        }
    }

    public synchronized PublicKey generatePublic(KeySpec spec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory f;
        if (spec instanceof DSAPublicKeySpec) {
            if (this.dsaFactory == null) {
                this.dsaFactory = this.keyProvider == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", this.keyProvider);
            }
            f = this.dsaFactory;
        } else if (spec instanceof RSAPublicKeySpec) {
            if (this.rsaFactory == null) {
                this.rsaFactory = this.keyProvider == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", this.keyProvider);
            }
            f = this.rsaFactory;
        } else if (spec instanceof ECPublicKeySpec) {
            if (this.ecFactory == null) {
                this.ecFactory = this.keyProvider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", this.keyProvider);
            }
            f = this.ecFactory;
        } else {
            throw new IllegalArgumentException("Internal Error: unknown class: " + spec.getClass().getName());
        }
        return f.generatePublic(spec);
    }

    public synchronized Certificate generateCertificate(InputStream is) throws CertificateException, NoSuchProviderException {
        if (this.certFactory == null) {
            this.certFactory = this.certProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.certProvider);
        }
        return this.certFactory.generateCertificate(is);
    }

    public synchronized CRL generateCRL(InputStream is) throws CertificateException, NoSuchProviderException, CRLException {
        if (this.certFactory == null) {
            this.certFactory = this.certProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.certProvider);
        }
        return this.certFactory.generateCRL(is);
    }

    private synchronized DocumentBuilderFactory getBuilderFactory() {
        if (this.builderFactory != null) {
            return this.builderFactory;
        }
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setNamespaceAware(true);
        this.builderFactory.setExpandEntityReferences(true);
        try {
            this.builderFactory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.builderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        Stack stack = this.builderCache;
        synchronized (stack) {
            if (!this.builderCache.isEmpty()) {
                return (DocumentBuilder)this.builderCache.pop();
            }
        }
        return this.getBuilderFactory().newDocumentBuilder();
    }

    public void releaseDocumentBuilder(DocumentBuilder builder) {
        this.builderCache.push(builder);
    }

    public Document parse(String uri) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.parse(uri);
        this.releaseDocumentBuilder(builder);
        return doc;
    }

    public Document parse(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.parse(stream);
        this.releaseDocumentBuilder(builder);
        return doc;
    }

    public boolean checkURI(String uri) {
        return AlgorithmFactory.checkURI(uri, false);
    }

    public static boolean checkURI(String uri, boolean verbose) {
        if (verbose) {
            System.err.println("Whole URI: '" + uri + "'");
        }
        int off = 0;
        int len = uri.length();
        boolean hasSchema = false;
        int next = AlgorithmFactory.lookupUriSchema(uri, off);
        if (next >= 0) {
            if (verbose) {
                System.err.println("<schema>: " + uri.substring(off, next));
            }
            if (!AlgorithmFactory.checkUriSchema(uri, off, next, verbose)) {
                return false;
            }
            hasSchema = true;
            off = next;
        }
        boolean hasAuthority = false;
        next = AlgorithmFactory.lookupUriAuthority(uri, off);
        if (next >= 0) {
            if (verbose) {
                System.err.println("<authority>: " + uri.substring(off, next));
            }
            if (!AlgorithmFactory.checkUriAuthority(uri, off, next, verbose)) {
                return false;
            }
            hasAuthority = true;
            off = next;
        }
        if ((next = AlgorithmFactory.lookupUriPath(uri, off)) >= 0) {
            if (verbose) {
                System.err.println("<path>: " + uri.substring(off, next));
            }
            if (!AlgorithmFactory.checkUriPath(uri, off, next, hasSchema, hasAuthority, verbose)) {
                return false;
            }
            off = next;
        }
        if ((next = AlgorithmFactory.lookupUriQuery(uri, off)) >= 0) {
            if (verbose) {
                System.err.println("<query>: " + uri.substring(off, next));
            }
            if (!AlgorithmFactory.checkUriQuery(uri, off, next, verbose)) {
                return false;
            }
            off = next;
        }
        if ((next = AlgorithmFactory.lookupUriFragment(uri, off)) >= 0) {
            if (verbose) {
                System.err.println("<fragment>: " + uri.substring(off, next));
            }
            if (!AlgorithmFactory.checkUriFragment(uri, off, next, verbose)) {
                return false;
            }
            off = next;
        }
        if (off != len) {
            if (verbose) {
                System.err.println("URI parsing failed: " + uri.substring(off));
            }
            return false;
        }
        return true;
    }

    private static int lookupUriSchema(String uri, int off) {
        int len = uri.length();
        if (off >= len) {
            return -1;
        }
        char ch = uri.charAt(off);
        if (ch == ':' || ch == '/' || ch == '?' || ch == '#') {
            return -1;
        }
        ++off;
        while (off < len) {
            if ((ch = uri.charAt(off++)) == ':') {
                return off;
            }
            if (ch != '/' && ch != '?' && ch != '#') continue;
            return -1;
        }
        return -1;
    }

    private static int lookupUriAuthority(String uri, int off) {
        int len = uri.length();
        if (off + 1 >= len) {
            return -1;
        }
        if (uri.charAt(off++) != '/') {
            return -1;
        }
        if (uri.charAt(off++) != '/') {
            return -1;
        }
        while (off < len) {
            char ch = uri.charAt(off);
            if (ch == '/' || ch == '?' || ch == '#') {
                return off;
            }
            ++off;
        }
        return off;
    }

    private static int lookupUriPath(String uri, int off) {
        int len = uri.length();
        while (off < len) {
            char ch = uri.charAt(off);
            if (ch == '?' || ch == '#') {
                return off;
            }
            ++off;
        }
        return off;
    }

    private static int lookupUriQuery(String uri, int off) {
        int len = uri.length();
        if (off >= len) {
            return -1;
        }
        if (uri.charAt(off++) != '?') {
            return -1;
        }
        while (off < len) {
            char ch = uri.charAt(off);
            if (ch == '#') {
                return off;
            }
            ++off;
        }
        return off;
    }

    private static int lookupUriFragment(String uri, int off) {
        int len = uri.length();
        if (off >= len) {
            return -1;
        }
        if (uri.charAt(off++) != '#') {
            return -1;
        }
        return len;
    }

    private static boolean checkUriSchema(String uri, int start, int end, boolean verbose) {
        char ch;
        if (!AlgorithmFactory.isAlpha(ch = uri.charAt(start++)) && verbose) {
            System.err.println("<schema> must start with <alpha>: " + ch);
        }
        --end;
        while (start < end) {
            if (AlgorithmFactory.isAlphanum(ch = uri.charAt(start++)) || ch == '+' || ch == '-' || ch == '.') continue;
            if (verbose) {
                System.err.println("Invalid <schema> character: " + ch);
            }
            return false;
        }
        return true;
    }

    private static boolean checkUriAuthority(String uri, int start, int end, boolean verbose) {
        start += 2;
        while (start < end) {
            if (AlgorithmFactory.isEscaped(uri, start, end)) {
                start += 3;
                continue;
            }
            if (uri.charAt(start++) != '%') continue;
            if (verbose) {
                System.err.println("Broken %-escape");
            }
            return false;
        }
        return true;
    }

    private static boolean checkUriPath(String uri, int start, int end, boolean hasScheme, boolean hasAuthority, boolean verbose) {
        char ch;
        if (hasScheme) {
            if (start >= end) {
                return hasAuthority;
            }
            if ((ch = uri.charAt(start++)) != '/') {
                while (start < end) {
                    if (AlgorithmFactory.isEscaped(uri, start, end)) {
                        start += 3;
                        continue;
                    }
                    if (AlgorithmFactory.isNonEscapedUric(ch = uri.charAt(start++))) continue;
                    if (verbose) {
                        System.err.println("Invalid <opaque_part> character: " + ch);
                    }
                    return false;
                }
                return true;
            }
        } else if (start < end && uri.charAt(start) == ':') {
            if (verbose) {
                System.err.println("Invalid <abs_path> or <rel_path>: " + uri.substring(start, end));
            }
            return false;
        }
        while (start < end) {
            if (AlgorithmFactory.isEscaped(uri, start, end)) {
                start += 3;
                continue;
            }
            if ((ch = uri.charAt(start++)) >= '\u0080') {
                return false;
            }
            int v = URI_CHAR[ch];
            if ((v & 2) != 0 || (v & 0x10) != 0 || (v & 8) != 0) continue;
            if (verbose) {
                System.err.println("Invalid path character: " + ch);
            }
            return false;
        }
        return true;
    }

    private static boolean checkUriQuery(String uri, int start, int end, boolean verbose) {
        ++start;
        while (start < end) {
            char ch;
            if (AlgorithmFactory.isEscaped(uri, start, end)) {
                start += 3;
                continue;
            }
            if (AlgorithmFactory.isNonEscapedUric(ch = uri.charAt(start++))) continue;
            if (verbose) {
                System.err.println("Invalid <query> character: " + ch);
            }
            return false;
        }
        return true;
    }

    private static boolean checkUriFragment(String uri, int start, int end, boolean verbose) {
        ++start;
        while (start < end) {
            char ch;
            if (AlgorithmFactory.isEscaped(uri, start, end)) {
                start += 3;
                continue;
            }
            if (AlgorithmFactory.isNonEscapedUric(ch = uri.charAt(start++))) continue;
            if (verbose) {
                System.err.println("Invalid <fragment> character: " + ch);
            }
            return false;
        }
        return true;
    }

    private static boolean isAlpha(char ch) {
        if (ch >= '\u0080') {
            return false;
        }
        return (URI_CHAR[ch] & 4) != 0;
    }

    private static boolean isAlphanum(char ch) {
        if (ch >= '\u0080') {
            return false;
        }
        return (URI_CHAR[ch] & 2) != 0;
    }

    private static boolean isNonEscapedUric(char ch) {
        if (ch >= '\u0080') {
            return true;
        }
        int v = URI_CHAR[ch];
        return (v & 8) != 0 || (v & 2) != 0 || (v & 0x10) != 0;
    }

    private static boolean isEscaped(String uri, int start, int end) {
        if (start >= end) {
            return false;
        }
        if (uri.charAt(start++) != '%') {
            return false;
        }
        if (start >= end) {
            return false;
        }
        if ((URI_CHAR[uri.charAt(start++)] & 0x20) == 0) {
            return false;
        }
        if (start >= end) {
            return false;
        }
        return (URI_CHAR[uri.charAt(start)] & 0x20) != 0;
    }

    public boolean checkPGPKeyId(byte[] keyId) {
        return keyId.length == 8;
    }

    public boolean checkPGPKeyPacket(byte[] keyPacket) throws IllegalArgumentException {
        int lengthType;
        if (keyPacket == null) {
            throw new IllegalArgumentException("Null PGP key packet");
        }
        int len = keyPacket.length;
        if (len < 1) {
            throw new IllegalArgumentException("PGP key packet is too short.");
        }
        int b = keyPacket[0] & 0xFF;
        if ((b & 0x80) == 0) {
            throw new IllegalArgumentException("Bit 7 of PTag octet should be 1.");
        }
        if ((b & 0x40) == 0) {
            int tag = (b & 0x3C) >> 2;
            lengthType = b & 3;
        } else {
            int tag = b & 0x3F;
            lengthType = 4;
        }
        switch (lengthType) {
            case 0: {
                if (len < 2) {
                    throw new IllegalArgumentException("PGP key packet is too short.  Three octets are required.");
                }
                long bodyLen = (keyPacket[1] & 0xFF) << 8 | keyPacket[2] & 0xFF;
                if ((long)len == 2L + bodyLen) break;
                throw new IllegalArgumentException("The length of the PGP key packet is invalid.  The length should be " + (3L + bodyLen));
            }
            case 1: {
                if (len < 3) {
                    throw new IllegalArgumentException("PGP key packet is too short.  Four octets are required.");
                }
                long bodyLen = (keyPacket[1] & 0xFF) << 8 | keyPacket[2] & 0xFF;
                if ((long)len == 3L + bodyLen) break;
                throw new IllegalArgumentException("The length of the PGP key packet is invalid.  The length should be " + (3L + bodyLen));
            }
            case 2: {
                if (len < 5) {
                    throw new IllegalArgumentException("PGP key packet is too short.  Six octets are required.");
                }
                long bodyLen = (long)(keyPacket[1] << 24) & 0xFF000000L | (long)((keyPacket[2] & 0xFF) << 16) | (long)((keyPacket[3] & 0xFF) << 8) | (long)(keyPacket[4] & 0xFF);
                if ((long)len == 5L + bodyLen) break;
                throw new IllegalArgumentException("The length of the PGP key packet is invalid.  The length should be " + (5L + bodyLen));
            }
            case 3: {
                break;
            }
            case 4: {
                if (len < 2) {
                    throw new IllegalArgumentException("PGP key packet is too short.  Two octets are required.");
                }
                long bodyLen = keyPacket[1] & 0xFF;
                if (bodyLen == 255L) {
                    if (len < 6) {
                        throw new IllegalArgumentException("PGP key packet is too short.  Six octets are required.");
                    }
                    bodyLen = (long)(keyPacket[2] << 24) & 0xFF000000L | (long)((keyPacket[3] & 0xFF) << 16) | (long)((keyPacket[4] & 0xFF) << 8) | (long)(keyPacket[5] & 0xFF);
                    if ((long)len == 6L + bodyLen) break;
                    throw new IllegalArgumentException("The length of the PGP key packet is invalid.  The length should be " + (6L + bodyLen));
                }
                if (bodyLen >= 224L) break;
                if (bodyLen >= 192L) {
                    if (len < 3) {
                        throw new IllegalArgumentException("PGP key packet is too short.  Three octets are required.");
                    }
                    if ((long)len == 3L + (bodyLen = (bodyLen - 192L << 8) + (long)(keyPacket[2] & 0xFF) + 192L)) break;
                    throw new IllegalArgumentException("The length of the PGP key packet is invalid.  The length should be " + (3L + bodyLen));
                }
                if ((long)len == 2L + bodyLen) break;
                throw new IllegalArgumentException("The length of the PGP key packet is invalid.  The length should be " + (2L + bodyLen));
            }
        }
        return true;
    }
}

