/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collective.singleton.RestClientService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RestClientService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class RestClientServiceImpl
implements RestClientService {
    private static final String CERTIFICATE_AUTHENTICATION = "com.ibm.ws.jmx.connector.client.CLIENT_CERT_AUTH";
    private static final String CREDENTIALS = "jmx.remote.credentials";
    private static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private static final String SSL_CONFIG_ID = "controllerConnectionConfig";
    private static final TraceComponent tc = Tr.register(RestClientServiceImpl.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
    private static final String KEY_SSL_SUPPORT = "sslSupport";
    private final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    static final long serialVersionUID = -6582199381155796039L;

    @Reference(name="sslSupport", service=SSLSupport.class)
    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc) {
        this.sslSupportRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.sslSupportRef.deactivate(cc);
    }

    @Override
    public boolean sendRestMessage(String host, String port, String endpoint, String mimeType, String message) {
        return this.performSendRestMessage(host, port, endpoint, mimeType, message);
    }

    /*
     * WARNING - void declaration
     */
    private boolean performSendRestMessage(final String host, final String port, final String endpoint, String mimeType, String message) {
        boolean success;
        block8: {
            success = true;
            try {
                URL targetUrl = null;
                try {
                    targetUrl = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){
                        static final long serialVersionUID = 7231780855079784298L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public URL run() throws MalformedURLException {
                            return new URL("https", host, new Integer(port), endpoint);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.RestClientServiceImpl$1", 1.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    void e;
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.collective.singleton.internal.RestClientServiceImpl", (String)"116", (Object)this, (Object[])new Object[]{host, port, endpoint, mimeType, message});
                    throw new IOException(e.getMessage());
                }
                HttpsURLConnection connection = this.getBasicConnection(targetUrl, "POST", mimeType, true);
                OutputStream st = connection.getOutputStream();
                st.write(message.getBytes("UTF-8"));
                st.flush();
                st.close();
                int responseCode = 0;
                responseCode = connection.getResponseCode();
                switch (responseCode) {
                    case 200: {
                        break;
                    }
                    default: {
                        success = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sendRestMessage error response: " + responseCode), (Object[])new Object[0]);
                        }
                        break;
                    }
                }
            }
            catch (Exception targetUrl) {
                void e;
                FFDCFilter.processException((Throwable)targetUrl, (String)"com.ibm.ws.collective.singleton.internal.RestClientServiceImpl", (String)"136", (Object)this, (Object[])new Object[]{host, port, endpoint, mimeType, message});
                success = false;
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("sendRestMessage exception: " + e), (Object[])new Object[0]);
            }
        }
        return success;
    }

    private HttpsURLConnection getBasicConnection(URL url, String method, String mimeType, boolean output) throws IOException, SSLConfigurationNotAvailableException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(output);
        connection.setUseCaches(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Content-Type", mimeType);
        connection.setReadTimeout(60000);
        if (this.getBasicAuthHeader() != null) {
            connection.setRequestProperty("Authorization", this.getBasicAuthHeader());
        }
        connection.setSSLSocketFactory(this.getSSLSocketFactory());
        return connection;
    }

    /*
     * WARNING - void declaration
     */
    private String getBasicAuthHeader() throws IOException {
        String basicAuthHeader = null;
        Object credentials = this.getCredentials();
        if (!this.areRequiedCredentialsSet(credentials)) {
            throw new IOException("jmx.remote.credentials not provided. Set to a String[2] {user,password}.");
        }
        if (!CERTIFICATE_AUTHENTICATION.equals(credentials)) {
            String[] userPass = (String[])credentials;
            String user = userPass[0];
            JSONConverter converter = JSONConverter.getConverter();
            try {
                basicAuthHeader = "Basic " + converter.encodeStringAsBase64(user + ":" + userPass[1]);
            }
            catch (ConversionException conversionException) {
                void ce;
                FFDCFilter.processException((Throwable)conversionException, (String)"com.ibm.ws.collective.singleton.internal.RestClientServiceImpl", (String)"194", (Object)this, (Object[])new Object[0]);
                throw new IOException("Failure encoding credentials", (Throwable)ce);
            }
            finally {
                JSONConverter.returnConverter((JSONConverter)converter);
            }
        }
        return basicAuthHeader;
    }

    private boolean areRequiedCredentialsSet(Object credentials) {
        if (credentials == null) {
            return false;
        }
        if (CERTIFICATE_AUTHENTICATION.equals(credentials)) {
            return true;
        }
        return credentials instanceof String[] && ((String[])credentials).length == 2;
    }

    private Object getCredentials() {
        return CERTIFICATE_AUTHENTICATION;
    }

    @FFDCIgnore(value={SSLConfigurationNotAvailableException.class})
    private SSLSocketFactory getSSLSocketFactory() throws IOException, SSLConfigurationNotAvailableException {
        SSLContext context = null;
        SSLSocketFactory factory = null;
        String failureMessage = "Could not get an SSL context for the specified SSL configuration: controllerConnectionConfig. Check that the specified SSL configuration is correct.";
        try {
            SSLSupport ss;
            JSSEHelper jsseHelper = null;
            if (this.sslSupportRef != null) {
                ss = (SSLSupport)this.sslSupportRef.getService();
                if (ss == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"SSLSupport is null", (Object[])new Object[0]);
                    }
                    return null;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sslSupport is null ", (Object[])new Object[0]);
                }
                return null;
            }
            jsseHelper = ss.getJSSEHelper();
            context = jsseHelper.getSSLContext(SSL_CONFIG_ID, null, null, false);
        }
        catch (SSLConfigurationNotAvailableException e) {
            throw e;
        }
        catch (SSLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.singleton.internal.RestClientServiceImpl", (String)"256", (Object)this, (Object[])new Object[0]);
            throw new IOException(failureMessage, e);
        }
        if (context == null) {
            throw new IllegalStateException(failureMessage);
        }
        try {
            factory = context.getSocketFactory();
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.singleton.internal.RestClientServiceImpl", (String)"266", (Object)this, (Object[])new Object[0]);
            throw e;
        }
        if (factory == null) {
            throw new IllegalStateException("Factory from context was null");
        }
        return factory;
    }
}

