/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.EnumEntry;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.StructEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.UnionEntry;
import com.ibm.idl.toJavaPortable.Util;
import java.util.Enumeration;
import java.util.Hashtable;

public class TCOffsets {
    private Hashtable tcs = new Hashtable();
    private int offset = 0;

    public int offset(String string) {
        Integer n = (Integer)this.tcs.get(string);
        return n == null ? -1 : n;
    }

    public void set(SymtabEntry symtabEntry) {
        if (symtabEntry == null) {
            this.offset += 8;
        } else {
            this.tcs.put(symtabEntry.fullName(), new Integer(this.offset));
            this.offset += 4;
            String string = Util.stripLeadingUnderscoresFromID(symtabEntry.repositoryID().ID());
            if (symtabEntry instanceof InterfaceEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name());
            } else if (symtabEntry instanceof StructEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name()) + 4;
            } else if (symtabEntry instanceof UnionEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name()) + 12;
            } else if (symtabEntry instanceof EnumEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name()) + 4;
                Enumeration enumeration = ((EnumEntry)symtabEntry).elements().elements();
                while (enumeration.hasMoreElements()) {
                    this.offset += this.alignStrLen((String)enumeration.nextElement());
                }
            } else if (symtabEntry instanceof StringEntry) {
                this.offset += 4;
            } else if (symtabEntry instanceof TypedefEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name());
                if (((TypedefEntry)symtabEntry).arrayInfo().size() != 0) {
                    this.offset += 8;
                }
            }
        }
    }

    public int alignStrLen(String string) {
        int n = string.length() + 1;
        int n2 = 4 - n % 4;
        if (n2 == 4) {
            n2 = 0;
        }
        return n + n2 + 4;
    }

    public void setMember(SymtabEntry symtabEntry) {
        this.offset += this.alignStrLen(symtabEntry.name());
        if (((TypedefEntry)symtabEntry).arrayInfo().size() != 0) {
            this.offset += 4;
        }
    }

    public int currentOffset() {
        return this.offset;
    }

    public void bumpCurrentOffset(int n) {
        this.offset += n;
    }
}

