/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceState;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.StructEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.toJavaPortable.Compile;
import com.ibm.idl.toJavaPortable.Factories;
import com.ibm.idl.toJavaPortable.JavaGenerator;
import com.ibm.idl.toJavaPortable.TCOffsets;
import com.ibm.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StructGen
implements com.ibm.idl.StructGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected StructEntry s = null;
    protected PrintWriter stream = null;
    protected boolean thisIsReallyAnException = false;

    public StructGen() {
    }

    protected StructGen(boolean bl) {
        this.thisIsReallyAnException = bl;
    }

    @Override
    public void generate(Hashtable hashtable, StructEntry structEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.s = structEntry;
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
        this.generateContainedTypes();
    }

    protected void init() {
    }

    protected void openStream() {
        this.stream = Util.stream(this.s, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.s);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.s);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.s);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.s.comment() != null) {
            this.s.comment().generate("", this.stream);
        }
        this.stream.print("public final class " + this.s.name());
        if (this.thisIsReallyAnException) {
            this.stream.print(" extends org.omg.CORBA.UserException");
        }
        this.stream.print(" implements org.omg.CORBA.portable.IDLEntity");
        this.stream.println();
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeMembers();
        this.writeCtors();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.s.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void generateContainedTypes() {
        Enumeration enumeration = this.s.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof SequenceEntry) continue;
            symtabEntry.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeMembers() {
        int n = this.s.members().size();
        for (int i = 0; i < this.s.members().size(); ++i) {
            TypedefEntry typedefEntry = (TypedefEntry)this.s.members().elementAt(i);
            Util.fillInfo(typedefEntry);
            if (typedefEntry.comment() != null) {
                typedefEntry.comment().generate("  ", this.stream);
            }
            if (Util.typeOf(typedefEntry.type()) instanceof StringEntry && typedefEntry.arrayInfo().isEmpty()) {
                Util.writeInitializer("  public ", typedefEntry.name(), "", typedefEntry, "\"\"", this.stream);
                continue;
            }
            Util.writeInitializer("  public ", typedefEntry.name(), "", typedefEntry, this.stream);
        }
    }

    protected void writeCtors() {
        this.stream.println();
        this.stream.println("  public " + this.s.name() + " ()");
        this.stream.println("  {");
        if (this.thisIsReallyAnException) {
            this.stream.println("    super(" + this.s.name() + "Helper.id());");
        }
        this.stream.println("  } // ctor");
        if (this.s.members().size() > 0) {
            this.stream.println();
            this.stream.print("  public " + this.s.name() + " (");
            this.writeParametersList();
            this.stream.println(")");
            this.stream.println("  {");
            if (this.thisIsReallyAnException) {
                this.stream.println("    super(" + this.s.name() + "Helper.id());");
            }
            this.writeMembersInit();
            this.stream.println("  } // Init ctor");
        }
        if (this.thisIsReallyAnException) {
            this.stream.println();
            this.stream.print("  public " + this.s.name() + " (");
            this.stream.print("String $reason");
            if (this.s.members().size() > 0) {
                this.stream.print(", ");
            }
            this.writeParametersList();
            this.stream.println(")");
            this.stream.println("  {");
            this.stream.println("    super(" + this.s.name() + "Helper.id() + \"  \" + $reason);");
            this.writeMembersInit();
            this.stream.println("  } // ctor");
        }
        this.stream.println();
    }

    private void writeParametersList() {
        boolean bl = true;
        for (int i = 0; i < this.s.members().size(); ++i) {
            SymtabEntry symtabEntry = (SymtabEntry)this.s.members().elementAt(i);
            if (bl) {
                bl = false;
            } else {
                this.stream.print(", ");
            }
            this.stream.print(Util.javaName(symtabEntry) + " _" + symtabEntry.name());
        }
    }

    private void writeMembersInit() {
        for (int i = 0; i < this.s.members().size(); ++i) {
            SymtabEntry symtabEntry = (SymtabEntry)this.s.members().elementAt(i);
            this.stream.println("    " + symtabEntry.name() + " = _" + symtabEntry.name() + ";");
        }
    }

    @Override
    public int helperType(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        TCOffsets tCOffsets2 = new TCOffsets();
        tCOffsets2.set(symtabEntry);
        int n2 = tCOffsets2.currentOffset();
        StructEntry structEntry = (StructEntry)symtabEntry;
        String string3 = "_members" + n++;
        printWriter.println(string + "org.omg.CORBA.StructMember[] " + string3 + " = new org.omg.CORBA.StructMember [" + structEntry.members().size() + "];");
        String string4 = "_tcOf" + string3;
        printWriter.println(string + "org.omg.CORBA.TypeCode " + string4 + " = null;");
        for (int i = 0; i < structEntry.members().size(); ++i) {
            TypedefEntry typedefEntry = (TypedefEntry)structEntry.members().elementAt(i);
            String string5 = typedefEntry.name();
            n = ((JavaGenerator)((Object)typedefEntry.generator())).type(n, string, tCOffsets2, string4, typedefEntry, printWriter);
            printWriter.println(string + string3 + '[' + i + "] = new org.omg.CORBA.StructMember (");
            printWriter.println(string + "  \"" + Util.stripLeadingUnderscores(string5) + "\",");
            printWriter.println(string + "  " + string4 + ',');
            printWriter.println(string + "  null);");
            int n3 = tCOffsets2.currentOffset();
            tCOffsets2 = new TCOffsets();
            tCOffsets2.set(symtabEntry);
            tCOffsets2.bumpCurrentOffset(n3 - n2);
        }
        tCOffsets.bumpCurrentOffset(tCOffsets2.currentOffset());
        String string6 = this.thisIsReallyAnException ? "create_exception_tc" : "create_struct_tc";
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ()." + string6 + " (" + Util.helperName(structEntry, true) + ".id (), \"" + Util.stripLeadingUnderscores(symtabEntry.name()) + "\", " + string3 + ");");
        return n;
    }

    @Override
    public int type(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n;
    }

    @Override
    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    " + string + " value = new " + string + " ();");
        this.read(0, "    ", "value", symtabEntry, printWriter);
        printWriter.println("    return value;");
    }

    @Override
    public int read(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        if (this.thisIsReallyAnException) {
            printWriter.println(string + "// read and discard the repository ID");
            printWriter.println(string + "istream.read_string ();");
        }
        Enumeration enumeration = ((StructEntry)symtabEntry).members().elements();
        while (enumeration.hasMoreElements()) {
            TypedefEntry typedefEntry = (TypedefEntry)enumeration.nextElement();
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (!typedefEntry.arrayInfo().isEmpty() || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof TypedefEntry) {
                n = ((JavaGenerator)((Object)typedefEntry.generator())).read(n, string, string2 + '.' + typedefEntry.name(), typedefEntry, printWriter);
                continue;
            }
            if (symtabEntry2 instanceof ValueBoxEntry) {
                Vector vector = ((ValueBoxEntry)symtabEntry2).state();
                TypedefEntry typedefEntry2 = ((InterfaceState)vector.elementAt((int)0)).entry;
                SymtabEntry symtabEntry3 = typedefEntry2.type();
                String string3 = null;
                String string4 = null;
                if (symtabEntry3 instanceof SequenceEntry || symtabEntry3 instanceof StringEntry || !typedefEntry2.arrayInfo().isEmpty()) {
                    string3 = Util.javaName(symtabEntry3);
                    string4 = Util.helperName(symtabEntry2, true);
                } else {
                    string3 = Util.javaName(symtabEntry2);
                    string4 = Util.helperName(symtabEntry2, true);
                }
                if (Compile.compiler.arguments.corbaLevel.gte(2.3f)) {
                    printWriter.println(string + string2 + '.' + typedefEntry.name() + " = (" + string3 + ") " + string4 + ".read (istream);");
                    continue;
                }
                printWriter.println(string + string2 + '.' + typedefEntry.name() + " = (" + string3 + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + string4 + ".get_instance ());");
                continue;
            }
            if (symtabEntry2 instanceof ValueEntry && !Compile.compiler.arguments.corbaLevel.gte(2.3f)) {
                printWriter.println(string + string2 + '.' + typedefEntry.name() + " = (" + Util.javaName(symtabEntry2) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(symtabEntry2, false) + ".get_instance ());");
                continue;
            }
            printWriter.println(string + string2 + '.' + typedefEntry.name() + " = " + Util.helperName(typedefEntry.type(), true) + ".read (istream);");
        }
        return n;
    }

    @Override
    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        this.write(0, "    ", "value", symtabEntry, printWriter);
    }

    @Override
    public int write(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        if (this.thisIsReallyAnException) {
            printWriter.println(string + "// write the repository ID");
            printWriter.println(string + "ostream.write_string (id ());");
        }
        Vector vector = ((StructEntry)symtabEntry).members();
        for (int i = 0; i < vector.size(); ++i) {
            TypedefEntry typedefEntry = (TypedefEntry)vector.elementAt(i);
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (!typedefEntry.arrayInfo().isEmpty() || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry) {
                n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, "    ", string2 + '.' + typedefEntry.name(), typedefEntry, printWriter);
                continue;
            }
            if ((symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) && !Compile.compiler.arguments.corbaLevel.gte(2.3f)) {
                printWriter.println(string + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value ((java.io.Serializable) " + string2 + '.' + typedefEntry.name() + ", " + Util.helperName(typedefEntry.type(), true) + ".get_instance ());");
                continue;
            }
            printWriter.println(string + Util.helperName(typedefEntry.type(), true) + ".write (ostream, " + string2 + '.' + typedefEntry.name() + ");");
        }
        return n;
    }
}

