/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.ConstEntry;
import com.ibm.idl.EnumEntry;
import com.ibm.idl.GenFileStream;
import com.ibm.idl.ModuleEntry;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Hashtable;

public class ConstGen
implements com.ibm.idl.ConstGen {
    protected Hashtable symbolTable = null;
    protected ConstEntry c = null;
    protected PrintWriter stream = null;

    @Override
    public void generate(Hashtable hashtable, ConstEntry constEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.c = constEntry;
        this.stream = printWriter;
        this.init();
        if (constEntry.container() instanceof ModuleEntry) {
            this.generateConst();
        } else if (this.stream != null) {
            this.writeConstExpr();
        }
    }

    protected void init() {
    }

    protected void generateConst() {
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void openStream() {
        this.stream = Util.stream(this.c, ".java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.c);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        this.stream.println("public interface " + this.c.name());
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeConstExpr();
    }

    protected void writeConstExpr() {
        if (this.c.comment() != null) {
            this.c.comment().generate("  ", this.stream);
        }
        if (this.c.container() instanceof ModuleEntry) {
            this.stream.print("  public static final " + Util.javaName(this.c.type()) + " value = ");
        } else {
            this.stream.print("  public static final " + Util.javaName(this.c.type()) + ' ' + this.c.name() + " = ");
        }
        this.writeConstValue(this.c.type());
    }

    private void writeConstValue(SymtabEntry symtabEntry) {
        if (symtabEntry instanceof PrimitiveEntry) {
            this.stream.println('(' + Util.javaName(symtabEntry) + ")(" + Util.parseExpression(this.c.value()) + ");");
        } else if (symtabEntry instanceof StringEntry) {
            this.stream.println(Util.parseExpression(this.c.value()) + ';');
        } else if (symtabEntry instanceof EnumEntry) {
            this.stream.println(symtabEntry.name() + "." + Util.parseExpression(this.c.value()) + ';');
        } else if (symtabEntry instanceof TypedefEntry) {
            while (symtabEntry instanceof TypedefEntry) {
                symtabEntry = symtabEntry.type();
            }
            this.writeConstValue(symtabEntry);
        } else {
            this.stream.println(Util.parseExpression(this.c.value()) + ';');
        }
    }

    protected void writeClosing() {
        this.stream.println("}");
    }

    protected void closeStream() {
        this.stream.close();
    }
}

