/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class ClassTab
extends Tab
implements ActionListener {
    PlotterPanel loadedClassesMeter;
    TimeComboBox timeComboBox;
    private JCheckBox verboseCheckBox;
    private HTMLPane details;
    private ClassOverviewPanel overviewPanel;
    private boolean plotterListening = false;
    private static final String loadedPlotterKey = "loaded";
    private static final String totalLoadedPlotterKey = "totalLoaded";
    private static final Color loadedPlotterColor = Plotter.defaultColor;
    private static final Color totalLoadedPlotterColor = Color.red;

    public static String getTabDescription() {
        return Messages.CLASSES_ACCESSIBLE_DESCRIPTION;
    }

    public static String getTabName() {
        return Messages.CLASSES;
    }

    public ClassTab(VMPanel vMPanel) {
        super(vMPanel, ClassTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 20, 5));
        jPanel.add((Component)jPanel4, "Center");
        this.verboseCheckBox = new JCheckBox(Messages.VERBOSE_OUTPUT);
        this.verboseCheckBox.setMnemonic(Resources.getMnemonicInt(Messages.VERBOSE_OUTPUT));
        this.verboseCheckBox.addActionListener(this);
        this.verboseCheckBox.setToolTipText(Messages.VERBOSE_OUTPUT_TOOLTIP);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(0, 57, 0, 70));
        jPanel5.add(this.verboseCheckBox);
        jPanel.add((Component)jPanel5, "After");
        this.loadedClassesMeter = new PlotterPanel(Messages.NUMBER_OF_LOADED_CLASSES, Plotter.Unit.NONE, false);
        this.loadedClassesMeter.plotter.createSequence(loadedPlotterKey, Messages.LOADED, loadedPlotterColor, true);
        this.loadedClassesMeter.plotter.createSequence(totalLoadedPlotterKey, Messages.TOTAL_LOADED, totalLoadedPlotterColor, true);
        Utilities.setAccessibleName(this.loadedClassesMeter.plotter, Messages.CLASS_TAB_LOADED_CLASSES_PLOTTER_ACCESSIBLE_NAME);
        Utilities.setAccessibleDescription(this.loadedClassesMeter.plotter, Messages.CLASS_TAB_LOADED_CLASSES_PLOTTER_ACCESSIBLE_DESCRIPTION);
        jPanel2.add(this.loadedClassesMeter);
        this.timeComboBox = new TimeComboBox(this.loadedClassesMeter.plotter);
        jPanel4.add(new LabeledComponent(Messages.TIME_RANGE_COLON, Messages.TIME_RANGE_ACCESSIBLE_DESCRIPTION, Resources.getMnemonicInt(Messages.TIME_RANGE_COLON), this.timeComboBox));
        LabeledComponent.layout(jPanel2);
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(Messages.DETAILS), new EmptyBorder(10, 10, 10, 10)));
        Utilities.setAccessibleDescription(jPanel3, Messages.DETAILS_ACCESSIBLE_DESCRIPTION);
        this.details = new HTMLPane();
        Utilities.setAccessibleName(this.details, Messages.DETAILS);
        Utilities.setAccessibleDescription(this.details, Messages.DETAILS_ACCESSIBLE_DESCRIPTION);
        JScrollPane jScrollPane = new JScrollPane(this.details);
        jScrollPane.setPreferredSize(new Dimension(0, 150));
        jPanel3.add((Component)jScrollPane, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final boolean bl = this.verboseCheckBox.isSelected();
        this.workerAdd(new Runnable(){

            @Override
            public void run() {
                ProxyClient proxyClient = ClassTab.this.vmPanel.getProxyClient();
                try {
                    proxyClient.getClassLoadingMXBean().setVerbose(bl);
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    proxyClient.markAsDead();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        final ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (!this.plotterListening) {
            proxyClient.addWeakPropertyChangeListener(this.loadedClassesMeter.plotter);
            this.plotterListening = true;
        }
        return new SwingWorker<Boolean, Object>(){
            private long clCount;
            private long cuCount;
            private long ctCount;
            private boolean isVerbose;
            private String detailsStr;
            private long timeStamp;

            @Override
            public Boolean doInBackground() {
                try {
                    ClassLoadingMXBean classLoadingMXBean = proxyClient.getClassLoadingMXBean();
                    this.clCount = classLoadingMXBean.getLoadedClassCount();
                    this.cuCount = classLoadingMXBean.getUnloadedClassCount();
                    this.ctCount = classLoadingMXBean.getTotalLoadedClassCount();
                    this.isVerbose = classLoadingMXBean.isVerbose();
                    this.detailsStr = this.formatDetails();
                    this.timeStamp = System.currentTimeMillis();
                    return true;
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    proxyClient.markAsDead();
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            ClassTab.this.loadedClassesMeter.plotter.addValues(this.timeStamp, this.clCount, this.ctCount);
                            if (ClassTab.this.overviewPanel != null) {
                                ClassTab.this.overviewPanel.updateClassInfo(this.ctCount, this.clCount);
                                ClassTab.this.overviewPanel.getPlotter().addValues(this.timeStamp, this.clCount);
                            }
                            ClassTab.this.loadedClassesMeter.setValueLabel(this.clCount + "");
                            ClassTab.this.verboseCheckBox.setSelected(this.isVerbose);
                            ClassTab.this.details.setText(this.detailsStr);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        if (!JConsole.isDebug()) break block5;
                        executionException.printStackTrace();
                    }
                }
            }

            private String formatDetails() {
                String string = "<table cellspacing=0 cellpadding=0>";
                long l = System.currentTimeMillis();
                String string2 = Formatter.formatDateTime(l);
                string = string + Formatter.newRow(Messages.TIME, string2);
                string = string + Formatter.newRow(Messages.CURRENT_CLASSES_LOADED, Formatter.justify(this.clCount, 5));
                string = string + Formatter.newRow(Messages.TOTAL_CLASSES_LOADED, Formatter.justify(this.ctCount, 5));
                string = string + Formatter.newRow(Messages.TOTAL_CLASSES_UNLOADED, Formatter.justify(this.cuCount, 5));
                return string;
            }
        };
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new ClassOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class ClassOverviewPanel
    extends OverviewPanel {
        ClassOverviewPanel() {
            super(Messages.CLASSES, ClassTab.loadedPlotterKey, Messages.LOADED, null);
        }

        private void updateClassInfo(long l, long l2) {
            long l3 = l - l2;
            this.getInfoLabel().setText(Resources.format(Messages.CLASS_TAB_INFO_LABEL_FORMAT, l2, l3, l));
        }
    }
}

