/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.WSeedGenerator;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public final class WSecureRandom
extends SecureRandomSpi
implements Serializable {
    private com.ibm.crypto.provider.SecureRandom spi = null;

    public WSecureRandom() {
        byte[] byArray = WSeedGenerator.generateSeed(128);
        if (byArray == null) {
            try {
                byArray = SecureRandom.getInstance("SHA1PRNG").generateSeed(16);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        if (byArray != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(byArray);
                byArray = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        this.spi = new com.ibm.crypto.provider.SecureRandom();
        this.spi.engineSetSeed(byArray);
    }

    public byte[] engineGenerateSeed(int n) {
        return this.spi.engineGenerateSeed(n);
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.spi.engineSetSeed(byArray);
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.spi.engineNextBytes(byArray);
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

