/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import java.io.Serializable;
import java.security.ProviderException;
import java.security.SecureRandomSpi;

public final class PRNG
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 4129268715132691532L;

    private static native byte[] generateSeed(int var0, byte[] var1);

    @Override
    protected void engineSetSeed(byte[] byArray) {
        if (byArray != null) {
            PRNG.generateSeed(-1, byArray);
        }
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        if (byArray != null && PRNG.generateSeed(0, byArray) == null) {
            throw new ProviderException("Error generating random bytes");
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = PRNG.generateSeed(n, new byte[0]);
        if (byArray == null) {
            throw new ProviderException("Error generating seed bytes");
        }
        return byArray;
    }
}

