/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.PKCS5DerivedKeySpec;
import com.ibm.crypto.plus.provider.icc.ICCException;
import com.ibm.crypto.plus.provider.icc.PBKDF;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;

class PKCS5DerivedKey
implements SecretKey {
    static final long serialVersionUID = 463050993315590179L;
    private IBMJCEPlusProvider provider = null;
    private byte[] key;
    private byte[] pwd;
    private byte[] salt;
    private int iCount;
    private int keyLen;
    private String encrFunction;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PKCS5DerivedKey(IBMJCEPlusProvider iBMJCEPlusProvider, PKCS5DerivedKeySpec pKCS5DerivedKeySpec) throws InvalidKeySpecException, ICCException {
        this.provider = iBMJCEPlusProvider;
        char[] cArray = pKCS5DerivedKeySpec.getPassword();
        this.pwd = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            this.pwd[i2] = (byte)(cArray[i2] & 0x7F);
        }
        Arrays.fill(cArray, ' ');
        this.salt = pKCS5DerivedKeySpec.getSalt();
        this.iCount = pKCS5DerivedKeySpec.getIterationCount();
        this.keyLen = pKCS5DerivedKeySpec.getKeyLength();
        this.encrFunction = pKCS5DerivedKeySpec.getEncryptionFunction();
        this.key = this.encrFunction.equals(z[2]) || this.encrFunction.equals(z[3]) || this.encrFunction.equals(z[4]) ? this.a() : this.b();
        if (this.key == null) {
            throw new InvalidKeySpecException(z[1]);
        }
    }

    private byte[] a() throws ICCException {
        PKCS5DerivedKeySpec pKCS5DerivedKeySpec = this.c();
        byte[] byArray = PBKDF.deriveKeyPBKDF1(this.provider.a(), pKCS5DerivedKeySpec);
        return byArray;
    }

    private byte[] b() throws InvalidKeySpecException, ICCException {
        byte[] byArray = PBKDF.deriveKeyPBKDF2(this.provider.a(), this.getEncryptionFunction(), this.pwd, this.salt, this.iCount, this.keyLen * 8);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            PKCS5DerivedKey pKCS5DerivedKey = this;
            synchronized (pKCS5DerivedKey) {
                if (this.key != null) {
                    Arrays.fill(this.key, (byte)0);
                    this.key = null;
                }
                if (this.pwd != null) {
                    Arrays.fill(this.pwd, (byte)0);
                    this.pwd = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    public synchronized byte[] getEncodedKey() {
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOctetString(this.key);
            derOutputStream.putOctetString(this.pwd);
            derOutputStream.putOctetString(this.salt);
            derOutputStream.putInteger(BigInteger.valueOf(this.iCount));
            derOutputStream.putInteger(BigInteger.valueOf(this.keyLen));
            derOutputStream.putPrintableString(this.encrFunction);
        }
        catch (IOException iOException) {
            return null;
        }
        return derOutputStream.toByteArray();
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    public String getEncryptionFunction() {
        return new String(this.encrFunction);
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getFormat() {
        return z[0];
    }

    public int hashCode() {
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < this.key.length; ++n2) {
            n3 += this.key[n2] * n2;
        }
        for (n2 = 1; n2 < this.salt.length; ++n2) {
            n3 += this.salt[n2] * n2;
        }
        n3 ^= this.iCount;
        n3 ^= this.keyLen;
        return n3 ^= this.getEncryptionFunction().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        byte[] byArray = secretKey.getEncoded();
        boolean bl = MessageDigest.isEqual(this.getEncoded(), byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private PKCS5DerivedKeySpec c() {
        char[] cArray = new char[this.pwd.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = (char)this.pwd[i2];
        }
        PKCS5DerivedKeySpec pKCS5DerivedKeySpec = new PKCS5DerivedKeySpec(cArray, this.salt, this.iCount, this.keyLen * 8, this.encrFunction);
        return pKCS5DerivedKeySpec;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ";x0\u0000C4w6\u0001?=v7\f=.j";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                block15: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block15;
                    n5 = n5;
                    if (n5 <= n4) break block16;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 107;
                            break;
                        }
                        case 1: {
                            n6 = 51;
                            break;
                        }
                        case 2: {
                            n6 = 115;
                            break;
                        }
                        case 3: {
                            n6 = 83;
                            break;
                        }
                        default: {
                            n6 = 118;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = " V\ns\u0013\u0005P\u0001*\u0006\u001fZ\u001c=V\n_\u0014<\u0004\u0002G\u001b>V\u0005\\\u0007s\u0010\u0004F\u001d7";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "&wA";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "&wF";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "8{2b";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

