/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.slicer;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.ByteParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.SlicerImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import com.ibm.java.diagnostics.healthcenter.sources.ToggleableSource;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public class ByteSlicerImpl
extends SlicerImpl {
    private static Logger TRACE = LogFactory.getTrace(ByteSlicerImpl.class);
    private static final int MINIMUM_SENSIBLE_SLICE = 4096;
    private static final int DEFAULT_SLICE_SIZE = 20480;
    private final DynamicSource toggleableSource;
    private ByteParser byteParser = null;
    private Object byteArrayLock = new Object();
    private final Queue<InputStream> streamQueue;
    private byte[] dataToParse;
    private int pointer = 0;

    public ByteSlicerImpl(Source source, ByteParser byteParser, Marshaller marshaller) throws JavaDiagnosticsException {
        super(source, byteParser, marshaller);
        this.byteParser = byteParser;
        this.toggleableSource = source instanceof ToggleableSource ? (DynamicSource)source : null;
        this.streamQueue = new LinkedList<InputStream>();
    }

    @Override
    protected int getDefaultSliceSize() {
        return 20480;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProgressIndicator internalTriggerParse(DataBuilder dataBuilder, OutputProperties outputProperties) {
        ProgressIndicator progressIndicator = null;
        Object object = this.byteArrayLock;
        synchronized (object) {
            byte[] byArray = this.getByteSlice();
            if (byArray != null && byArray.length > 0) {
                progressIndicator = this.byteParser.parse(this.toggleableSource, byArray, dataBuilder, outputProperties);
                int n = progressIndicator.getProgress();
                if (n != -1 && n != -2) {
                    if (this.pointer + n >= this.dataToParse.length) {
                        // empty if block
                    }
                    this.pointer += n;
                    Thread.yield();
                }
                if (n > 4096) {
                    this.setSliceSize(n);
                }
            }
        }
        return progressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnseenSourceAvailable() {
        Object object = this.byteArrayLock;
        synchronized (object) {
            boolean bl = false;
            InputStream inputStream = this.streamQueue.peek();
            try {
                if (inputStream != null && inputStream.available() > 0) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnySourceAvailable() {
        Object object = this.byteArrayLock;
        synchronized (object) {
            boolean bl = this.dataToParse != null && this.dataToParse.length > this.pointer + 1;
            return bl || this.isUnseenSourceAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySourceChanged(InputStream inputStream) {
        int n = this.marshaller.getMaxQueueSize();
        boolean bl = false;
        if (this.isEnabled()) {
            Object object = this.byteArrayLock;
            synchronized (object) {
                int n2 = this.streamQueue.size();
                if (n2 < n && !this.marshaller.flushQueue()) {
                    this.streamQueue.add(inputStream);
                    bl = true;
                } else {
                    this.marshaller.setFlushQueue(true);
                    bl = false;
                }
                if (n2 == 0) {
                    this.marshaller.setFlushQueue(false);
                }
            }
            if (bl) {
                this.marshaller.addToQueue(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteSlice() {
        Object object = this.byteArrayLock;
        synchronized (object) {
            InputStream inputStream;
            byte[] byArray = null;
            int n = 0;
            if (this.dataToParse != null && this.dataToParse.length > this.pointer) {
                byArray = this.dataToParse;
                n = this.dataToParse.length - this.pointer;
            }
            if ((inputStream = this.streamQueue.peek()) != null) {
                try {
                    byte[] byArray2;
                    long l = this.source.dataAvailable();
                    int n2 = inputStream.available();
                    int n3 = (int)Math.min((long)this.sliceSize, Math.max((long)n2, l) + (long)n);
                    if (n3 > n) {
                        byArray2 = new byte[n3];
                        if (n == 0) {
                            inputStream.read(byArray2);
                            this.pointer = 0;
                        } else {
                            System.arraycopy(byArray, this.pointer, byArray2, 0, n);
                            this.pointer = 0;
                            inputStream.read(byArray2, n, byArray2.length - n);
                        }
                    } else {
                        byArray2 = new byte[n];
                        if (this.dataToParse != null) {
                            System.arraycopy(this.dataToParse, this.pointer, byArray2, 0, n);
                        }
                        this.dataToParse = byArray2;
                        this.pointer = 0;
                    }
                    this.dataToParse = byArray2;
                    if (inputStream.available() == 0) {
                        inputStream.close();
                        this.streamQueue.remove();
                    }
                }
                catch (IOException iOException) {
                    TRACE.warning(MessageFormat.format(Messages.getString("ByteSlicerImpl.array.append"), iOException));
                }
                catch (Exception exception) {
                    TRACE.warning(MessageFormat.format(Messages.getString("ByteSlicerImpl.exception.getting.slice"), exception));
                    exception.printStackTrace();
                }
            } else {
                byte[] byArray3 = new byte[n];
                if (this.dataToParse != null) {
                    System.arraycopy(this.dataToParse, this.pointer, byArray3, 0, n);
                }
                this.dataToParse = byArray3;
                this.pointer = 0;
            }
        }
        return this.dataToParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearBufferCaches() {
        Object object = this.byteArrayLock;
        synchronized (object) {
            this.dataToParse = null;
            InputStream inputStream = this.streamQueue.poll();
            while (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = this.streamQueue.poll();
                }
                catch (IOException iOException) {
                    TRACE.warning(iOException.toString());
                }
            }
        }
    }
}

