/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.mqtt;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.connection.AgentConnection;
import com.ibm.java.diagnostics.healthcenter.connection.AgentConnectionManager;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.connection.HealthCenterConnectionException;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties;
import com.ibm.java.diagnostics.healthcenter.impl.mqtt.MQTTAgentConnection;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;

public class MQTTAgentConnectionManager
implements AgentConnectionManager {
    private static final String MQTT_IDENTIFY_THREAD_NAME = "Identify agents";
    private final ConnectionProperties properties;
    private final List<AgentConnection> agentList;
    private IdentifyAgents identifyThread;
    private int port;
    private static final Logger TRACE = LogFactory.getTrace(MQTTAgentConnectionManager.class);

    public MQTTAgentConnectionManager(ConnectionProperties connectionProperties) {
        this.properties = connectionProperties;
        this.agentList = new ArrayList<AgentConnection>();
        this.port = 0;
    }

    @Override
    public AgentConnection getHealthCenterAgent() throws HealthCenterConnectionException {
        return this.getHealthCenterAgentForPort(this.properties.getPort());
    }

    public AgentConnection getHealthCenterAgentForPort(int n) throws HealthCenterConnectionException {
        if (this.agentList != null) {
            this.agentList.clear();
        }
        this.port = n;
        this.identifyThread = new IdentifyAgents(MQTT_IDENTIFY_THREAD_NAME);
        this.identifyThread.start();
        while (this.identifyThread.isAlive()) {
            if (this.agentList.size() <= 0) continue;
            this.identifyThread.done();
        }
        if (this.agentList.size() == 0) {
            return null;
        }
        return this.agentList.get(0);
    }

    public List<AgentConnection> getHealthCenterAgentsForPort(int n, int n2) throws HealthCenterConnectionException {
        if (this.agentList != null) {
            this.agentList.clear();
        }
        if (n2 < 0) {
            return this.agentList;
        }
        this.port = n;
        this.identifyThread = new IdentifyAgents(MQTT_IDENTIFY_THREAD_NAME);
        this.identifyThread.start();
        int n3 = 0;
        while (this.identifyThread.isAlive()) {
            try {
                Thread.sleep(3000L);
                int n4 = this.agentList.size();
                if (n2 != 0 && n2 <= n4 || n4 == n3) {
                    this.identifyThread.done();
                    continue;
                }
                n3 = n4;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (n2 != 0 && this.agentList.size() > n2) {
            return this.agentList.subList(0, n2);
        }
        return this.agentList;
    }

    public AgentConnection getHealthCenterAgent(String string) throws HealthCenterConnectionException {
        if (this.agentList != null) {
            this.agentList.clear();
        }
        this.port = this.properties.getPort();
        this.identifyThread = new IdentifyAgents(MQTT_IDENTIFY_THREAD_NAME);
        this.identifyThread.start();
        int n = 0;
        while (this.identifyThread.isAlive()) {
            try {
                Thread.sleep(3000L);
                int n2 = this.agentList.size();
                if (n2 == n) {
                    this.identifyThread.done();
                    continue;
                }
                n = n2;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        AgentConnection agentConnection = null;
        for (AgentConnection object : this.agentList) {
            if (!object.getDescription().equals(string)) continue;
            agentConnection = object;
            break;
        }
        if (null == agentConnection) {
            String string2 = Messages.getString("AgentConnection.no.agent.with.that.name");
            String string3 = MessageFormat.format(string2, string, this.properties.getHostName(), this.properties.getPort());
            if (TRACE.isLoggable(Level.INFO)) {
                TRACE.info(string3);
            }
        }
        return agentConnection;
    }

    private void addAgentToTable(AgentConnection agentConnection) {
        for (AgentConnection agentConnection2 : this.agentList) {
            if (!agentConnection2.isEqual(agentConnection)) continue;
            return;
        }
        this.agentList.add(agentConnection);
    }

    private class IdentifyAgents
    extends Thread
    implements MqttCallback {
        private static final String BASETOPIC = "ibm/healthcenter";
        private boolean threadDone;

        public IdentifyAgents(String string) {
            super(string);
            this.threadDone = false;
        }

        public void done() {
            this.threadDone = true;
        }

        @Override
        public void run() {
            String string;
            String string2;
            Random random = new Random();
            String string3 = "HCID_" + random.nextInt(99999999);
            String string4 = "tcp://";
            String string5 = string4 + MQTTAgentConnectionManager.this.properties.getHostName() + ":" + MQTTAgentConnectionManager.this.port;
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            if (MQTTAgentConnectionManager.this.properties.getUserName() != null) {
                mqttConnectOptions.setUserName(MQTTAgentConnectionManager.this.properties.getUserName());
            }
            if (MQTTAgentConnectionManager.this.properties.getPassword() != null) {
                mqttConnectOptions.setPassword(MQTTAgentConnectionManager.this.properties.getPassword().toCharArray());
            }
            if (MQTTAgentConnectionManager.this.properties.getConnectionType().equals((Object)ConnectionType.BLUEMIX) && MQTTAgentConnectionManager.this.properties.getBlueMixport() > 0) {
                string5 = string4 + "127.0.0.1:" + MQTTAgentConnectionManager.this.properties.getBlueMixport();
            }
            MqttClient mqttClient = null;
            try {
                mqttClient = new MqttClient(string5, string3, null);
                mqttClient.setCallback(this);
                mqttClient.connect(mqttConnectOptions);
                mqttClient.subscribe("ibm/healthcenter/id");
                mqttClient.publish("ibm/healthcenter/identify", new MqttMessage());
                string2 = Messages.getString("MQTTAgentConnectionManager.searching.for.agents");
                string = MessageFormat.format(string2, MQTTAgentConnectionManager.this.properties.getHostName(), MQTTAgentConnectionManager.this.port);
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine(string);
                }
            }
            catch (MqttPersistenceException mqttPersistenceException) {
                mqttPersistenceException.printStackTrace();
            }
            catch (MqttSecurityException mqttSecurityException) {
                mqttSecurityException.printStackTrace();
            }
            catch (MqttException mqttException) {
                string = Messages.getString("MQTTAgentConnectionManager.no.broker.found");
                String string6 = MessageFormat.format(string, MQTTAgentConnectionManager.this.properties.getHostName(), MQTTAgentConnectionManager.this.port);
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine(string6);
                }
                this.done();
            }
            while (!this.threadDone) {
                try {
                    Thread.sleep(3000L);
                    if (MQTTAgentConnectionManager.this.agentList.size() != 0) continue;
                    string2 = Messages.getString("MQTTAgentConnectionManager.no.agents.found");
                    if (!TRACE.isLoggable(Level.FINE)) continue;
                    TRACE.fine(string2);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            try {
                if (mqttClient != null) {
                    if (mqttClient.isConnected()) {
                        mqttClient.disconnect();
                    }
                    mqttClient.close();
                }
            }
            catch (MqttException mqttException) {
                mqttException.printStackTrace();
            }
        }

        @Override
        public void connectionLost(Throwable throwable) {
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        }

        @Override
        public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
            MQTTAgentConnection mQTTAgentConnection = new MQTTAgentConnection(MQTTAgentConnectionManager.this.properties.getHostName(), MQTTAgentConnectionManager.this.port, mqttMessage.toString());
            MQTTAgentConnectionManager.this.addAgentToTable(mQTTAgentConnection);
        }
    }
}

