/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextSourceImpl
extends SourceImpl {
    private static final int BYTES_PER_CHARACTER = 2;
    private String text;
    private boolean hasChanged = true;
    private static final Logger TRACE = LogFactory.getTrace(TextSourceImpl.class);

    public TextSourceImpl(String string, String string2) {
        this(string, string2, null);
    }

    public TextSourceImpl(String string, String string2, ConnectionDataBuilder connectionDataBuilder) {
        super(string, connectionDataBuilder);
        this.text = string2;
    }

    public String getText() throws JavaDiagnosticsException {
        this.hasChanged = false;
        return this.text;
    }

    public InputStream getRawStream() throws JavaDiagnosticsException {
        this.hasChanged = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.text.getBytes());
        return byteArrayInputStream;
    }

    public boolean hasChangedSinceLastGet() {
        return this.hasChanged;
    }

    public boolean containsWithinReasonableDistanceOfStart(String string) {
        this.hasChanged = false;
        return this.text.indexOf(string) > -1;
    }

    public boolean containsWithinReasonableDistanceOfStart(String[] stringArray) {
        this.hasChanged = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("|");
        }
        Pattern pattern = Pattern.compile(stringBuffer.toString());
        Matcher matcher = pattern.matcher(this.text);
        return matcher.find();
    }

    public long getApproximateSize() throws JavaDiagnosticsException {
        return this.text.length() * 2;
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
    }

    @Override
    public InputStream getBackingStream() {
        try {
            return this.getRawStream();
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(MessageFormat.format(Messages.getString("TextSourceImp.backingfile.exception"), javaDiagnosticsException));
            return null;
        }
    }
}

