/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataStoragePreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MQTTConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.DataFileStorage;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.MQTTEnablementConfigurationSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.sources.RequestableSource;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MQTTSourceImpl
extends SourceImpl
implements RequestableSource {
    private MQTTConnectionDataImpl connection;
    private byte[] headerInformation = new byte[0];
    private boolean sourceHeaderRead = false;
    private DataStoragePreferenceHelper preferences;
    private Marshaller marshaller;
    private DataFileStorage dataFileStorage;
    private boolean shutdown = false;

    public MQTTSourceImpl(String string, ConnectionDataBuilder connectionDataBuilder) {
        super(string, connectionDataBuilder);
        SourceUpdateJob sourceUpdateJob = new SourceUpdateJob(string);
        this.connection = (MQTTConnectionDataImpl)connectionDataBuilder;
        this.dataFileStorage = new DataFileStorage(string);
        this.dataFileStorage.setupFiles();
        this.marshaller = MarshallerImpl.getMarshaller();
        this.preferences = new DataStoragePreferenceHelper();
        sourceUpdateJob.start();
    }

    @Override
    public void internalShutdown() {
        this.dataFileStorage.internalShutdown();
        this.shutdown = true;
    }

    public Source spawnConfigurationSource(MQTTConnectionDataImpl mQTTConnectionDataImpl, String string) {
        String string2 = this.getName();
        String string3 = null;
        if (string2.equalsIgnoreCase("classhistogram")) {
            string3 = "ClassHistogramSource";
        } else if (string2.equalsIgnoreCase("cpu")) {
            string3 = "CpuSource";
        } else if (string2.equalsIgnoreCase("environment")) {
            string3 = "EnvironmentSource";
        } else if (string2.equalsIgnoreCase("locking")) {
            string3 = "JLASource";
        } else if (string2.equalsIgnoreCase("memory")) {
            string3 = "MemorySource";
        } else if (string2.equalsIgnoreCase("memorycounters")) {
            string3 = "MemoryCountersSource";
        } else if (string2.equalsIgnoreCase("methoddictionary")) {
            string3 = "MethodDictionarySource";
        } else if (string2.equalsIgnoreCase("threads")) {
            string3 = "ThreadsSource";
        } else if (string2.equalsIgnoreCase("trace")) {
            string3 = "TRACESubscriberSource";
        }
        if (string3 == null) {
            string3 = string2;
        }
        return new MQTTEnablementConfigurationSourceImpl(string3, this.connectionData, this, mQTTConnectionDataImpl, string);
    }

    @Override
    public void request(String ... stringArray) {
        this.connection.sendMessage(this.getName(), "request", stringArray);
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void deleteBackingFile() {
        this.dataFileStorage.deleteBackingFile();
    }

    @Override
    public void swapBackingFiles() {
        this.dataFileStorage.swapBackingFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeDataToFile(byte[] byArray) throws IOException {
        int n = 0;
        if (byArray != null && this.dataFileStorage.getOutputStream() != null) {
            Object object = this.dataFileStorage.getLock();
            synchronized (object) {
                if (this.dataFileStorage.getLength() + (long)byArray.length > (long)this.preferences.getBackingFileSize()) {
                    this.marshaller.save();
                }
                if (!this.sourceHeaderRead) {
                    if (this.checkForHeader(byArray)) {
                        this.sourceHeaderRead = true;
                        this.dataFileStorage.getOutputStream().write(byArray, 0, byArray.length);
                    }
                } else {
                    this.dataFileStorage.getOutputStream().write(byArray, 0, byArray.length);
                }
                n = byArray.length;
                this.dataFileStorage.getOutputStream().flush();
            }
        }
        return n;
    }

    private boolean checkForHeader(byte[] byArray) {
        if (!this.getName().equals("trace")) {
            return true;
        }
        if (null == byArray || byArray.length < 4) {
            return false;
        }
        String string = new String(byArray, 0, 4);
        return string.equals("HCTH");
    }

    @Override
    public InputStream getBackingStream() {
        return this.dataFileStorage.getBackingStream(this.headerInformation);
    }

    private class SourceUpdateJob
    extends Thread {
        private String topic;
        private static final int SECONDS_TO_MILLIS = 1000;

        SourceUpdateJob(String string) {
            this.topic = string;
        }

        public String getTopic() {
            return this.topic;
        }

        @Override
        public String toString() {
            return this.getTopic();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                long l = 2000L;
                byte[] byArray = MQTTSourceImpl.this.connection.getTopicData(this.topic);
                while (byArray != null) {
                    Object object = MQTTSourceImpl.this.listenerListLock;
                    synchronized (object) {
                        for (SourceListener sourceListener : MQTTSourceImpl.this.sourceListeners) {
                            if (byArray == null) continue;
                            sourceListener.notifySourceChanged(new ByteArrayInputStream(byArray));
                        }
                        if (MQTTSourceImpl.this.preferences.useBackingFiles()) {
                            try {
                                MQTTSourceImpl.this.writeDataToFile(byArray);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                    byArray = MQTTSourceImpl.this.connection.getTopicData(this.topic);
                }
                if (MQTTSourceImpl.this.shutdown) {
                    return;
                }
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

