/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.DataManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.LocalNativeSourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;

public class LocalNativeConnectionDataImpl
extends ConnectionDataImpl {
    private static final String CLASSNAME = LocalNativeConnectionDataImpl.class.toString();
    private static final Logger TRACE = LogFactory.getTrace(LocalNativeConnectionDataImpl.class);
    private static final String DATASOURCE_TOPIC = "/datasource";
    private static final String CONFIGURATION_TOPIC = "configuration/";
    private static final String HISTORY_TOPIC = "/history/";
    private static final String CLIENT_ID = "localNative";
    private static final String COMMA = ",";
    private static String osName = System.getProperty("os.name");
    private static final String ZOS = "z/OS";
    private DataManager dataManager;
    private ArrayList<String> sourceTopics;

    private static native void regListener(LocalNativeConnectionDataImpl var0);

    private static native void deregListener();

    private static native void sendMessage(String var0, byte[] var1);

    protected LocalNativeConnectionDataImpl(String string) {
        super(string);
        TRACE.entering(CLASSNAME, "LocalNativeConnectionDataImpl()", string);
        this.isConnectionAlive = true;
        this.dataManager = new DataManager();
        this.sourceTopics = new ArrayList();
        TRACE.exiting(CLASSNAME, "LocalNativeConnectionDataImpl()", string);
    }

    public LocalNativeConnectionDataImpl() {
        super("InProcess");
        TRACE.entering(CLASSNAME, "LocalNativeConnectionDataImpl()");
        this.isConnectionAlive = true;
        this.dataManager = new DataManager();
        this.sourceTopics = new ArrayList();
        LocalNativeConnectionDataImpl.regListener(this);
        TRACE.exiting(CLASSNAME, "LocalNativeConnectionDataImpl()");
    }

    @Override
    public ConnectionType getConnectionType() {
        TRACE.entering(CLASSNAME, "getConnectionType()");
        TRACE.exiting(CLASSNAME, "getConnectionType()");
        return ConnectionType.INPROCESS;
    }

    @Override
    public boolean spawnSources(Marshaller marshaller) {
        TRACE.entering(CLASSNAME, "spawnSources()", marshaller);
        this.sendMessage("datasources", CLIENT_ID, new String[0]);
        this.sendMessage("history", CLIENT_ID, new String[0]);
        this.sendMessage("methoddictionary", "", new String[0]);
        String string = Messages.getString("AgentConnection.connected.to");
        String string2 = MessageFormat.format(string, this.getDetails());
        StatusManager.setSources(string2);
        TRACE.exiting(CLASSNAME, "spawnSources()");
        return true;
    }

    public void sendMessage(String string, String string2, String ... stringArray) {
        TRACE.entering(CLASSNAME, "sendMessage()", new Object[]{string, string2, stringArray});
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        for (String string3 : stringArray) {
            stringBuffer.append(COMMA).append(string3);
        }
        stringBuffer.trimToSize();
        if (LocalNativeConnectionDataImpl.isZOS()) {
            try {
                TRACE.fine("Sending EBCDIC bytes");
                LocalNativeConnectionDataImpl.sendMessage(string, stringBuffer.toString().getBytes("IBM-1047"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                TRACE.fine("EBCDIC failed - sending plain");
                LocalNativeConnectionDataImpl.sendMessage(string, stringBuffer.toString().getBytes());
            }
        } else {
            LocalNativeConnectionDataImpl.sendMessage(string, stringBuffer.toString().getBytes());
        }
        TRACE.exiting(CLASSNAME, "sendMessage()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveData(String string, byte[] byArray) {
        TRACE.entering(CLASSNAME, "receiveData()", string);
        String string2 = string.startsWith(CLIENT_ID) ? string.substring(CLIENT_ID.length()) : string;
        if (string2.equals(DATASOURCE_TOPIC)) {
            String string3;
            if (LocalNativeConnectionDataImpl.isZOS()) {
                try {
                    TRACE.fine("Receiving EBCDIC bytes");
                    string3 = new String(byArray, "IBM-1047");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    TRACE.fine("EBCDIC failed - receiving plain");
                    string3 = new String(byArray);
                }
            } else {
                string3 = new String(byArray);
            }
            TRACE.fine("Datasource contents = " + string3);
            String[] stringArray = string3.split(COMMA);
            String string4 = new String(stringArray[0]);
            String string5 = string3.substring(string4.length() + 1, string3.length());
            LocalNativeSourceImpl localNativeSourceImpl = new LocalNativeSourceImpl(string4, this);
            Source source = localNativeSourceImpl.spawnConfigurationSource(this, string5);
            ArrayList<String> arrayList = this.sourceTopics;
            synchronized (arrayList) {
                this.sourceTopics.add(string4);
                this.sourceTopics.add(CONFIGURATION_TOPIC + string4);
            }
            MarshallerImpl.getMarshaller().addSource(localNativeSourceImpl);
            MarshallerImpl.getMarshaller().addSource(source);
        } else if (string2.startsWith(HISTORY_TOPIC)) {
            string2 = string2.substring(HISTORY_TOPIC.length());
            if (byArray != null && byArray.length != 0) {
                this.addData(string2, byArray);
            }
        } else {
            if (string2.startsWith(CONFIGURATION_TOPIC)) {
                String string6 = string2.substring(CONFIGURATION_TOPIC.length());
                if (string6.equalsIgnoreCase("classhistogram")) {
                    string6 = "ClassHistogramSource";
                } else if (string6.equalsIgnoreCase("cpu")) {
                    string6 = "CpuSource";
                } else if (string6.equalsIgnoreCase("environment")) {
                    string6 = "EnvironmentSource";
                } else if (string6.equalsIgnoreCase("locking")) {
                    string6 = "JLASource";
                } else if (string6.equalsIgnoreCase("memory")) {
                    string6 = "MemorySource";
                } else if (string6.equalsIgnoreCase("memorycounters")) {
                    string6 = "MemoryCountersSource";
                } else if (string6.equalsIgnoreCase("methoddictionary")) {
                    string6 = "MethodDictionarySource";
                } else if (string6.equalsIgnoreCase("threads")) {
                    string6 = "ThreadsSource";
                } else if (string6.equalsIgnoreCase("trace")) {
                    string6 = "TRACESubscriberSource";
                }
                string2 = string6 + "Configuration";
            }
            this.addData(string2, byArray);
        }
        TRACE.exiting(CLASSNAME, "receiveData()", string2);
    }

    public void addData(String string, byte[] byArray) {
        TRACE.entering(CLASSNAME, "addData()", string);
        this.dataReceived(byArray.length);
        this.dataManager.addData(string, byArray);
        TRACE.exiting(CLASSNAME, "addData()", string);
    }

    public byte[] getTopicData(String string) {
        TRACE.entering(CLASSNAME, "getTopicData()", string);
        TRACE.exiting(CLASSNAME, "getTopicData()", string);
        return this.dataManager.getData(string);
    }

    @Override
    public void destroyConnection() {
        TRACE.entering(CLASSNAME, "destroyConnection()");
        if (this.isConnectionAlive) {
            LocalNativeConnectionDataImpl.deregListener();
            this.dataManager.clearData();
            this.isConnectionAlive = false;
        }
        TRACE.exiting(CLASSNAME, "destroyConnection()");
    }

    private static boolean isZOS() {
        return osName.contains(ZOS);
    }
}

