/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.datatruncation;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataStoragePreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.marshaller.HealthCenterJob;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataTruncationJob
implements HealthCenterJob {
    private static final Logger TRACE = LogFactory.getTrace(DataTruncationJob.class);
    private static final String TRUNCATION_OF_DATA_JOB = Messages.getString("DataTruncationJob.job.name");
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    protected DataBuilder data;
    private DataStoragePreferenceHelper helper;
    private String name = TRUNCATION_OF_DATA_JOB;
    private static final long BASELINE_HC = 0x2800000L;

    public DataTruncationJob(DataBuilder dataBuilder) {
        this.data = dataBuilder;
        this.helper = new DataStoragePreferenceHelper();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean dataModelIsTooLarge() {
        long l = this.helper.useMaxMemoryLimit() ? this.data.getDataPointMemoryUse() + 0x2800000L : Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().maxMemory();
        double d = (double)l / (double)l2 * 100.0;
        if (this.helper.useMaxMemoryLimit() && l > (long)this.helper.getMaxMemoryUse() || d > (double)this.helper.getMaxMemoryPercentage()) {
            String string = MessageFormat.format(Messages.getString("DataTruncationJob.memory.use"), l, l2, d);
            TRACE.log(Level.WARNING, string);
            return true;
        }
        return false;
    }

    @Override
    public long run() {
        boolean bl = this.helper.getUseSlidingWindowTruncation();
        if (this.dataModelIsTooLarge()) {
            this.data.truncateData();
            System.gc();
        }
        if (bl && this.isConnectionLive()) {
            long l = this.helper.getMinutesToKeep();
            long l2 = l * 60L * 1000L;
            long l3 = this.getLastUpdateTimeFromConnection();
            if (l3 > 0L) {
                double d = l3 - l2;
                this.data.removeOldDataBeforeTime(d, UnitLabels.MILLISECONDS_SINCE_EPOCH);
            }
        }
        return 0L;
    }

    private boolean isConnectionLive() {
        DataBuilder dataBuilder = this.data.getData(JVMLabels.CONNECTION);
        if (dataBuilder instanceof ConnectionData) {
            ConnectionData connectionData = (ConnectionData)((Object)dataBuilder);
            return connectionData.getConnectionType() == ConnectionType.JMX || connectionData.getConnectionType() == ConnectionType.MQTT || connectionData.getConnectionType() == ConnectionType.BLUEMIX;
        }
        return true;
    }

    private long getLastUpdateTimeFromConnection() {
        DataBuilder dataBuilder = this.data.getData(JVMLabels.CONNECTION);
        if (dataBuilder instanceof ConnectionData) {
            ConnectionData connectionData = (ConnectionData)((Object)dataBuilder);
            return connectionData.getLastUpdated().getTime();
        }
        return 0L;
    }
}

