/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.j9;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.healthcenter.stacks.CallSiteProvider;
import com.ibm.java.diagnostics.healthcenter.stacks.CallStack;
import com.ibm.java.diagnostics.healthcenter.stacks.StackData;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTraceDataPoint;

public class OutOfLineAllocationDataPoint
extends DataPointImpl
implements CallSiteProvider {
    private static final String EMPTY_STRING = "";
    private static final String NEWLINE = "\n";
    public static final String OOL_TRACEPOINT = "j9mm.395";
    private StackTraceDataPoint stackDataPoint;
    private Long classAddress;
    private String className;
    private Data rootData;

    public OutOfLineAllocationDataPoint(int n, double d, double d2, AxisPair axisPair, Long l, String string, Data data) {
        super(n, d, d2, axisPair);
        this.classAddress = l;
        this.className = string;
        this.rootData = data;
    }

    public String getStackTop() {
        this.getStackDataPoint();
        if (this.stackDataPoint == null) {
            return EMPTY_STRING;
        }
        return this.stackDataPoint.getStackTop();
    }

    private StackTraceDataPoint getStackDataPoint() {
        if (this.stackDataPoint == null) {
            this.stackDataPoint = StackData.findStackTrace(OOL_TRACEPOINT, this.getRawX(), this.rootData);
        }
        return this.stackDataPoint;
    }

    public Long getClassAddress() {
        return this.classAddress;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullStack() {
        this.getStackDataPoint();
        if (this.stackDataPoint == null) {
            return EMPTY_STRING;
        }
        CallStack callStack = this.stackDataPoint.getStack();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStackTop());
        for (int i = 1; i < callStack.getStackSize(); ++i) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(callStack.getStackEntry(i).getEntry());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getCallSite() {
        return this.getStackTop();
    }

    @Override
    public String getTriggerID() {
        return OOL_TRACEPOINT;
    }
}

