/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.UlimitChecker;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.CommandLineDumpOptionChecker;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.Messages;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DumpabilityChecker {
    private static final Logger TRACE = LogFactory.getTrace(DumpabilityChecker.class);
    private static final Status STATUS = Status.WARNING;

    public Status checkOptions(EnvironmentData environmentData, StructuredStringDataBuilder structuredStringDataBuilder) {
        Status status = Status.HEALTHY;
        if (environmentData != null) {
            CommandLineDumpOptionChecker commandLineDumpOptionChecker;
            Level level;
            status = this.checkUlimit(environmentData, structuredStringDataBuilder, status);
            List<String> list = environmentData.getCommandLineOptions();
            if (list != null && (level = (commandLineDumpOptionChecker = new CommandLineDumpOptionChecker(TRACE, list)).getReportPriority()) != null && level.intValue() > Level.INFO.intValue()) {
                status = STATUS;
                structuredStringDataBuilder.addProblem(commandLineDumpOptionChecker.getReport());
            }
        }
        return status;
    }

    private Status checkUlimit(Data data, StructuredStringDataBuilder structuredStringDataBuilder, Status status) {
        UlimitChecker ulimitChecker;
        Level level;
        StringDataImpl stringDataImpl;
        String string;
        Data data2 = data.getData(EnvironmentLabels.ULIMIT_CORE_LABEL);
        if (data2 instanceof StringDataImpl && (string = (stringDataImpl = (StringDataImpl)data2).getValue()) != null && string.length() > 0 && (level = (ulimitChecker = new UlimitChecker(string)).getUlimitReportPriority()) != null && level.intValue() > Level.INFO.intValue()) {
            status = STATUS;
            String string2 = MessageFormat.format(Messages.getString("DumpabilityChecker.ulimit.set"), string);
            structuredStringDataBuilder.addProblem(string2);
        }
        return status;
    }
}

