/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Random;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SourceChannelImpl;

class PipeImpl
extends Pipe {
    private static final int NUM_SECRET_BYTES = 16;
    private static final Random RANDOM_NUMBER_GENERATOR = new SecureRandom();
    private Pipe.SourceChannel source;
    private Pipe.SinkChannel sink;

    PipeImpl(SelectorProvider selectorProvider) throws IOException {
        try {
            AccessController.doPrivileged(new Initializer(selectorProvider));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    @Override
    public Pipe.SourceChannel source() {
        return this.source;
    }

    @Override
    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    private class Initializer
    implements PrivilegedExceptionAction<Void> {
        private final SelectorProvider sp;
        private IOException ioe = null;

        private Initializer(SelectorProvider selectorProvider) {
            this.sp = selectorProvider;
        }

        @Override
        public Void run() throws IOException {
            LoopbackConnector loopbackConnector = new LoopbackConnector();
            loopbackConnector.run();
            if (this.ioe instanceof ClosedByInterruptException) {
                this.ioe = null;
                Thread thread = new Thread((Runnable)loopbackConnector){

                    @Override
                    public void interrupt() {
                    }
                };
                thread.start();
                while (true) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                Thread.currentThread().interrupt();
            }
            if (this.ioe != null) {
                throw new IOException("Unable to establish loopback connection", this.ioe);
            }
            return null;
        }

        private class LoopbackConnector
        implements Runnable {
            private LoopbackConnector() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractInterruptibleChannel abstractInterruptibleChannel = null;
                AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
                AbstractInterruptibleChannel abstractInterruptibleChannel3 = null;
                try {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(16);
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(16);
                    InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
                    assert (inetAddress.isLoopbackAddress());
                    InetSocketAddress inetSocketAddress = null;
                    while (true) {
                        if (abstractInterruptibleChannel == null || !abstractInterruptibleChannel.isOpen()) {
                            abstractInterruptibleChannel = ServerSocketChannel.open();
                            try {
                                ((ServerSocketChannel)abstractInterruptibleChannel).socket().bind(new InetSocketAddress(inetAddress, 0));
                            }
                            catch (SocketException socketException) {
                                byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
                                inetAddress = InetAddress.getByAddress("localhost", byArray);
                                ((ServerSocketChannel)abstractInterruptibleChannel).socket().bind(new InetSocketAddress(inetAddress, 0));
                            }
                            inetSocketAddress = new InetSocketAddress(inetAddress, ((ServerSocketChannel)abstractInterruptibleChannel).socket().getLocalPort());
                        }
                        abstractInterruptibleChannel2 = SocketChannel.open(inetSocketAddress);
                        RANDOM_NUMBER_GENERATOR.nextBytes(byteBuffer.array());
                        do {
                            ((SocketChannel)abstractInterruptibleChannel2).write(byteBuffer);
                        } while (byteBuffer.hasRemaining());
                        byteBuffer.rewind();
                        abstractInterruptibleChannel3 = ((ServerSocketChannel)abstractInterruptibleChannel).accept();
                        do {
                            ((SocketChannel)abstractInterruptibleChannel3).read(byteBuffer2);
                        } while (byteBuffer2.hasRemaining());
                        byteBuffer2.rewind();
                        if (byteBuffer2.equals(byteBuffer)) break;
                        abstractInterruptibleChannel3.close();
                        abstractInterruptibleChannel2.close();
                    }
                    PipeImpl.this.source = new SourceChannelImpl(Initializer.this.sp, (SocketChannel)abstractInterruptibleChannel2);
                    PipeImpl.this.sink = new SinkChannelImpl(Initializer.this.sp, (SocketChannel)abstractInterruptibleChannel3);
                }
                catch (IOException iOException) {
                    try {
                        if (abstractInterruptibleChannel2 != null) {
                            abstractInterruptibleChannel2.close();
                        }
                        if (abstractInterruptibleChannel3 != null) {
                            abstractInterruptibleChannel3.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    Initializer.this.ioe = iOException;
                }
                finally {
                    try {
                        if (abstractInterruptibleChannel != null) {
                            abstractInterruptibleChannel.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

