/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.spi.CurrencyNameProvider;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.logging.PlatformLogger;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private final transient int numericCode;
    private static ConcurrentMap<String, Currency> instances = new ConcurrentHashMap<String, Currency>(7);
    private static HashSet<Currency> available;
    static int formatVersion;
    static int dataVersion;
    static int[] mainTable;
    static List<SpecialCaseEntry> specialCasesList;
    static List<OtherCurrencyEntry> otherCurrenciesList;
    private static final int MAGIC_NUMBER = 1131770436;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 512;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 480;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SIMPLE_CASE_COUNTRY_MAX_DEFAULT_DIGITS = 9;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 512;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 512;
    private static final int NUMERIC_CODE_MASK = 1047552;
    private static final int NUMERIC_CODE_SHIFT = 10;
    private static final int VALID_FORMAT_VERSION = 3;
    private static final int SYMBOL = 0;
    private static final int DISPLAYNAME = 1;

    private Currency(String string, int n, int n2) {
        this.currencyCode = string;
        this.defaultFractionDigits = n;
        this.numericCode = n2;
    }

    public static Currency getInstance(String string) {
        return Currency.getInstance(string, Integer.MIN_VALUE, 0);
    }

    private static Currency getInstance(String string, int n, int n2) {
        Currency currency;
        Currency currency2 = (Currency)instances.get(string);
        if (currency2 != null) {
            return currency2;
        }
        if (n == Integer.MIN_VALUE) {
            Object object;
            char c;
            boolean bl = false;
            if (string.length() != 3) {
                throw new IllegalArgumentException();
            }
            char c2 = string.charAt(0);
            int n3 = Currency.getMainTableEntry(c2, c = string.charAt(1));
            if ((n3 & 0x200) == 0 && n3 != 127 && string.charAt(2) - 65 == (n3 & 0x1F)) {
                n = (n3 & 0x1E0) >> 5;
                n2 = (n3 & 0xFFC00) >> 10;
                bl = true;
            } else {
                object = SpecialCaseEntry.findEntry(string);
                if (object != null) {
                    n = object[0];
                    n2 = object[1];
                    bl = true;
                }
            }
            if (!bl) {
                object = OtherCurrencyEntry.findEntry(string);
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                n = ((OtherCurrencyEntry)object).fraction;
                n2 = ((OtherCurrencyEntry)object).numericCode;
            }
        }
        return (currency2 = instances.putIfAbsent(string, currency = new Currency(string, n, n2))) != null ? currency2 : currency;
    }

    public static Currency getInstance(Locale locale) {
        char c;
        String string = locale.getCountry();
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException();
        }
        char c2 = string.charAt(0);
        int n = Currency.getMainTableEntry(c2, c = string.charAt(1));
        if ((n & 0x200) == 0 && n != 127) {
            char c3 = (char)((n & 0x1F) + 65);
            int n2 = (n & 0x1E0) >> 5;
            int n3 = (n & 0xFFC00) >> 10;
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(c3);
            return Currency.getInstance(stringBuilder.toString(), n2, n3);
        }
        if (n == 127) {
            throw new IllegalArgumentException();
        }
        if (n == 512) {
            return null;
        }
        int n4 = SpecialCaseEntry.toIndex(n);
        SpecialCaseEntry specialCaseEntry = specialCasesList.get(n4);
        if (specialCaseEntry.cutOverTime == Long.MAX_VALUE || System.currentTimeMillis() < specialCaseEntry.cutOverTime) {
            return Currency.getInstance(specialCaseEntry.oldCurrency, specialCaseEntry.oldCurrencyFraction, specialCaseEntry.oldCurrencyNumericCode);
        }
        return Currency.getInstance(specialCaseEntry.newCurrency, specialCaseEntry.newCurrencyFraction, specialCaseEntry.newCurrencyNumericCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Currency> getAvailableCurrencies() {
        Object object = Currency.class;
        synchronized (Currency.class) {
            if (available == null) {
                available = new HashSet(256);
                for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                    for (char c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
                        int n;
                        int n2 = Currency.getMainTableEntry(c, c2);
                        if ((n2 & 0x200) == 0 && n2 != 127) {
                            n = (n2 & 0x1F) + 65;
                            int n3 = (n2 & 0x1E0) >> 5;
                            int n4 = (n2 & 0xFFC00) >> 10;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(c);
                            stringBuilder.append(c2);
                            stringBuilder.append((char)n);
                            available.add(Currency.getInstance(stringBuilder.toString(), n3, n4));
                            continue;
                        }
                        if ((n2 & 0x200) != 512 || n2 == 127 || n2 == 512) continue;
                        n = SpecialCaseEntry.toIndex(n2);
                        SpecialCaseEntry specialCaseEntry = specialCasesList.get(n);
                        if (specialCaseEntry.cutOverTime == Long.MAX_VALUE || System.currentTimeMillis() < specialCaseEntry.cutOverTime) {
                            available.add(Currency.getInstance(specialCaseEntry.oldCurrency, specialCaseEntry.oldCurrencyFraction, specialCaseEntry.oldCurrencyNumericCode));
                            continue;
                        }
                        available.add(Currency.getInstance(specialCaseEntry.newCurrency, specialCaseEntry.newCurrencyFraction, specialCaseEntry.newCurrencyNumericCode));
                    }
                }
                for (OtherCurrencyEntry otherCurrencyEntry : otherCurrenciesList) {
                    available.add(Currency.getInstance(otherCurrencyEntry.currencyCode));
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = (Set)available.clone();
            return object;
        }
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getSymbol(Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
        String string = localeServiceProviderPool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, this.currencyCode, 0);
        if (string != null) {
            return string;
        }
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
        String string = localeServiceProviderPool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, this.currencyCode, 1);
        if (string != null) {
            return string;
        }
        return this.currencyCode;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable[(c - 65) * 26 + (c2 - 65)];
    }

    private static void setMainTableEntry(char c, char c2, int n) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw new IllegalArgumentException();
        }
        Currency.mainTable[(c - 65) * 26 + (c2 - 65)] = n;
    }

    private static int[] readIntArray(DataInputStream dataInputStream, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    private static List<SpecialCaseEntry> readSpecialCases(DataInputStream dataInputStream, int n) throws IOException {
        ArrayList<SpecialCaseEntry> arrayList = new ArrayList<SpecialCaseEntry>(n);
        for (int i = 0; i < n; ++i) {
            long l = dataInputStream.readLong();
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            SpecialCaseEntry specialCaseEntry = new SpecialCaseEntry(l, string, string2, n2, n3, n4, n5);
            arrayList.add(specialCaseEntry);
        }
        return arrayList;
    }

    private static List<OtherCurrencyEntry> readOtherCurrencies(DataInputStream dataInputStream, int n) throws IOException {
        ArrayList<OtherCurrencyEntry> arrayList = new ArrayList<OtherCurrencyEntry>(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            OtherCurrencyEntry otherCurrencyEntry = new OtherCurrencyEntry(string, n2, n3);
            arrayList.add(otherCurrencyEntry);
        }
        return arrayList;
    }

    private static void replaceCurrencyData(Pattern pattern, String string, String string2) {
        if (string.length() != 2) {
            Currency.info("currency.properties entry for " + string + " is ignored because of the invalid country code.", null);
            return;
        }
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.find() || matcher.group(4) == null && Currency.countOccurrences(string2, ',') >= 3) {
            Currency.info("currency.properties entry for " + string + " ignored because the value format is not recognized.", null);
            return;
        }
        try {
            if (matcher.group(4) != null && !Currency.isPastCutoverDate(matcher.group(4))) {
                Currency.info("currency.properties entry for " + string + " ignored since cutover date has not passed :" + string2, null);
                return;
            }
        }
        catch (ParseException parseException) {
            Currency.info("currency.properties entry for " + string + " ignored since exception encountered :" + parseException.getMessage(), null);
            return;
        }
        String string3 = matcher.group(1);
        int n = Integer.parseInt(matcher.group(2));
        int n2 = n << 10;
        int n3 = Integer.parseInt(matcher.group(3));
        if (n3 > 9) {
            Currency.info("currency.properties entry for " + string + " ignored since the fraction is more than " + 9 + ":" + string2, null);
            return;
        }
        int n4 = SpecialCaseEntry.indexOf(string3, n3, n);
        if (n4 == -1 && (string.charAt(0) != string3.charAt(0) || string.charAt(1) != string3.charAt(1))) {
            specialCasesList.add(new SpecialCaseEntry(string3, n3, n));
            n4 = specialCasesList.size() - 1;
        }
        n2 = n4 == -1 ? (n2 |= n3 << 5 | string3.charAt(2) - 65) : 0x200 | n4 + 1;
        Currency.setMainTableEntry(string.charAt(0), string.charAt(1), n2);
    }

    private static boolean isPastCutoverDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ROOT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        simpleDateFormat.setLenient(false);
        long l = simpleDateFormat.parse(string.trim()).getTime();
        return System.currentTimeMillis() > l;
    }

    private static int countOccurrences(String string, char c) {
        int n = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    private static void info(String string, Throwable throwable) {
        PlatformLogger platformLogger = PlatformLogger.getLogger("java.util.Currency");
        if (platformLogger.isLoggable(PlatformLogger.Level.INFO)) {
            if (throwable != null) {
                platformLogger.info(string, throwable);
            } else {
                platformLogger.info(string);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block33: {
                    Serializable serializable;
                    Object object;
                    String string;
                    String string2 = System.getProperty("java.home");
                    try {
                        string = string2 + File.separator + "lib" + File.separator + "currency.data";
                        object = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
                        serializable = null;
                        try {
                            if (((DataInputStream)object).readInt() != 1131770436) {
                                throw new InternalError("Currency data is possibly corrupted");
                            }
                            formatVersion = ((DataInputStream)object).readInt();
                            if (formatVersion != 3) {
                                throw new InternalError("Currency data format is incorrect");
                            }
                            dataVersion = ((DataInputStream)object).readInt();
                            mainTable = Currency.readIntArray((DataInputStream)object, 676);
                            int n = ((DataInputStream)object).readInt();
                            specialCasesList = Currency.readSpecialCases((DataInputStream)object, n);
                            int n2 = ((DataInputStream)object).readInt();
                            otherCurrenciesList = Currency.readOtherCurrencies((DataInputStream)object, n2);
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object != null) {
                                if (serializable != null) {
                                    try {
                                        ((FilterInputStream)object).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)serializable).addSuppressed(throwable);
                                    }
                                } else {
                                    ((FilterInputStream)object).close();
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        throw new InternalError(iOException);
                    }
                    string = System.getProperty("java.util.currency.data");
                    if (string == null) {
                        string = string2 + File.separator + "lib" + File.separator + "currency.properties";
                    }
                    try {
                        object = new File(string);
                        if (!((File)object).exists()) break block33;
                        serializable = new Properties();
                        Serializable serializable2 = null;
                        try (Object object2 = new FileReader((File)object);){
                            ((Properties)serializable).load((Reader)object2);
                        }
                        catch (Throwable throwable) {
                            serializable2 = throwable;
                            throw throwable;
                        }
                        object2 = ((Properties)serializable).stringPropertyNames();
                        serializable2 = Pattern.compile("([A-Z]{3})\\s*,\\s*(\\d{3})\\s*,\\s*(\\d+)\\s*,?\\s*(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})?");
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            Currency.replaceCurrencyData((Pattern)serializable2, string3.toUpperCase(Locale.ROOT), ((Properties)serializable).getProperty(string3).toUpperCase(Locale.ROOT));
                        }
                    }
                    catch (IOException iOException) {
                        Currency.info("currency.properties is ignored because of an IOException", iOException);
                    }
                }
                return null;
            }
        });
    }

    private static class CurrencyNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CurrencyNameProvider, String> {
        private static final CurrencyNameGetter INSTANCE = new CurrencyNameGetter();

        private CurrencyNameGetter() {
        }

        @Override
        public String getObject(CurrencyNameProvider currencyNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 1);
            int n = (Integer)objectArray[0];
            switch (n) {
                case 0: {
                    return currencyNameProvider.getSymbol(string, locale);
                }
                case 1: {
                    return currencyNameProvider.getDisplayName(string, locale);
                }
            }
            assert (false);
            return null;
        }
    }

    private static class OtherCurrencyEntry {
        private final String currencyCode;
        private final int fraction;
        private final int numericCode;

        private OtherCurrencyEntry(String string, int n, int n2) {
            this.currencyCode = string;
            this.fraction = n;
            this.numericCode = n2;
        }

        private static OtherCurrencyEntry findEntry(String string) {
            int n = otherCurrenciesList.size();
            for (int i = 0; i < n; ++i) {
                OtherCurrencyEntry otherCurrencyEntry = otherCurrenciesList.get(i);
                if (!otherCurrencyEntry.currencyCode.equalsIgnoreCase(string)) continue;
                return otherCurrencyEntry;
            }
            return null;
        }
    }

    private static class SpecialCaseEntry {
        private final long cutOverTime;
        private final String oldCurrency;
        private final String newCurrency;
        private final int oldCurrencyFraction;
        private final int newCurrencyFraction;
        private final int oldCurrencyNumericCode;
        private final int newCurrencyNumericCode;

        private SpecialCaseEntry(long l, String string, String string2, int n, int n2, int n3, int n4) {
            this.cutOverTime = l;
            this.oldCurrency = string;
            this.newCurrency = string2;
            this.oldCurrencyFraction = n;
            this.newCurrencyFraction = n2;
            this.oldCurrencyNumericCode = n3;
            this.newCurrencyNumericCode = n4;
        }

        private SpecialCaseEntry(String string, int n, int n2) {
            this(Long.MAX_VALUE, string, "", n, 0, n2, 0);
        }

        private static int indexOf(String string, int n, int n2) {
            int n3 = specialCasesList.size();
            for (int i = 0; i < n3; ++i) {
                SpecialCaseEntry specialCaseEntry = specialCasesList.get(i);
                if (!specialCaseEntry.oldCurrency.equals(string) || specialCaseEntry.oldCurrencyFraction != n || specialCaseEntry.oldCurrencyNumericCode != n2 || specialCaseEntry.cutOverTime != Long.MAX_VALUE) continue;
                return i;
            }
            return -1;
        }

        private static int[] findEntry(String string) {
            int[] nArray = null;
            int n = specialCasesList.size();
            for (int i = 0; i < n; ++i) {
                SpecialCaseEntry specialCaseEntry = specialCasesList.get(i);
                if (specialCaseEntry.oldCurrency.equals(string) && (specialCaseEntry.cutOverTime == Long.MAX_VALUE || System.currentTimeMillis() < specialCaseEntry.cutOverTime)) {
                    nArray = new int[]{specialCaseEntry.oldCurrencyFraction, specialCaseEntry.oldCurrencyNumericCode};
                    break;
                }
                if (!specialCaseEntry.newCurrency.equals(string) || System.currentTimeMillis() < specialCaseEntry.cutOverTime) continue;
                nArray = new int[]{specialCaseEntry.newCurrencyFraction, specialCaseEntry.newCurrencyNumericCode};
                break;
            }
            return nArray;
        }

        private static int toIndex(int n) {
            return (n & 0x1F) - 1;
        }
    }
}

